/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.nbt.mode;

import java.util.Arrays;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.data.nbt.mode.NBTMode;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.PrimitiveTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.StringTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Patterns;

public abstract class NBTModeComparison
extends NBTMode {
    protected String comparison;

    protected NBTModeComparison(String name) {
        super(name);
    }

    protected int compareCompound(CompoundTagAPI<?> tag) {
        return Integer.MIN_VALUE;
    }

    protected int compareList(ListTagAPI<?> tag) {
        return Integer.MIN_VALUE;
    }

    protected int comparePrimitive(PrimitiveTagAPI<?> tag) {
        Object primitive = this.parseAsPrimitive();
        switch (primitive.getClass().getSimpleName()) {
            case "Boolean": {
                return Boolean.compare(tag.asBoolean(), (Boolean)primitive);
            }
            case "Byte": {
                return Byte.compare(tag.asByte(), (Byte)primitive);
            }
            case "Double": {
                return Double.compare(tag.asDouble(), (Double)primitive);
            }
            case "Float": {
                return Float.compare(tag.asFloat(), ((Float)primitive).floatValue());
            }
            case "Integer": {
                return Integer.compare(tag.asInt(), (Integer)primitive);
            }
            case "Long": {
                return Long.compare(tag.asLong(), (Long)primitive);
            }
            case "Short": {
                return Float.compare(tag.asShort(), ((Short)primitive).shortValue());
            }
        }
        return Double.compare(tag.asDouble(), Double.parseDouble(this.comparison));
    }

    protected int compareString(StringTagAPI<?> tag) {
        return tag.getValue().compareTo(this.comparison);
    }

    protected Object parseAsPrimitive() {
        if (Patterns.matchesAny((String)this.comparison, (boolean)false, (String[])new String[]{"true", "false"})) {
            return Boolean.parseBoolean(this.comparison);
        }
        if (TextHelper.endsWithAny((String)this.comparison, (String[])new String[]{"b", "B"})) {
            return Byte.parseByte(this.comparison.substring(0, this.comparison.length() - 1));
        }
        if (TextHelper.endsWithAny((String)this.comparison, (String[])new String[]{"d", "D"})) {
            return Double.parseDouble(this.comparison.substring(0, this.comparison.length() - 1));
        }
        if (TextHelper.endsWithAny((String)this.comparison, (String[])new String[]{"f", "F"})) {
            return Float.valueOf(Float.parseFloat(this.comparison.substring(0, this.comparison.length() - 1)));
        }
        if (TextHelper.endsWithAny((String)this.comparison, (String[])new String[]{"l", "L"})) {
            return Long.parseLong(this.comparison.substring(0, this.comparison.length() - 1));
        }
        if (TextHelper.endsWithAny((String)this.comparison, (String[])new String[]{"s", "S"})) {
            return Short.parseShort(this.comparison.substring(0, this.comparison.length() - 1));
        }
        if (this.comparison.contains(".")) {
            return Double.parseDouble(this.comparison);
        }
        return Integer.parseInt(this.comparison);
    }

    @Override
    public void setSplit(String[] split) {
        this.comparison = Objects.nonNull(split) && split.length >= 1 ? split[split.length - 1] : null;
        this.split = split.length > 0 ? Arrays.copyOfRange(split, 0, split.length - 1) : new String[]{};
    }
}

