/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.jukebox;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;

public class RecordElement
extends ChannelElement {
    private static final List<String> headerLines = Arrays.asList("# Format this like `name = key`", "# The key refers to a lang key in the format of record.musictriggers.key which ", "# determines the description of the registered disc", "# Any lines that begin with `#` or do not contain `=` will not be read in", "# Make sure each new entry is on a new line", "# Here is an example", "# song1 = dragon");
    private final boolean valid;
    private String value;
    private String key;
    private AudioRef audio;

    public RecordElement(ChannelAPI channel, String line) {
        super(channel, "jukebox_element");
        this.valid = this.parse(line);
    }

    @Override
    public void close() {
        this.key = null;
        this.value = null;
    }

    @Override
    public String getName() {
        return this.key + " = " + this.value;
    }

    @Override
    public boolean isResource() {
        return true;
    }

    private boolean parse(String line) {
        if (line.startsWith("#") || !line.contains("=") || line.contains("==")) {
            return false;
        }
        this.key = line.substring(0, line.indexOf(61) - 1).trim();
        this.value = line.substring(line.indexOf(61) + 1).trim();
        if (TextHelper.isBlank((String)this.key)) {
            this.logWarn("Skipping blank redirect name from line `{}`", line);
            return false;
        }
        if (TextHelper.isBlank((String)this.value)) {
            this.logWarn("Skipping blank redirect key from line `{}`", line);
            return false;
        }
        this.logInfo("Successfully registed `{}` as a record from key `{}`", this.value, this.key);
        return true;
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    @Override
    protected String getSubTypeName() {
        return "Jukebox";
    }

    public Class<? extends ChannelElement> getTypeClass() {
        return RecordElement.class;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public AudioRef getAudio() {
        return this.audio;
    }

    @Generated
    public static List<String> getHeaderLines() {
        return headerLines;
    }

    @Generated
    public void setAudio(AudioRef audio) {
        this.audio = audio;
    }
}

