/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalElement;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalEventRunner;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class Toggle
extends GlobalElement {
    private final ChannelHelper helper;
    private final Toml table;
    private final List<From> fromThese;
    private final List<To> toThese;

    public Toggle(ChannelHelper helper, Toml table) {
        super("toggle");
        this.helper = helper;
        this.table = table;
        this.fromThese = new ArrayList<From>();
        this.toThese = new ArrayList<To>();
    }

    public void close() {
        this.fromThese.forEach(From::close);
        this.fromThese.clear();
        this.toThese.forEach(rec$ -> ((To)rec$).close());
        this.toThese.clear();
    }

    @Override
    public Collection<DataLink> getChildWrappers(MTScreenInfo parent) {
        WrapperLink from = new WrapperLink(this.fromThese);
        from.setType(parent.next("from_list", from));
        WrapperLink to = new WrapperLink(this.toThese);
        to.setType(parent.next("to_list", to));
        return Arrays.asList(from, to);
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.TOGGLE;
    }

    public int getTargetCount() {
        return this.toThese.size();
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return Toggle.class;
    }

    public boolean parse() {
        if (Objects.nonNull(this.table)) {
            Toml table;
            int n;
            int n2;
            Toml[] tomlArray;
            if (this.table.hasTable("from")) {
                tomlArray = this.table.getTableArray("from");
                n2 = tomlArray.length;
                for (n = 0; n < n2; ++n) {
                    From from = new From(this);
                    table = tomlArray[n];
                    if (!from.parse(table)) continue;
                    this.fromThese.add(from);
                }
            }
            if (this.table.hasTable("to")) {
                tomlArray = this.table.getTableArray("to");
                n2 = tomlArray.length;
                for (n = 0; n < n2; ++n) {
                    To to = new To(this);
                    table = tomlArray[n];
                    if (!to.parse(table)) continue;
                    this.toThese.add(to);
                }
            }
            return this.parse(this.table);
        }
        this.logError("Failed to parse missing table", new Object[0]);
        return false;
    }

    public void run() {
        this.toThese.forEach(To::run);
    }

    @Override
    protected Toml toTomlExtra(Toml toml) {
        toml = super.toTomlExtra(toml);
        for (From from : this.fromThese) {
            toml.addTable("from", from.toToml());
        }
        for (To to : this.toThese) {
            toml.addTable("to", to.toToml());
        }
        return toml;
    }

    @Override
    public boolean verifyRequiredParameters() {
        int errors = 0;
        for (From from2 : this.fromThese) {
            if (from2.verifyRequiredParameters()) continue;
            ++errors;
        }
        if (errors == this.fromThese.size()) {
            this.logError("At least 1 `from` table is required to be parsed successfully", new Object[0]);
            return false;
        }
        errors = 0;
        for (To to : this.toThese) {
            if (to.verifyRequiredParameters()) continue;
            ++errors;
        }
        if (errors == this.toThese.size()) {
            this.logError("At least 1 `to` table is required to be parsed successfully", new Object[0]);
            return false;
        }
        this.fromThese.forEach(from -> ((From)from).channel.getData().addActiveTriggers(from, from.getTriggers(), true));
        return true;
    }

    public static class From
    extends GlobalEventRunner {
        private final Toggle parent;
        private final Set<TriggerAPI> triggers;
        private ChannelAPI channel;

        public static From addToGui(MTScreenInfo info) {
            From from = new From((Toggle)((ParameterLink)info.getLink()).getWrapper());
            from.channel = info.getChannel();
            Parameter<?> parameter = from.getParameter("channel");
            if (Objects.nonNull(parameter)) {
                parameter.setValue(info.getChannel().getName());
            }
            return from;
        }

        public From(Toggle parent) {
            super("Toggle_From");
            this.parent = parent;
            this.triggers = new HashSet<TriggerAPI>();
        }

        @Override
        public void close() {
            this.triggers.clear();
        }

        @Override
        protected ChannelAPI getChannelReference() {
            return this.channel;
        }

        @Override
        public String getName() {
            StringJoiner joiner = new StringJoiner("+");
            this.triggers.forEach(trigger -> joiner.add(trigger.getNameWithID()));
            return String.format("From(%1$s) = %2$s", this.channel.getName(), joiner);
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.FROM;
        }

        @Override
        public String getLogPrefix() {
            return "Toggle";
        }

        @Override
        public boolean isClient() {
            return true;
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public boolean parse(Toml table) {
            return super.parse(table) && this.parseTriggers(this.channel, this.triggers);
        }

        @Override
        public void run() {
            this.parent.run();
        }

        @Override
        public boolean verifyRequiredParameters() {
            this.channel = this.parent.helper.findChannel(this, this.getParameterAsString("channel"));
            return Objects.nonNull(this.channel);
        }

        @Generated
        public Set<TriggerAPI> getTriggers() {
            return this.triggers;
        }
    }

    public static class To
    extends GlobalElement {
        private static final List<String> VALID_CONDITIONS = Arrays.asList("true", "false", "switch");
        private final Toggle parent;
        private final Set<TriggerAPI> triggers;
        private ChannelAPI channel;
        private String condition;

        public static To addToGui(MTScreenInfo info) {
            To to = new To((Toggle)((ParameterLink)info.getLink()).getWrapper());
            to.channel = info.getChannel();
            Parameter<?> parameter = to.getParameter("channel");
            if (Objects.nonNull(parameter)) {
                parameter.setValue(info.getChannel().getName());
            }
            return to;
        }

        public To(Toggle parent) {
            super("Toggle_To");
            this.parent = parent;
            this.triggers = new HashSet<TriggerAPI>();
        }

        private void close() {
            this.triggers.clear();
        }

        @Override
        public String getName() {
            StringJoiner joiner = new StringJoiner("+");
            this.triggers.forEach(trigger -> joiner.add(trigger.getNameWithID()));
            return String.format("To(%1$s) = %2$s", this.channel.getName(), this.triggers.isEmpty() ? "?" : joiner);
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.TO;
        }

        @Override
        public String getLogPrefix() {
            return "Toggle";
        }

        @Override
        public boolean parse(Toml table) {
            return super.parse(table) && this.parseTriggers(false, this.channel, this.triggers);
        }

        public void run() {
            if (this.condition.equals("switch")) {
                if (this.triggers.isEmpty()) {
                    this.channel.setEnabled(!this.channel.isEnabled());
                }
                this.triggers.forEach(TriggerAPI::switchToggle);
            } else {
                boolean on = Boolean.parseBoolean(this.condition);
                if (this.triggers.isEmpty()) {
                    this.channel.setEnabled(on);
                } else {
                    this.triggers.forEach(trigger -> trigger.setToggle(on));
                }
            }
        }

        @Override
        public boolean verifyRequiredParameters() {
            this.channel = this.parent.helper.findChannel(this, this.getParameterAsString("channel"));
            if (Objects.isNull(this.channel)) {
                return false;
            }
            String condition = this.getParameterAsString("condition");
            if (!VALID_CONDITIONS.contains(condition)) {
                this.logError("Could not match condition {} against the accepted conditions {}", condition, VALID_CONDITIONS);
                return false;
            }
            this.condition = condition;
            return true;
        }

        @Generated
        public Set<TriggerAPI> getTriggers() {
            return this.triggers;
        }
    }
}

