/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.global;

import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.global.Debug;
import mods.thecomputerizer.musictriggers.api.data.global.Toggle;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.network.MessageInitChannels;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import org.apache.logging.log4j.Level;

public class GlobalData
extends ParameterWrapper {
    private final Debug debug = new Debug();
    private Toml global;
    private String togglesPath;

    public GlobalData() {
        super("Data");
    }

    public void close() {
    }

    public ChannelHelper loadFromInit(MessageInitChannels<?> init) {
        ChannelHelper helper = new ChannelHelper(init.getUuid(), init.isClient());
        this.global = init.getGlobal();
        helper.loadFromInit(init);
        return helper;
    }

    @Override
    protected String getLogPrefix() {
        return "Global";
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.GLOBAL;
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return null;
    }

    @Override
    public void logDebug(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.DEBUG, msg, args);
    }

    @Override
    public void logError(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.ERROR, msg, args);
    }

    @Override
    public void logFatal(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.FATAL, msg, args);
    }

    @Override
    public void logInfo(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.INFO, msg, args);
    }

    @Override
    public void logTrace(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.TRACE, msg, args);
    }

    @Override
    public void logWarn(String msg, Object ... args) {
        MTLogger.log("Global", "Data", Level.WARN, msg, args);
    }

    @Nullable
    public Toml openToggles() {
        return TextHelper.isNotBlank((String)this.togglesPath) ? ChannelHelper.openToml(this.togglesPath, true, this) : null;
    }

    @Override
    public boolean parse(@Nullable Toml global) {
        this.global = global;
        if (Objects.nonNull(global)) {
            this.logInfo("Parsing global data", new Object[0]);
            if (!global.hasTable("debug")) {
                this.logError("Missing debug table!", new Object[0]);
            } else if (!this.debug.parse(global.getTable("debug"))) {
                this.logError("Failed to parse debug parameters", new Object[0]);
            }
            this.togglesPath = "config/MusicTriggers/" + (super.parse(global) ? this.getParameterAsString("toggles_path") : "toggles");
            return true;
        }
        this.logError("Tried to parse missing globals file", new Object[0]);
        return false;
    }

    public void parseToggles(ChannelHelper helper) {
        this.parseToggles(helper, this.openToggles());
    }

    public void parseToggles(ChannelHelper helper, @Nullable Toml toggles) {
        if (Objects.isNull(toggles)) {
            this.logError("Tried to parse missing toggles file", new Object[0]);
            return;
        }
        if (toggles.hasTable("toggle")) {
            for (Toml table : toggles.getTableArray("toggle")) {
                Toggle toggle = new Toggle(helper, table);
                if (!toggle.parse()) continue;
                helper.getToggles().add(toggle);
            }
        }
    }

    @Generated
    public Debug getDebug() {
        return this.debug;
    }

    @Generated
    public Toml getGlobal() {
        return this.global;
    }

    @Generated
    public String getTogglesPath() {
        return this.togglesPath;
    }
}

