/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterBool;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class Debug
extends GlobalElement {
    private final Map<String, List<String>> formattedBlockedMods = new HashMap<String, List<String>>();

    protected Debug() {
        super("Debug");
    }

    public void flipBooleanParameter(String name) {
        Parameter<?> parameter = this.getParameter(name);
        if (parameter instanceof ParameterBool) {
            ParameterBool bool;
            bool.setValue((Boolean)(bool = (ParameterBool)parameter).getValue() == false);
            this.logInfo("Successfully flipped debug parameter {} from {} to {}", name, (Boolean)bool.getValue() == false, bool.getValue());
        }
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.DEBUG;
    }

    public void setParameterValue(String name, Object value) {
        Parameter<?> parameter = this.getParameter(name);
        if (Objects.nonNull(parameter)) {
            Object old = parameter.getValue();
            this.setParameterValue(name, value, parameter);
            this.logInfo("Successfully set debug parameter {} from {} to {}", name, old, value);
        }
    }

    @Override
    public boolean parse(Toml table) {
        if (super.parse(table)) {
            this.formattedBlockedMods.clear();
            for (Object element : this.getParameterAsList("blocked_sound_categories")) {
                String pair = element.toString();
                int index = pair.indexOf(59);
                String mod = index == -1 ? "all" : pair.substring(0, index);
                String[] categories = (index == -1 ? pair : pair.substring(index + 1)).split(",");
                if (categories.length <= 0) continue;
                this.formattedBlockedMods.putIfAbsent(mod, new ArrayList());
                this.formattedBlockedMods.get(mod).addAll(Arrays.asList(categories));
            }
            return true;
        }
        return false;
    }

    @Generated
    public Map<String, List<String>> getFormattedBlockedMods() {
        return this.formattedBlockedMods;
    }
}

