/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElementRunner;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class CommandElement
extends ChannelElementRunner {
    private static final List<String> headerLines = Arrays.asList("# What are you looking at!?", "# ...", "# ...?");
    private final boolean valid;
    private String literal;
    private final List<TriggerAPI> triggers = new ArrayList<TriggerAPI>();
    private final boolean silent;

    public static CommandElement addToGui(MTScreenInfo info) {
        return new CommandElement(info.getChannel(), Toml.getEmpty(), true);
    }

    public CommandElement(ChannelAPI channel, Toml table) {
        this(channel, table, false);
    }

    CommandElement(ChannelAPI channel, Toml table, boolean silent) {
        super(channel, "command_element");
        this.silent = silent;
        this.valid = this.parse(table);
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void close() {
        this.literal = null;
        this.triggers.clear();
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public boolean parse(Toml table) {
        return super.parse(table) && this.parseTriggers(this.channel, this.triggers);
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.COMMAND;
    }

    public Class<? extends ChannelElement> getTypeClass() {
        return CommandElement.class;
    }

    @Override
    protected String getSubTypeName() {
        return "Command";
    }

    @Override
    public boolean verifyRequiredParameters() {
        if (this.hasParameter("literal")) {
            this.literal = this.getParameterAsString("literal");
            return true;
        }
        this.logMissingParameter("literal");
        return false;
    }

    @Override
    public void run() {
        super.run();
        ServerHelper.executeCommandLiteral((String)this.literal);
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public String getLiteral() {
        return this.literal;
    }

    @Generated
    public List<TriggerAPI> getTriggers() {
        return this.triggers;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public static List<String> getHeaderLines() {
        return headerLines;
    }
}

