/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ChannelInfo
extends ChannelElement {
    private final String category;
    private final String commandsPath;
    private final boolean excplicitlyOverrides;
    private final boolean hasPausedMusic;
    private final String jukeboxPath;
    private final File localFolder;
    private final String mainPath;
    private final boolean overridesMusic;
    private final boolean pausedByJukebox;
    private final boolean pausesOverrides;
    private final String redirectPath;
    private final String rendersPath;

    public static void writeExampleData(Toml table) {
        table.addComments(Arrays.asList("Auto-generated example channel - you should probably replace this with your own.", "Note that each channel can only play 1 sound at a time and trigger context is not shared between channels other than via links and toggles.", "It is recommended you keep all triggers and songs on a single channel unless you have some specific use case"));
        table.addEntry("commands", (Object)"commands");
        table.addEntry("explicitly_overrides", (Object)false);
        table.addEntry("has_paused_music", (Object)false);
        table.addEntry("jukebox", (Object)"jukebox");
        table.addEntry("local_folder", (Object)"config/MusicTriggers/songs");
        table.addEntry("main", (Object)"main");
        table.addEntry("overrides_music", (Object)true);
        table.addEntry("paused_by_jukebox", (Object)true);
        table.addEntry("pauses_overrides", (Object)false);
        table.addEntry("play_normal_music", (Object)false);
        table.addEntry("redirect", (Object)"redirect");
        table.addEntry("renders", (Object)"renders");
        table.addEntry("sound_category", (Object)"music");
    }

    public ChannelInfo(ChannelAPI channel, Toml table) {
        super(channel, "channel_info");
        if (this.parse(table)) {
            this.category = this.getParameterAsString("sound_category");
            this.commandsPath = this.getParameterAsString("commands");
            this.excplicitlyOverrides = this.getParameterAsBoolean("explicitly_overrides");
            this.hasPausedMusic = this.getParameterAsBoolean("has_paused_music");
            this.jukeboxPath = this.getParameterAsString("jukebox");
            this.localFolder = new File(this.getParameterAsString("local_folder"));
            this.mainPath = this.getParameterAsString("main");
            this.overridesMusic = !this.getParameterAsBoolean("play_normal_music");
            this.pausedByJukebox = this.getParameterAsBoolean("paused_by_jukebox");
            this.pausesOverrides = this.getParameterAsBoolean("pauses_overrides");
            this.redirectPath = this.getParameterAsString("redirect");
            this.rendersPath = this.getParameterAsString("renders");
        } else {
            this.category = "music";
            this.commandsPath = "commands";
            this.excplicitlyOverrides = false;
            this.hasPausedMusic = false;
            this.jukeboxPath = "jukebox";
            this.localFolder = new File("config/MusicTriggers/songs");
            this.mainPath = "main";
            this.overridesMusic = true;
            this.pausedByJukebox = true;
            this.pausesOverrides = false;
            this.redirectPath = "redirect";
            this.rendersPath = "renders";
        }
        if (!this.localFolder.exists() && !this.localFolder.mkdirs()) {
            this.logError("Unable to make songs folder at path `{}`! Local files will be unable to load.", this.localFolder);
        }
    }

    public boolean canReadFiles() {
        return Objects.nonNull(this.localFolder) && this.localFolder.exists() && this.localFolder.isDirectory();
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.CHANNEL_INFO;
    }

    @Override
    protected String getSubTypeName() {
        return "Info";
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return ChannelInfo.class;
    }

    public boolean hasPausedMusic() {
        return this.hasPausedMusic;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public void close() {
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getCommandsPath() {
        return this.commandsPath;
    }

    @Generated
    public boolean isExcplicitlyOverrides() {
        return this.excplicitlyOverrides;
    }

    @Generated
    public String getJukeboxPath() {
        return this.jukeboxPath;
    }

    @Generated
    public File getLocalFolder() {
        return this.localFolder;
    }

    @Generated
    public String getMainPath() {
        return this.mainPath;
    }

    @Generated
    public boolean isOverridesMusic() {
        return this.overridesMusic;
    }

    @Generated
    public boolean isPausedByJukebox() {
        return this.pausedByJukebox;
    }

    @Generated
    public boolean isPausesOverrides() {
        return this.pausesOverrides;
    }

    @Generated
    public String getRedirectPath() {
        return this.redirectPath;
    }

    @Generated
    public String getRendersPath() {
        return this.rendersPath;
    }
}

