/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;

public abstract class ChannelElement
extends ParameterWrapper
implements ChannelEventHandler {
    protected final ChannelAPI channel;

    protected ChannelElement(ChannelAPI channel, String name) {
        super(name);
        this.channel = channel;
    }

    protected ChannelElement(ChannelAPI channel, String name, @Nullable MTDataRef.TableRef ref) {
        super(name, ref);
        this.channel = channel;
    }

    @Override
    public void activate() {
    }

    public boolean checkResource() {
        return !this.isResource() || this.channel.isClientChannel() && ChannelHelper.getLoader().areResourcesLoaded();
    }

    @Override
    public void deactivate() {
    }

    public String getChannelName() {
        return Objects.nonNull(this.channel) ? this.channel.getName() : "unknown";
    }

    public String getChannelLogPrefix() {
        return (Objects.nonNull(this.channel) ? this.channel.getLogType() : "UNKNOWN") + " | Channel";
    }

    @Override
    protected String getLogPrefix() {
        return this.getChannelLogPrefix() + "[" + this.getChannelName() + "]: " + this.getSubTypeName();
    }

    protected abstract String getSubTypeName();

    public abstract boolean isResource();

    @Override
    public void play(boolean unpaused) {
    }

    @Override
    public void playable() {
    }

    @Override
    public void playing(boolean unpaused) {
    }

    @Override
    public void queue() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void tickActive(boolean unpaused) {
    }

    @Override
    public void tickPlayable(boolean unpaused) {
    }

    @Override
    public String toString() {
        return this.getSubTypeName() + "[" + this.getName() + "]";
    }

    @Override
    public void unplayable() {
    }

    @Generated
    public ChannelAPI getChannel() {
        return this.channel;
    }
}

