/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.channel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.audio.AudioContainer;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioHelper;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelInfo;
import mods.thecomputerizer.musictriggers.api.data.command.CommandElement;
import mods.thecomputerizer.musictriggers.api.data.jukebox.RecordElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.redirect.RedirectElement;
import mods.thecomputerizer.musictriggers.api.data.render.CardAPI;
import mods.thecomputerizer.musictriggers.api.data.render.CardHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerCombination;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerMerged;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerRegistry;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerSynced;
import mods.thecomputerizer.musictriggers.api.data.trigger.basic.BasicTrigger;
import mods.thecomputerizer.musictriggers.api.network.MessageInitChannels;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ChannelData
extends ChannelElement {
    private final Set<AudioRef> audio = new HashSet<AudioRef>();
    private final Set<CardAPI> cards = new HashSet<CardAPI>();
    private final Set<CommandElement> commands = new HashSet<CommandElement>();
    private final Set<RecordElement> records = new HashSet<RecordElement>();
    private final Set<RedirectElement> redirects = new HashSet<RedirectElement>();
    private final Set<TriggerAPI> triggers = new HashSet<TriggerAPI>();
    private final Map<TriggerAPI, Collection<ChannelEventHandler>> triggerEventMap = new HashMap<TriggerAPI, Collection<ChannelEventHandler>>();
    private final Map<Class<? extends ChannelElement>, UniversalParameters> universalMap = this.initUniversals();
    private BasicTrigger genericTrigger;
    private BasicTrigger loadingTrigger;
    private BasicTrigger menuTrigger;

    public ChannelData(ChannelAPI channel) {
        super(channel, "channel_data");
    }

    public <E extends ChannelEventHandler> void addActiveTriggers(Collection<E> elements, Function<E, Collection<TriggerAPI>> triggers, boolean isEvent) {
        for (ChannelEventHandler element : elements) {
            this.addActiveTriggers(element, triggers.apply(element), isEvent);
        }
    }

    public <E extends ChannelEventHandler> void addActiveTriggers(E element, Collection<TriggerAPI> triggers, boolean isEvent) {
        TriggerAPI active = null;
        for (TriggerAPI trigger : this.triggerEventMap.keySet()) {
            if (!trigger.matches(triggers)) continue;
            active = trigger;
            break;
        }
        if (Objects.isNull(active)) {
            if (triggers.size() == 1) {
                for (TriggerAPI trigger : triggers) {
                    if (!Objects.nonNull(trigger)) continue;
                    active = trigger;
                    break;
                }
            } else {
                active = TriggerCombination.make(this.channel, triggers);
            }
            if (Objects.nonNull(active)) {
                this.triggerEventMap.put(active, new HashSet());
            }
        }
        if (Objects.nonNull(active) && isEvent) {
            this.triggerEventMap.get(active).add(element);
        }
    }

    protected boolean addBasicTrigger(BasicTrigger trigger) {
        switch (trigger.getName()) {
            case "generic": {
                this.genericTrigger = trigger;
                return true;
            }
            case "loading": {
                this.loadingTrigger = trigger;
                return true;
            }
            case "menu": {
                this.menuTrigger = trigger;
                return true;
            }
        }
        return false;
    }

    protected void addEmptyTriggers() {
        for (TriggerAPI trigger : this.triggers) {
            if (trigger instanceof BasicTrigger && this.addBasicTrigger((BasicTrigger)trigger)) continue;
            boolean needsAdding = true;
            for (TriggerAPI active : this.triggerEventMap.keySet()) {
                if (active instanceof TriggerCombination) {
                    if (!((TriggerCombination)active).isContained(trigger)) continue;
                    needsAdding = false;
                    break;
                }
                if (!active.matches(trigger)) continue;
                needsAdding = false;
                break;
            }
            if (!needsAdding) continue;
            this.triggerEventMap.put(trigger, new HashSet());
        }
    }

    protected void addUniversals(Map<Class<? extends ChannelElement>, UniversalParameters> map) {
        map.put(AudioRef.class, UniversalParameters.get(this.channel, MTDataRef.UNIVERSAL_AUDIO));
        map.put(TriggerAPI.class, UniversalParameters.get(this.channel, MTDataRef.UNIVERSAL_TRIGGERS));
    }

    public void afterTriggerSync(Map<TriggerAPI, TriggerSynced> syncedMap) {
        for (TriggerAPI trigger : this.triggerEventMap.keySet()) {
            trigger.afterSync(syncedMap);
        }
    }

    protected void appendUniversals() {
        this.logDebug("Appending {} universal types", this.universalMap.size());
        for (Map.Entry<Class<? extends ChannelElement>, UniversalParameters> entry : this.universalMap.entrySet()) {
            for (Collection<ChannelEventHandler> handlers : this.triggerEventMap.values()) {
                for (ChannelEventHandler handler : handlers) {
                    ParameterWrapper wrapper;
                    if (!(handler instanceof ParameterWrapper) || (wrapper = (ParameterWrapper)((Object)handler)).getTypeClass() != entry.getKey()) continue;
                    wrapper.setUniversals(entry.getValue());
                }
            }
        }
    }

    @Override
    public void close() {
        this.closeHandlers(this.audio);
        this.closeHandlers(this.cards);
        this.closeHandlers(this.commands);
        this.closeHandlers(this.records);
        this.closeHandlers(this.redirects);
        this.closeHandlers(this.triggers);
        for (Map.Entry<TriggerAPI, Collection<ChannelEventHandler>> entry : this.triggerEventMap.entrySet()) {
            entry.getKey().close();
            this.closeHandlers(entry.getValue());
        }
        this.triggerEventMap.clear();
        this.universalMap.clear();
        this.genericTrigger = null;
        this.loadingTrigger = null;
        this.menuTrigger = null;
    }

    private void closeHandlers(Collection<? extends ChannelEventHandler> handlers) {
        for (ChannelEventHandler channelEventHandler : handlers) {
            channelEventHandler.close();
        }
        handlers.clear();
    }

    public void collectSpecialHandlers(Collection<ChannelEventHandler> handlers) {
        if (Objects.nonNull(this.loadingTrigger)) {
            handlers.add(this.loadingTrigger);
        }
        if (Objects.nonNull(this.menuTrigger)) {
            handlers.add(this.menuTrigger);
        }
        handlers.addAll(this.records);
    }

    protected void extractActiveTriggers() {
        this.setupAudioPools();
        this.addActiveTriggers(this.cards, CardAPI::getTriggers, true);
        this.addActiveTriggers(this.commands, CommandElement::getTriggers, true);
    }

    public Collection<ChannelEventHandler> getActiveEventHandlers() {
        return this.getEventHandlers(this.channel.getActiveTrigger());
    }

    @Nullable
    public AudioPool getActivePool() {
        return this.channel.getSelector().getActivePool();
    }

    public Collection<ChannelEventHandler> getEventHandlers(@Nullable TriggerAPI trigger) {
        if (trigger instanceof TriggerMerged) {
            HashSet<ChannelEventHandler> handlers = new HashSet<ChannelEventHandler>();
            handlers.add(trigger);
            for (TriggerAPI t : ((TriggerMerged)trigger).getTriggers()) {
                for (ChannelEventHandler handler : this.getEventHandlers(t)) {
                    if (handler == t) continue;
                    handlers.add(handler);
                }
            }
            return Collections.unmodifiableSet(handlers);
        }
        if (Objects.nonNull(trigger)) {
            Collection<ChannelEventHandler> c = this.triggerEventMap.get(trigger);
            return Objects.nonNull(c) ? Collections.unmodifiableCollection(c) : Collections.emptySet();
        }
        return Collections.emptySet();
    }

    private String getFilePath(String path) {
        return "config/MusicTriggers/" + this.getChannelName() + "/" + path;
    }

    @Override
    protected String getLogPrefix() {
        return this.getChannelLogPrefix();
    }

    @Override
    public String getName() {
        return String.format("data(%1$s)", this.getChannelName());
    }

    public Collection<ChannelEventHandler> getPlayableEventHandlers() {
        HashSet<ChannelEventHandler> handlers = new HashSet<ChannelEventHandler>();
        Collection<TriggerAPI> playables = this.channel.getPlayableTriggers();
        for (TriggerAPI playable : this.triggerEventMap.keySet()) {
            if (!playable.isContained(playables)) continue;
            handlers.addAll(this.getEventHandlers(playable));
        }
        return Collections.unmodifiableSet(handlers);
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return ChannelData.class;
    }

    @Override
    protected String getSubTypeName() {
        return "ChannelData";
    }

    @Nullable
    public UniversalParameters getUniversals(Class<? extends ChannelElement> clazz) {
        return this.universalMap.get(clazz);
    }

    boolean implyTrigger(String name, String id) {
        TriggerAPI trigger = TriggerRegistry.getTriggerInstance(this.channel, name);
        if (Objects.nonNull(trigger) && trigger.imply(id)) {
            trigger.successfullyParsed();
            this.triggers.add(trigger);
            return true;
        }
        return false;
    }

    private Map<Class<? extends ChannelElement>, UniversalParameters> initUniversals() {
        HashMap<Class<? extends ChannelElement>, UniversalParameters> map = new HashMap<Class<? extends ChannelElement>, UniversalParameters>();
        this.addUniversals(map);
        return map;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    public void load(MessageInitChannels.ChannelMessage message) {
        this.logInfo("Loading external data", new Object[0]);
        this.readRedirect(message.getRedirects());
        this.readMain(message.getTomls().get("main"));
        this.readRenders(message.getTomls().get("renders"));
        this.readCommands(message.getTomls().get("commands"));
        this.readJukebox(message.getRecords());
        this.organize();
        this.setupRecords();
        this.logInfo("Finished loading external data", new Object[0]);
    }

    public void loadTracks(boolean loadResources) {
        this.logInfo("Loading {} audio tracks", this.audio.size());
        this.audio.forEach(ref -> {
            String name = ref.getName();
            boolean found = false;
            for (RedirectElement redirect : this.redirects) {
                if (!name.equals(redirect.getKey())) continue;
                found = true;
                if (!redirect.isRemote() && !loadResources) break;
                ref.loadRemote(redirect.getValue());
                break;
            }
            if (!found) {
                String file = ref.getParameterAsString("location");
                ref.loadLocal(TextHelper.isNotBlank((String)file) && !"_".equals(file) ? file : ref.getName());
            }
        });
    }

    public void loadResourceTracks() {
        this.audio.forEach(ref -> {
            if (!ref.isLoaded() && !ref.isLoading()) {
                String name = ref.getName();
                for (RedirectElement redirect : this.redirects) {
                    if (!name.equals(redirect.getName())) continue;
                    if (!redirect.isResource()) break;
                    ref.loadRemote(redirect.getValue());
                    break;
                }
            }
        });
    }

    public void organize() {
        this.extractActiveTriggers();
        this.addEmptyTriggers();
        this.triggerEventMap.forEach((trigger, handlers) -> {
            handlers.add(trigger);
            this.logInfo("{} is mapped to event handlers {}", trigger, handlers);
        });
        this.appendUniversals();
    }

    public void parse() {
        this.logInfo("Parsing local data", new Object[0]);
        ChannelInfo info = this.channel.getInfo();
        this.readRedirect(ChannelHelper.openTxt(this.getFilePath(info.getRedirectPath()), this));
        this.readMain(ChannelHelper.openToml(this.getFilePath(info.getMainPath()), true, this));
        this.readRenders(ChannelHelper.openToml(this.getFilePath(info.getRendersPath()), true, this));
        this.readCommands(ChannelHelper.openToml(this.getFilePath(info.getCommandsPath()), true, this));
        this.readJukebox(ChannelHelper.openTxt(this.getFilePath(info.getJukeboxPath()), this));
        this.organize();
        this.setupRecords();
        this.logInfo("Finished parsing local data", new Object[0]);
    }

    public void readCommands(@Nullable Toml commands) {
        if (Objects.isNull(commands)) {
            return;
        }
        for (Toml table : commands.getAllTables()) {
            CommandElement command = new CommandElement(this.getChannel(), table);
            if (!command.isValid()) continue;
            this.commands.add(command);
        }
    }

    public void readJukebox(Collection<String> lines) {
        lines.forEach(line -> {
            RecordElement record = new RecordElement(this.getChannel(), (String)line);
            if (record.isValid()) {
                this.records.add(record);
            }
        });
    }

    public void readMain(@Nullable Toml main) {
        if (Objects.isNull(main)) {
            return;
        }
        TriggerHelper.parseTriggers(this.getChannel(), this.triggers, main.getTable("triggers"));
        AudioHelper.parseAudio(this.getChannel(), this.audio, main.getTable("songs"));
    }

    public void readRedirect(Collection<String> lines) {
        lines.forEach(line -> {
            RedirectElement redirect = new RedirectElement(this.getChannel(), (String)line);
            if (redirect.isValid()) {
                this.redirects.add(redirect);
            }
        });
    }

    public void readRenders(@Nullable Toml renders) {
        if (Objects.isNull(renders)) {
            return;
        }
        CardHelper.parseImageCards(this.channel, this.cards, renders.getTableArray("image"));
        CardHelper.parseTitleCards(this.channel, this.cards, renders.getTableArray("title"));
    }

    protected void setupAudioPools() {
        for (AudioRef ref : this.audio) {
            this.addActiveTriggers(ref, ref.getTriggers(), false);
            TriggerAPI trigger = null;
            for (TriggerAPI active : this.triggerEventMap.keySet()) {
                if (!active.matches(ref.getTriggers())) continue;
                trigger = active;
                break;
            }
            if (Objects.isNull(trigger)) {
                return;
            }
            AudioPool pool = trigger.getAudioPool();
            if (Objects.isNull(pool)) {
                pool = new AudioPool(trigger);
            }
            pool.injectHandlers(ref, this.triggerEventMap.get(trigger));
        }
    }

    public void setupLinkTargets() {
        this.logInfo("Setting up link targets", new Object[0]);
        for (TriggerAPI trigger : this.triggers) {
            for (TriggerAPI.Link link : trigger.getLinks()) {
                link.setupTarget();
            }
        }
    }

    private void setupRecords() {
        for (RecordElement record : this.records) {
            AudioRef ref = null;
            String key = record.getKey();
            for (AudioRef audio : this.audio) {
                if (!audio.getName().equals(key)) continue;
                ref = audio;
                break;
            }
            if (Objects.isNull(ref)) {
                ref = this.channel.isClientChannel() ? new AudioContainer(this.channel, key) : new AudioRef(this.channel, key);
                this.audio.add(ref);
            }
            record.setAudio(ref);
        }
    }

    @Generated
    public Set<AudioRef> getAudio() {
        return this.audio;
    }

    @Generated
    public Set<CardAPI> getCards() {
        return this.cards;
    }

    @Generated
    public Set<CommandElement> getCommands() {
        return this.commands;
    }

    @Generated
    public Set<RecordElement> getRecords() {
        return this.records;
    }

    @Generated
    public Set<RedirectElement> getRedirects() {
        return this.redirects;
    }

    @Generated
    public Set<TriggerAPI> getTriggers() {
        return this.triggers;
    }

    @Generated
    public Map<TriggerAPI, Collection<ChannelEventHandler>> getTriggerEventMap() {
        return this.triggerEventMap;
    }

    @Generated
    public Map<Class<? extends ChannelElement>, UniversalParameters> getUniversalMap() {
        return this.universalMap;
    }

    @Generated
    public BasicTrigger getGenericTrigger() {
        return this.genericTrigger;
    }

    @Generated
    public BasicTrigger getLoadingTrigger() {
        return this.loadingTrigger;
    }

    @Generated
    public BasicTrigger getMenuTrigger() {
        return this.menuTrigger;
    }
}

