/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionCoreMod;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@MultiVersionCoreMod(modid="musictriggers", modName="Music Triggers", modVersion="7.0.4")
public class MTCoreEntryPoint
extends CoreEntryPoint {
    static final String EMPTY_DESC = ASMRef.EMPTY_METHOD.getDescriptor();
    static final String HANDLER_BINARY = MTCoreEntryPoint.getHandlerBinary();
    static final String HANDLER_NAME = Objects.nonNull(HANDLER_BINARY) ? HANDLER_BINARY.replace('.', '/') : null;
    static final String HELPER_NAME = "mods/thecomputerizer/musictriggers/api/data/channel/ChannelHelper";
    static final String TICKER_BINARY = MTCoreEntryPoint.getTickerBinary();
    static final String TICKER_NAME = Objects.nonNull(TICKER_BINARY) ? TICKER_BINARY.replace('.', '/') : null;
    static final String TICKER_DESC = TypeHelper.methodDesc((Type)Type.BOOLEAN_TYPE);
    static final String TICKER_GC_BINARY = MTCoreEntryPoint.getTickerGCBinary();
    static final String TICKER_GC_NAME = Objects.nonNull(TICKER_GC_BINARY) ? TICKER_GC_BINARY.replace('.', '/') : null;
    static final String TICKER_SA_BINARY = MTCoreEntryPoint.getTickerSABinary();
    static final String TICKER_SA_NAME = Objects.nonNull(TICKER_SA_BINARY) ? TICKER_SA_BINARY.replace('.', '/') : null;
    final CoreAPI core = CoreAPI.getInstance();
    List<String> targets;

    static String getHandlerBinary() {
        CoreAPI core = CoreAPI.getInstance();
        if (!core.isClientSide()) {
            return null;
        }
        boolean fabric = core.getModLoader().isFabric();
        if (core.getVersion().isV12()) {
            return "net.minecraft.client.audio.SoundHandler";
        }
        if (core.getVersion().isV16()) {
            return fabric ? "net.minecraft.class_1144" : "net.minecraft.client.audio.SoundHandler";
        }
        return fabric ? "net.minecraft.class_1144" : "net.minecraft.client.sounds.SoundManager";
    }

    static String getTickerBinary() {
        CoreAPI core = CoreAPI.getInstance();
        if (!core.isClientSide()) {
            return null;
        }
        boolean fabric = core.getModLoader().isFabric();
        if (core.getVersion().isV12()) {
            return "net.minecraft.client.audio.MusicTicker";
        }
        if (core.getVersion().isV16()) {
            return fabric ? "net.minecraft.class_1142" : "net.minecraft.client.audio.MusicTicker";
        }
        return fabric ? "net.minecraft.class_1142" : "net.minecraft.client.sounds.MusicManager";
    }

    static String getTickerGCBinary() {
        CoreAPI core = CoreAPI.getInstance();
        if (!core.isClientSide() || !core.getVersion().isV12()) {
            return null;
        }
        return "micdoodle8.mods.galacticraft.core.client.sounds.MusicTickerGC";
    }

    static String getTickerSABinary() {
        CoreAPI core = CoreAPI.getInstance();
        if (!core.isClientSide() || !core.getVersion().isV12()) {
            return null;
        }
        return "spaceambient.core.sounds.Ambient_MusicTicker";
    }

    public MTCoreEntryPoint() {
        TILRef.logInfo((String)"Constructing MTCoreEntryPoint on ClassLoader {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getClassLoader()});
        if (this.core.isClientSide()) {
            TILRef.logInfo((String)"SoundHandler name is {}", (Object[])new Object[]{HANDLER_NAME});
            TILRef.logInfo((String)"MusicTicker name is {}", (Object[])new Object[]{TICKER_NAME});
        }
    }

    public List<String> classTargets() {
        if (Objects.isNull(this.targets)) {
            this.targets = this.core.isClientSide() ? (Objects.nonNull(TICKER_GC_BINARY) ? (Objects.nonNull(TICKER_SA_BINARY) ? Arrays.asList(HANDLER_BINARY, TICKER_BINARY, TICKER_GC_BINARY, TICKER_SA_BINARY) : Arrays.asList(HANDLER_BINARY, TICKER_BINARY, TICKER_GC_BINARY)) : Arrays.asList(HANDLER_BINARY, TICKER_BINARY)) : Collections.emptyList();
        }
        TILRef.logInfo((String)"Collecting class targets as {}", (Object[])new Object[]{this.targets});
        return this.targets;
    }

    String collectTickerNames() {
        if (CoreAPI.isNamedEnv()) {
            return "tick";
        }
        if (this.core.getVersion().isV12()) {
            return "func_73660_a";
        }
        if (this.core.getVersion().isV16()) {
            return "func_73660_a method_18669";
        }
        return "m_120183_ method_18669";
    }

    String collectVolumeNames() {
        if (CoreAPI.isNamedEnv()) {
            return "updateSourceVolume";
        }
        if (this.core.getVersion().isV12()) {
            return "func_184399_a";
        }
        if (this.core.getVersion().isV16()) {
            return "func_184399_a method_4865";
        }
        return "m_120358_ method_4865";
    }

    public ClassNode editClass(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (this.volumeQuery(classNode, method, this.collectVolumeNames().split(" "))) continue;
            this.fixMusicTicker(classNode, method, this.collectTickerNames().split(" "));
        }
        return classNode;
    }

    boolean equalsAny(String name, String ... others) {
        for (String other : others) {
            if (!other.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void fixMusicTicker(ClassNode classNode, MethodNode node, String ... names) {
        String className = this.getClassName(classNode);
        if (this.core.getVersion().isV12() ? !this.equalsAny(className, TICKER_NAME, TICKER_GC_NAME, TICKER_SA_NAME) : !TICKER_NAME.equals(className)) {
            return;
        }
        if (this.equalsAny(this.core.mapMethodName(classNode.name, node.name, node.desc), names)) {
            InsnList ifIns = this.beginList(new InsnList()).insInvokeStatic(HELPER_NAME, "stopVanillaMusicTicker", TICKER_DESC).insIf(154, new Label()).insBasic(177).insLabel().endList();
            ifIns.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            node.instructions.insertBefore(node.instructions.getFirst(), ifIns);
            TILRef.logInfo((String)"Injected music ticker override to {}", (Object[])new Object[]{node.name});
        }
    }

    public String getCoreID() {
        return "musictriggers_core";
    }

    public String getCoreName() {
        return "Music Triggers Core";
    }

    public boolean volumeQuery(ClassNode classNode, MethodNode node, String ... names) {
        String className = this.getClassName(classNode);
        if (!HANDLER_NAME.equals(className)) {
            return false;
        }
        if (this.equalsAny(this.core.mapMethodName(classNode.name, node.name, node.desc), names)) {
            node.instructions.insertBefore(node.instructions.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, HELPER_NAME, "updateVolumeSources", EMPTY_DESC));
            TILRef.logInfo((String)"Injected channel volume query to {}", (Object[])new Object[]{node.name});
            return true;
        }
        return false;
    }
}

