/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.config;

import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.config.ConfigVersion;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class MTConfigV7
extends ConfigVersion {
    public static final MTConfigV7 LATEST = new MTConfigV7("7.0.4".split("\\.")){};
    public static final MTConfigV7 V7_0_0 = new MTConfigV7(0, 0){

        @Override
        public ConfigVersion getVersionTarget() {
            return LATEST;
        }
    };
    public static final MTConfigV7 V7_0_0_BETA_10 = new MTConfigV7(0, 0, "beta", 10){

        @Override
        public ConfigVersion getVersionTarget() {
            return LATEST;
        }
    };
    public static final MTConfigV7 V7_0_0_BETA_4 = new MTConfigV7(0, 0, "beta", 4){

        @Override
        public ConfigVersion getVersionTarget() {
            return LATEST;
        }
    };
    public static final MTConfigV7 V7_0_0_BETA_3 = new MTConfigV7(0, 0, "beta", 3){

        @Override
        public ConfigVersion getVersionTarget() {
            return LATEST;
        }
    };
    public static final MTConfigV7 V7_0_0_BETA_1 = new MTConfigV7(0, 0, "beta", 1){

        @Override
        public ConfigVersion getVersionTarget() {
            return LATEST;
        }
    };

    private static int minorVersion(String split) {
        return Integer.parseInt(split.contains("+") ? split.substring(0, split.indexOf(43)) : split);
    }

    protected MTConfigV7(String ... versionSplit) {
        super(Integer.parseInt(versionSplit[0]), Integer.parseInt(versionSplit[1]), MTConfigV7.minorVersion(versionSplit[2]));
        this.logInfo("Set latest config version to {}", this.getVersion());
    }

    protected MTConfigV7(int major, int minor) {
        super(7, major, minor);
    }

    protected MTConfigV7(int major, int minor, String qualifierName, int qualifierBuild) {
        super(7, major, minor, qualifierName, qualifierBuild);
    }

    @Override
    public String getPathMain(Toml channel) {
        return "config/MusicTriggers/" + channel.getName() + "/" + (String)channel.getOrSetValue("main", (Object)"main");
    }

    @Override
    public Toml getGlobal() {
        return ChannelHelper.openToml("config/MusicTriggers/global", false, this);
    }

    @Override
    public Toml getRenders(Toml channel) {
        String path = "config/MusicTriggers/" + channel.getName() + "/" + channel.getValueString("renders");
        return ChannelHelper.openToml(path, false, this);
    }

    @Override
    public Toml getToggles(Toml global) {
        String path = "config/MusicTriggers/" + global.getValueString("toggles_path");
        return ChannelHelper.openToml(path, false, this);
    }

    @Override
    public ConfigVersion getVersionTarget() {
        return this;
    }

    @Override
    public Toml.TomlEntry<?> remapAudioEntry(Toml.TomlEntry<?> entry) {
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapChannelInfoEntry(String channel, Toml.TomlEntry<?> entry) {
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapDebugEntry(Toml.TomlEntry<?> entry) {
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapLinkEntry(String trigger, Toml.TomlEntry<?> entry) {
        return entry.getKey().equals("channel") ? new Toml.TomlEntry("target_channel", entry.getValue()) : entry;
    }

    @Override
    public Toml.TomlEntry<?> remapToggleFrom(Toml.TomlEntry<?> entry) {
        return entry.getKey().equals("condition") ? new Toml.TomlEntry("event", entry.getValue()) : entry;
    }

    @Override
    public Toml.TomlEntry<?> remapToggleTo(Toml.TomlEntry<?> entry) {
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapTriggerEntry(String name, Toml.TomlEntry<?> entry) {
        switch (entry.getKey()) {
            case "health": {
                return new Toml.TomlEntry("max_health", entry.getValue());
            }
            case "health_percentage": {
                return new Toml.TomlEntry("max_health_percentage", entry.getValue());
            }
        }
        return entry;
    }

    @Override
    public String remapTriggerName(String name) {
        return name;
    }

    @Override
    @Nullable
    public Toml upgradeToTable(MTDataRef.TableRef ref, Toml.TomlEntry<?> entry) {
        if (ref == MTDataRef.FROM && entry.getKey().equals("event")) {
            String value;
            Toml table = Toml.getEmpty();
            switch (value = String.valueOf(entry.getValue())) {
                case "active": {
                    table.addEntry("name", (Object)"activate");
                    break;
                }
                case "playable": {
                    table.addEntry("name", (Object)"playable");
                }
            }
            return table;
        }
        return null;
    }

    @Override
    public void verifyJukebox(Toml channel) {
    }

    @Override
    public void verifyRedirct(Toml channel) {
    }
}

