/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.config.ConfigVersion;
import mods.thecomputerizer.musictriggers.api.config.ConfigVersionManager;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class MTConfigV6
extends ConfigVersion {
    public static final MTConfigV6 V6_3_1 = new MTConfigV6(3, 1);

    protected MTConfigV6(int major, int minor) {
        super(6, major, minor);
    }

    @Override
    public Toml getGlobal() {
        Toml channels;
        Toml global = Toml.getEmpty();
        Toml debug = ChannelHelper.openToml("config/MusicTriggers/debug", false, this);
        if (Objects.nonNull(debug)) {
            Toml registration = ChannelHelper.openToml("config/MusicTriggers/registration", false, this);
            if (Objects.nonNull(registration)) {
                Toml.TomlEntry entry = registration.getEntry("CLIENT_SIDE_ONLY");
                if (Objects.nonNull(entry)) {
                    debug.addEntry(entry.getKey(), entry.getValue());
                }
                if (Objects.nonNull(entry = registration.getEntry("REGISTER_DISCS"))) {
                    debug.addEntry(entry.getKey(), entry.getValue());
                }
                FileHelper.get((String)"config/MusicTriggers/registration.toml", (boolean)false).delete();
            }
            global.addTable("debug", debug);
            FileHelper.get((String)"config/MusicTriggers/debug.toml", (boolean)false).delete();
        }
        if (Objects.nonNull(channels = ChannelHelper.openToml("config/MusicTriggers/channels", false, this))) {
            global.addTable("channels", channels);
            FileHelper.get((String)"config/MusicTriggers/channels.toml", (boolean)false).delete();
        }
        return global;
    }

    @Override
    public String getPathMain(Toml channel) {
        return "config/MusicTriggers/" + (String)channel.getOrSetValue("main", (Object)(channel.getName() + "/main"));
    }

    @Override
    public Toml getRenders(Toml channel) {
        File file;
        String path = "config/MusicTriggers/" + (String)channel.getOrSetValue("transitions", (Object)(channel.getName() + "/transitions"));
        Toml renders = ChannelHelper.openToml(path, false, this);
        if (Objects.nonNull(renders) && (file = FileHelper.get((String)(path + ".toml"), (boolean)false)).getName().contains("transitions")) {
            file.renameTo(new File(file.getParent(), file.getName().replace("transitions", "renders")));
        }
        return renders;
    }

    @Override
    public Toml getToggles(Toml global) {
        Toml toggles = Toml.getEmpty();
        Toml channels = global.getTable("channels");
        if (Objects.nonNull(channels)) {
            for (Toml channel : channels.getAllTables()) {
                String path = "config/MusicTriggers/" + (String)channel.getOrSetValue("toggles", (Object)(channel.getName() + "/toggles"));
                Toml channelToggles = ChannelHelper.openToml(path, false, this);
                if (!Objects.nonNull(channelToggles)) continue;
                for (Toml toggle : channelToggles.getAllTables()) {
                    toggles.addTable(toggle.getName(), toggle);
                }
                FileHelper.get((String)(path + ".toml"), (boolean)false).delete();
            }
        }
        toggles.addComments(this.getHeaderLines("toggles"));
        MTDataRef.writeToFile(toggles, "config/MusicTriggers/" + (String)global.getOrSetValue("toggles_path", (Object)"toggles"));
        return toggles;
    }

    @Override
    public ConfigVersion getVersionTarget() {
        return ConfigVersionManager.findLatestQualified(7, 0, 0);
    }

    @Override
    public Toml.TomlEntry<?> remapAudioEntry(Toml.TomlEntry<?> entry) {
        return entry.getKey().equals("must_finish") ? new Toml.TomlEntry("interrupt_handler", entry.getValue()) : entry;
    }

    @Override
    public Toml.TomlEntry<?> remapChannelInfoEntry(String channel, Toml.TomlEntry<?> entry) {
        String key;
        switch (key = entry.getKey()) {
            case "commands": 
            case "jukebox": 
            case "main": 
            case "redirect": 
            case "transitions": {
                String path;
                Toml.TomlEntry transformed = entry;
                String string = key = "transitions".equals(key) ? "renders" : key;
                if (!key.equals(entry.getKey())) {
                    transformed = new Toml.TomlEntry(key, transformed.getValue());
                }
                path = (path = entry.getValue().toString()).startsWith(channel) ? path.substring(channel.length() + 1) : path;
                path = path.replace("transitions", "renders");
                if (!transformed.getValue().equals(path)) {
                    transformed = new Toml.TomlEntry(transformed.getKey(), (Object)path);
                }
                return transformed;
            }
            case "explicit_overrides": {
                return new Toml.TomlEntry("explicitly_overrides", entry.getValue());
            }
            case "overrides_normal_music": {
                return new Toml.TomlEntry("overrides_music", entry.getValue());
            }
            case "pause_overrides": {
                return new Toml.TomlEntry("pauses_overrides", entry.getValue());
            }
            case "songs_folder": {
                return new Toml.TomlEntry("local_folder", entry.getValue());
            }
            case "toggles": {
                return null;
            }
        }
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapDebugEntry(Toml.TomlEntry<?> entry) {
        switch (entry.getKey()) {
            case "ALLOW_TIMESTAMPS": {
                return new Toml.TomlEntry("allow_timestamps", entry.getValue());
            }
            case "BLOCK_STREAMING_ONLY": {
                return new Toml.TomlEntry("block_sound_effects", entry.getValue());
            }
            case "BLOCKED_MOD_CATEGORIES": {
                return new Toml.TomlEntry("blocked_sound_categories", entry.getValue());
            }
            case "CLIENT_SIDE_ONLY": {
                return new Toml.TomlEntry("client_only", entry.getValue());
            }
            case "COMBINE_EQUAL_PRIORITY": {
                return new Toml.TomlEntry("independent_audio_pools", entry.getValue());
            }
            case "CURRENT_SONG_ONLY": {
                return new Toml.TomlEntry("show_song_info", entry.getValue());
            }
            case "ENCODING_QUALITY": {
                return new Toml.TomlEntry("encoding_quality", entry.getValue());
            }
            case "INTERRUPTED_AUDIO_CATEGORIES": {
                return new Toml.TomlEntry("interrupted_sound_categories", entry.getValue());
            }
            case "LOG_LEVEL": 
            case "MAX_HOVER_ELEMENTS": {
                return null;
            }
            case "PAUSE_WHEN_TABBED": {
                return new Toml.TomlEntry("pause_unless_focused", entry.getValue());
            }
            case "PLAY_NORMAL_MUSIC": {
                return new Toml.TomlEntry("play_normal_music", entry.getValue());
            }
            case "REGISTER_DISCS": {
                return new Toml.TomlEntry("enable_discs", entry.getValue());
            }
            case "RESAMPLING_QUALITY": {
                return new Toml.TomlEntry("resampling_quality", entry.getValue());
            }
            case "REVERSE_PRIORITY": {
                return new Toml.TomlEntry("reverse_priority", entry.getValue());
            }
            case "SHOW_DEBUG": {
                return new Toml.TomlEntry("enable_debug_info", entry.getValue());
            }
        }
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapLinkEntry(String trigger, Toml.TomlEntry<?> entry) {
        return entry.getKey().equals("channel") ? new Toml.TomlEntry("target_channel", entry.getValue()) : entry;
    }

    @Override
    public Toml.TomlEntry<?> remapToggleFrom(Toml.TomlEntry<?> entry) {
        return entry.getKey().equals("condition") ? new Toml.TomlEntry("event", entry.getValue()) : entry;
    }

    @Override
    public Toml.TomlEntry<?> remapToggleTo(Toml.TomlEntry<?> entry) {
        return entry;
    }

    @Override
    public Toml.TomlEntry<?> remapTriggerEntry(String name, Toml.TomlEntry<?> entry) {
        switch (entry.getKey()) {
            case "biome_category": {
                return new Toml.TomlEntry("biome_tag", entry.getValue());
            }
            case "check_higher_rainfall": {
                return new Toml.TomlEntry("rainfall_greater_than", entry.getValue());
            }
            case "check_lower_temp": {
                return new Toml.TomlEntry("temperature_greater_than", entry.getValue());
            }
            case "health": {
                return new Toml.TomlEntry("max_health", entry.getValue());
            }
            case "level": {
                switch (name) {
                    case "lowhp": {
                        return new Toml.TomlEntry("max_health_percentage", entry.getValue());
                    }
                    case "raid": {
                        return new Toml.TomlEntry("wave", entry.getValue());
                    }
                    case "season": {
                        return new Toml.TomlEntry("season", entry.getValue());
                    }
                }
                return entry;
            }
            case "song_delay": {
                return new Toml.TomlEntry("ticks_between_audio", entry.getValue());
            }
            case "start_delay": {
                return new Toml.TomlEntry("ticks_before_active", entry.getValue());
            }
            case "start_toggled": {
                return new Toml.TomlEntry("start_as_disabled", entry.getValue());
            }
            case "stop_delay": {
                return new Toml.TomlEntry("active_cooldown", entry.getValue());
            }
            case "trigger_delay": {
                return new Toml.TomlEntry("ticks_before_audio", entry.getValue());
            }
        }
        return entry;
    }

    @Override
    public String remapTriggerName(String name) {
        return name.equals("fallingstars") ? "starshower" : name;
    }

    @Override
    @Nullable
    public Toml upgradeToTable(MTDataRef.TableRef ref, Toml.TomlEntry<?> entry) {
        if (ref == MTDataRef.FROM && entry.getKey().equals("event")) {
            String value;
            Toml table = Toml.getEmpty();
            switch (value = String.valueOf(entry.getValue())) {
                case "active": {
                    table.addEntry("name", (Object)"activate");
                    break;
                }
                case "playable": {
                    table.addEntry("name", (Object)"playable");
                }
            }
            return table;
        }
        return ref == MTDataRef.AUDIO && entry.getKey().equals("interrupt_handler") ? Toml.getEmpty() : null;
    }

    @Override
    public void verifyJukebox(Toml channel) {
        String path = "config/MusicTriggers/" + (String)channel.getOrSetValue("jukebox", (Object)(channel.getName() + "/jukebox"));
        List<String> oldLines = ChannelHelper.openTxt(path, this);
        oldLines.removeIf(str -> TextHelper.isEmpty((String)str) || str.startsWith("Format this like name") || str.startsWith("The key refers to a lang key") || str.startsWith("determines the description of the") || str.startsWith("Any lines with Format in the name") || str.startsWith("Make sure each new entry is on a new line"));
        ArrayList<String> lines = new ArrayList<String>();
        for (String headerLine : this.getHeaderLines("jukebox")) {
            lines.add("#" + headerLine);
        }
        lines.addAll(oldLines);
        FileHelper.writeLines((String)(path + ".txt"), lines, (boolean)false);
    }

    @Override
    public void verifyRedirct(Toml channel) {
        String path = "config/MusicTriggers/" + (String)channel.getOrSetValue("redirect", (Object)(channel.getName() + "/redirect"));
        List<String> oldLines = ChannelHelper.openTxt(path, this);
        oldLines.removeIf(str -> TextHelper.isEmpty((String)str) || str.startsWith("Format this like name") || str.startsWith("If you are trying to redirect to an already") || str.startsWith("Any lines with Format in the name") || str.startsWith("Make sure each new entry is on a new line"));
        ArrayList<String> lines = new ArrayList<String>();
        for (String headerLine : this.getHeaderLines("redirect")) {
            lines.add("#" + headerLine);
        }
        lines.addAll(oldLines);
        FileHelper.writeLines((String)(path + ".txt"), lines, (boolean)false);
    }
}

