/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.config.ConfigRemapper;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerRegistry;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlRemapper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.apache.logging.log4j.Level;

public abstract class ConfigVersion
implements LoggableAPI {
    protected final Version version;

    protected ConfigVersion(int release, int major, int minor) {
        this(new Version(release, major, minor));
    }

    protected ConfigVersion(int release, int major, int minor, String qualifierName, int qualifierBuild) {
        this(release, major, minor, new Qualifier(qualifierName, qualifierBuild));
    }

    protected ConfigVersion(int release, int major, int minor, Qualifier qualifier) {
        this(new Version(release, major, minor, qualifier));
    }

    protected ConfigVersion(Version version) {
        this.version = version;
    }

    protected boolean addMissingRequiredParameters(Toml trigger) {
        String name;
        switch (name = trigger.getName()) {
            case "height": {
                if (!trigger.hasEntry("level")) {
                    trigger.addEntry("level", (Object)0);
                    return true;
                }
                return false;
            }
            case "time": {
                String id;
                if (trigger.hasEntry("time_bundle") || trigger.hasEntry("start_hour")) {
                    return false;
                }
                if (trigger.hasEntry("end_hour")) {
                    trigger.addEntry("start_hour", (Object)Float.valueOf(0.0f));
                    return true;
                }
                if (trigger.hasEntry("identifier") && TextHelper.isNotBlank((String)(id = (String)trigger.getEntryString("identifier").getValue()))) {
                    if ("morning".equals(id = id.toLowerCase().trim())) {
                        id = "sunrise";
                    } else if ("evening".equals(id)) {
                        id = "sunset";
                    } else if (Misc.equalsAny((Object)id, (Object[])new String[]{"afternoon", "daytime", "noon"})) {
                        id = "day";
                    } else if ("nighttime".equals(id)) {
                        id = "night";
                    }
                    if (Misc.equalsAny((Object)id, (Object[])new String[]{"day", "night", "sunrise", "sunset"})) {
                        trigger.addEntry("time_bundle", (Object)id);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public List<String> getHeaderLines(String name) {
        switch (name) {
            case "commands": {
                return Arrays.asList(" Commands header!", " Line 2");
            }
            case "global": {
                return Arrays.asList(" Global header!", " Line 2");
            }
            case "jukebox": {
                return Arrays.asList(" Jukebox header!", " Line 2");
            }
            case "main": {
                return Arrays.asList(" Main header!", " Line 2");
            }
            case "redirect": {
                return Arrays.asList(" Redirect header!", " Line 2");
            }
            case "renders": {
                return Arrays.asList(" Renders header!", " Line 2");
            }
            case "toggles": {
                return Arrays.asList(" Toggles header!", " Line 2");
            }
        }
        return Collections.emptyList();
    }

    public abstract Toml getGlobal();

    public abstract String getPathMain(Toml var1);

    @Nullable
    public TomlRemapper getRemapper(final @Nullable MTDataRef.TableRef ref) {
        String name;
        if (Objects.isNull(ref)) {
            return null;
        }
        switch (name = ref.getName()) {
            case "audio": 
            case "universal_audio": {
                return new TomlRemapper(this){
                    final /* synthetic */ ConfigVersion this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return null;
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        Toml table = this.this$0.upgradeToTable(ref, entry = this.this$0.remapAudioEntry(entry));
                        if (Objects.nonNull(table)) {
                            parent.addTable(entry.getKey(), table);
                            return null;
                        }
                        return entry;
                    }
                };
            }
            case "channel": {
                return new TomlRemapper(){

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return null;
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml toml, Toml.TomlEntry<?> entry) {
                        return ConfigVersion.this.remapChannelInfoEntry(toml.getName(), entry);
                    }
                };
            }
            case "channels": {
                return new TomlRemapper(){

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return ConfigVersion.this.getRemapper(MTDataRef.CHANNEL_INFO);
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        return entry;
                    }
                };
            }
            case "link": {
                return new TomlRemapper(){

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return null;
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        return ConfigVersion.this.remapLinkEntry(parent.getParent().getName(), entry);
                    }
                };
            }
            case "from": {
                return new TomlRemapper(this){
                    final /* synthetic */ ConfigVersion this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Nullable
                    public TomlRemapper getNextRemapper(String name) {
                        return null;
                    }

                    public String remapTable(String table) {
                        return table;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        Toml table = this.this$0.upgradeToTable(ref, entry = this.this$0.remapToggleFrom(entry));
                        if (Objects.nonNull(table)) {
                            parent.addTable(entry.getKey(), table);
                            return null;
                        }
                        return entry;
                    }
                };
            }
            case "global": 
            case "main": 
            case "toggles": {
                return new ConfigRemapper(ref){

                    @Override
                    public TomlRemapper getNextRemapper(MTDataRef.TableRef next) {
                        return ConfigVersion.this.getRemapper(next);
                    }
                };
            }
            case "debug": {
                return new TomlRemapper(){

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return null;
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        return ConfigVersion.this.remapDebugEntry(entry);
                    }
                };
            }
            case "songs": {
                return new TomlRemapper(){

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return ConfigVersion.this.getRemapper("universal".equals(table) ? MTDataRef.UNIVERSAL_AUDIO : MTDataRef.AUDIO);
                    }

                    public String remapTable(String name) {
                        return name;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml toml, Toml.TomlEntry<?> entry) {
                        return entry;
                    }
                };
            }
            case "to": {
                return new TomlRemapper(this){
                    final /* synthetic */ ConfigVersion this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Nullable
                    public TomlRemapper getNextRemapper(String name) {
                        return null;
                    }

                    public String remapTable(String table) {
                        return table;
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        Toml table = this.this$0.upgradeToTable(ref, entry = this.this$0.remapToggleTo(entry));
                        if (Objects.nonNull(table)) {
                            parent.addTable(entry.getKey(), table);
                            return null;
                        }
                        return entry;
                    }
                };
            }
            case "triggers": {
                return new TomlRemapper(this){
                    final /* synthetic */ ConfigVersion this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Nullable
                    public TomlRemapper getNextRemapper(String table) {
                        return this.this$0.getRemapper("universal".equals(table) ? MTDataRef.UNIVERSAL_TRIGGERS : ref.findChild(table));
                    }

                    public String remapTable(String name) {
                        return this.this$0.remapTriggerName(name);
                    }

                    public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                        return entry;
                    }
                };
            }
        }
        if (name.equals("universal_triggers") || TriggerRegistry.isRegistred(name)) {
            return new TomlRemapper(this){
                final /* synthetic */ ConfigVersion this$0;
                {
                    this.this$0 = this$0;
                }

                @Nullable
                public TomlRemapper getNextRemapper(String name) {
                    return this.this$0.getRemapper(ref.findChild(name));
                }

                public boolean remap(Toml toml) {
                    boolean remapped = super.remap(toml);
                    return this.this$0.addMissingRequiredParameters(toml) || remapped;
                }

                public String remapTable(String name) {
                    return name;
                }

                public Toml.TomlEntry<?> remapEntry(Toml parent, Toml.TomlEntry<?> entry) {
                    return this.this$0.remapTriggerEntry(parent.getName(), entry);
                }
            };
        }
        return null;
    }

    public abstract Toml getRenders(Toml var1);

    public abstract Toml getToggles(Toml var1);

    public abstract ConfigVersion getVersionTarget();

    public boolean hasCloserQualiferThan(ConfigVersion version, int closest) {
        return this.hasCloserQualiferThan(version.version, closest);
    }

    public boolean hasCloserQualiferThan(Version version, int closest) {
        if (Objects.isNull(version.qualifier)) {
            return false;
        }
        return this.version.hasCloserQualiferThan(version.qualifier.name, version.qualifier.build, closest);
    }

    @Override
    public void logDebug(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.DEBUG, msg, args);
    }

    @Override
    public void logError(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.ERROR, msg, args);
    }

    @Override
    public void logFatal(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.FATAL, msg, args);
    }

    @Override
    public void logInfo(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.INFO, msg, args);
    }

    @Override
    public void logTrace(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.TRACE, msg, args);
    }

    @Override
    public void logWarn(String msg, Object ... args) {
        MTLogger.log("ConfigMapper", this.version.toString(), Level.WARN, msg, args);
    }

    public void remap() {
        ConfigVersion target = this.getVersionTarget();
        if (Objects.isNull(target) || this == target) {
            this.logInfo("Config version is up to date", new Object[0]);
            return;
        }
        this.logInfo("Remapping from {} to target {}", this.version, target.version);
        Toml global = this.getGlobal();
        if (Objects.nonNull(global)) {
            this.getToggles(global);
            Toml channels = global.getTable("channels");
            if (Objects.nonNull(channels)) {
                this.logInfo("Remapping channels", new Object[0]);
                for (Toml channel : channels.getAllTables()) {
                    this.getRenders(channel);
                    this.verifyJukebox(channel);
                    this.verifyRedirct(channel);
                    this.logInfo("Remapping channel " + channel.getName(), new Object[0]);
                    String mainPath = this.getPathMain(channel);
                    Toml main = ChannelHelper.openToml(mainPath, false, this);
                    if (!Objects.nonNull(main)) continue;
                    this.writeIfRemapped(main, MTDataRef.TABLE_MAP.get("main"), mainPath);
                }
            }
            this.logInfo("Remapping global configs", new Object[0]);
            this.writeIfRemapped(global, MTDataRef.TABLE_MAP.get("global"), "config/MusicTriggers/global");
        }
        this.logInfo("Successfully remapped config files!", new Object[0]);
    }

    public abstract Toml.TomlEntry<?> remapAudioEntry(Toml.TomlEntry<?> var1);

    public abstract Toml.TomlEntry<?> remapChannelInfoEntry(String var1, Toml.TomlEntry<?> var2);

    public abstract Toml.TomlEntry<?> remapDebugEntry(Toml.TomlEntry<?> var1);

    public abstract Toml.TomlEntry<?> remapLinkEntry(String var1, Toml.TomlEntry<?> var2);

    public abstract Toml.TomlEntry<?> remapToggleFrom(Toml.TomlEntry<?> var1);

    public abstract Toml.TomlEntry<?> remapToggleTo(Toml.TomlEntry<?> var1);

    public abstract Toml.TomlEntry<?> remapTriggerEntry(String var1, Toml.TomlEntry<?> var2);

    public abstract String remapTriggerName(String var1);

    @Nullable
    public abstract Toml upgradeToTable(MTDataRef.TableRef var1, Toml.TomlEntry<?> var2);

    public abstract void verifyJukebox(Toml var1);

    public abstract void verifyRedirct(Toml var1);

    public boolean similar(Version version) {
        return this.version.similar(version);
    }

    protected void writeIfRemapped(Toml toml, MTDataRef.TableRef ref, String path) {
        TomlRemapper remapper = this.getRemapper(ref);
        if (Objects.nonNull(remapper) && remapper.remap(toml)) {
            this.logInfo("Writing to {}", path);
            toml.clearComments();
            toml.addComments(this.getHeaderLines(ref.getName()));
            MTDataRef.writeToFile(toml, path);
        }
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    public static final class Version {
        private final int release;
        private final int major;
        private final int minor;
        private final Qualifier qualifier;

        public Version(int release, int major, int minor) {
            this(release, major, minor, null);
        }

        public Version(int release, int major, int minor, Qualifier qualifier) {
            this.release = release;
            this.major = major;
            this.minor = minor;
            this.qualifier = qualifier;
        }

        public boolean equals(Object other) {
            if (other instanceof Version) {
                Version version = (Version)other;
                if (this.release == version.release && this.major == version.major && this.minor == version.minor) {
                    return Objects.isNull(this.qualifier) ? Objects.isNull(version.qualifier) : Objects.nonNull(version.qualifier) && this.qualifier.equals(version.qualifier);
                }
            }
            return false;
        }

        public boolean similar(Version version) {
            return this.release == version.release && this.major == version.major && this.minor == version.minor;
        }

        public boolean hasCloserQualiferThan(String qualifierName, int qualiferBuild, int closest) {
            if (Objects.isNull(this.qualifier)) {
                return true;
            }
            return this.qualifier.isCloserThan(qualifierName, qualiferBuild, closest);
        }

        public String toString() {
            String str = this.release + "." + this.major + "." + this.minor;
            return Objects.nonNull(this.qualifier) ? str + this.qualifier : str;
        }

        @Generated
        public int getRelease() {
            return this.release;
        }

        @Generated
        public int getMajor() {
            return this.major;
        }

        @Generated
        public int getMinor() {
            return this.minor;
        }

        @Generated
        public Qualifier getQualifier() {
            return this.qualifier;
        }
    }

    public static final class Qualifier {
        private final String name;
        private final int build;

        public Qualifier(String name, int build) {
            this.name = name;
            this.build = build;
        }

        public boolean equals(Object other) {
            if (other instanceof Qualifier) {
                Qualifier qual = (Qualifier)other;
                return this.name.equals(qual.name) && this.build == qual.build;
            }
            return false;
        }

        public boolean isCloserThan(String name, int build, int closest) {
            return this.name.equals(name) && this.build <= build && build - this.build < closest;
        }

        public String toString() {
            return "+" + this.name + "-" + this.build;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getBuild() {
            return this.build;
        }
    }
}

