/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.common;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.client.MTClientEntryPoint;
import mods.thecomputerizer.musictriggers.api.common.MTCommonEvents;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.registry.MTRegistryHandler;
import mods.thecomputerizer.musictriggers.api.server.MTServerEvents;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.common.DelegatingCommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionMod;
import org.burningwave.core.assembler.StaticComponentContainer;

@MultiVersionMod(modDescription="Multiversion mod for playing music and sounds based on in-game triggers.", modid="musictriggers", modName="Music Triggers", modVersion="7.0.4")
public class MTCommonEntryPoint
extends DelegatingCommonEntryPoint {
    public MTCommonEntryPoint() {
        MTRef.logDebug("Constructing MTCommonEntryPoint on ClassLoader {}", ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getLoader(CoreAPI instance) {
        String loaderName = instance.getModLoader().toString();
        return CoreAPI.ModLoader.LEGACY.toString().equals(loaderName) ? loaderName.toLowerCase() : "shared";
    }

    private Class<?> findVersionEntryClass(CoreAPI instance) {
        MTRef.logDebug("Finding version entrypoint on ClassLoader {}", instance.getClass().getClassLoader());
        CoreAPI.GameVersion version = instance.getVersion();
        String loader = this.getLoader(instance);
        String className = "mods.thecomputerizer.musictriggers." + loader + "." + version.getPkg() + ".common.MTCommonEntryPoint";
        className = className + version.getName().replace('.', '_');
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (TILDev.DEV && version.isV12()) {
            String versionStr = "/legacy/1.12/";
            HashSet<String> contains = new HashSet<String>(Arrays.asList("/api/", "/" + loader + "/", versionStr));
            ClassHelper.checkBurningWaveInit();
            block4: for (URL url : StaticComponentContainer.ClassLoaders.getURLs(ClassLoader.getSystemClassLoader())) {
                for (String contain : contains) {
                    if (!url.toString().contains(contain)) continue;
                    try {
                        instance.addURLToClassLoader(contextLoader, url);
                        continue block4;
                    }
                    catch (Exception ex) {
                        MTRef.logError("ok", ex);
                        continue block4;
                    }
                }
            }
        }
        try {
            Class clazz = ClassHelper.findClass((String)className, (boolean)true, (ClassLoader)contextLoader);
            if (Objects.nonNull(clazz)) {
                MTRef.logInfo("Successfully located versioned entrypoint {} to {}", clazz, clazz.getClassLoader());
            } else {
                MTRef.logError("Why is the class null {}", className);
            }
            return clazz;
        }
        catch (Exception ex) {
            MTRef.logError("Caught exception getting version entrypoint class {}", className, ex);
            return null;
        }
    }

    protected String getModID() {
        return "musictriggers";
    }

    protected String getModName() {
        return "Music Triggers";
    }

    public void onConstructed() {
        File configDir = new File("config/MusicTriggers");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Unable to create file directory at config/MusicTriggers! Music Triggers is unable to load any further.");
        }
        MTNetwork.initCommon();
        super.onConstructed();
    }

    public void onDedicatedServerSetup() {
        ChannelHelper.generateDedicatedServerFiles();
    }

    public void onPreRegistration() {
        MTRegistryHandler.init();
        MTCommonEvents.init();
        MTServerEvents.init();
        super.onPreRegistration();
    }

    @Nullable
    public ClientEntryPoint setDelegatedClientHandle() {
        return MTClientEntryPoint.getInstance();
    }

    public CommonEntryPoint setDelegatedCustomHandle() {
        if (!TILDev.DEV || !CoreAPI.isV12()) {
            return null;
        }
        CommonEntryPoint instance = null;
        Class<?> versionClass = this.findVersionEntryClass(CoreAPI.getInstance());
        if (Objects.nonNull(versionClass)) {
            try {
                ClassHelper.checkBurningWaveInit();
                instance = (CommonEntryPoint)StaticComponentContainer.Methods.invokeStatic(versionClass, "getInstance", new Object[0]);
            }
            catch (Throwable t) {
                MTRef.logFatal("Unable to instantiate versioned instance!", t);
            }
        } else {
            MTRef.logError("Versioned entrypoint not found! Things might not work properly", new Object[0]);
        }
        return instance;
    }
}

