/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.SpecialButton;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.command.CommandElement;
import mods.thecomputerizer.musictriggers.api.data.global.Toggle;
import mods.thecomputerizer.musictriggers.api.data.jukebox.RecordElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.redirect.RedirectElement;
import mods.thecomputerizer.musictriggers.api.data.render.TitleElement;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Button;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class WrapperLink
extends DataLink {
    private final Set<WrapperElement> wrappers = new HashSet<WrapperElement>();
    private final Set<WrapperElement> otherWrappers;

    public WrapperLink(Collection<? extends ParameterWrapper> wrappers) {
        this(false, wrappers, Collections.emptySet());
    }

    public WrapperLink(Collection<? extends ParameterWrapper> wrappers, Collection<? extends ParameterWrapper> otherWrappers) {
        this(true, wrappers, otherWrappers);
    }

    private WrapperLink(boolean dual, Collection<? extends ParameterWrapper> wrappers, Collection<? extends ParameterWrapper> otherWrappers) {
        super(dual);
        for (ParameterWrapper parameterWrapper : wrappers) {
            this.wrappers.add(new WrapperElement(this, parameterWrapper));
        }
        this.otherWrappers = new HashSet<WrapperElement>();
        for (ParameterWrapper parameterWrapper : otherWrappers) {
            this.otherWrappers.add(new WrapperElement(this, parameterWrapper));
        }
    }

    private DataList addElements(MTGUIScreen screen, double x, double width, Collection<WrapperElement> wrappers, boolean left) {
        DataList list = new DataList(x, 0.0, width, 1.8, 0.05);
        ArrayList<WrapperElement> ordered = new ArrayList<WrapperElement>(wrappers);
        ordered.sort(Comparator.comparing(e -> e.getDisplayName().toString()));
        for (WrapperElement element : ordered) {
            Button button = list.makeButton(element.getDisplayName(), b -> {
                if (!this.deleteElement(list, (Button)b, element, wrappers)) {
                    MTGUIScreen.open(MTGUIScreen.constructScreen(screen, element.link.type, ClientHelper.getWindow(), ClientHelper.getGuiScale()));
                }
            });
            button.addHoverLine(element.getDescription());
            element.widget = button;
            list.addWidget((Widget)button);
        }
        SpecialButton add = list.makeSpecialButton(this.type.getSpecialLang("gui", "button.add_entry.name"), b -> {
            Collection widgets = list.getWidgets();
            for (Widget w : widgets) {
                if (!(w instanceof Button) || ((Button)w).getText().getColor() != ColorHelper.RED) continue;
                return;
            }
            widgets.remove(b);
            this.addNewWrapper(screen, list, wrappers, left);
            widgets.add(b);
            list.setWidgets(widgets);
            this.setModified(true);
        });
        add.getText().setColor(ColorHelper.GRAY.withAlpha(0.7f));
        add.setContextFunc(b -> {
            SpecialButton special = (SpecialButton)((Object)b);
            boolean delete = special.isDeleting();
            b.getText().setColor(delete ? ColorHelper.GRAY.withAlpha(0.7f) : ColorHelper.RED);
            TextAPI<?> text = this.type.getSpecialLang("gui", "button." + (delete ? "add" : "remove") + "_entry.name");
            b.setText(text);
            b.setHoverText(h -> {
                h.setColor(delete ? ColorHelper.AQUA : ColorHelper.DARK_RED);
                h.setText(text);
            });
            special.setDeleting(!delete);
            ScreenHelper.playVanillaClickSound();
        });
        list.addWidget((Widget)add);
        return list;
    }

    public void addNewWrapper(MTGUIScreen screen, DataList list, Collection<WrapperElement> wrappers, ParameterWrapper wrapper) {
        WrapperElement element = this.getElementFor(wrapper);
        wrappers.add(element);
        Collection widgets = list.getWidgets();
        Widget widget = null;
        for (Widget w2 : widgets) {
            if (!(w2 instanceof SpecialButton)) continue;
            widget = w2;
            break;
        }
        if (Objects.nonNull(widget)) {
            widgets.remove(widget);
        }
        Button button = list.makeButton(element.getDisplayName(), b -> {
            if (!this.deleteElement(list, (Button)b, element, wrappers)) {
                MTGUIScreen.open(MTGUIScreen.constructScreen(screen, element.link.type, ClientHelper.getWindow(), ClientHelper.getGuiScale()));
            }
        });
        button.addHoverLine(element.getDescription());
        element.widget = button;
        list.addWidget((Widget)button);
        if (list.getWidgets() instanceof List) {
            ((List)list.getWidgets()).sort(Comparator.comparing(w -> ((Button)w).getText().toString()));
        }
        if (Objects.nonNull(widget)) {
            list.addWidget(widget);
        }
    }

    public void addNewWrapper(MTGUIScreen screen, DataList list, Collection<WrapperElement> wrappers, boolean left) {
        ParameterWrapper wrapper = null;
        ChannelAPI channel = this.type.getChannel();
        switch (this.type.getType()) {
            case "commands": {
                wrapper = CommandElement.addToGui(screen.getTypeInfo());
                break;
            }
            case "from_list": {
                wrapper = Toggle.From.addToGui(screen.getTypeInfo().getParent());
                break;
            }
            case "jukebox": {
                wrapper = new RecordElement(channel, "key = value");
                break;
            }
            case "links": {
                wrapper = TriggerAPI.Link.addToGui(screen.getTypeInfo().getParent());
                break;
            }
            case "loops": {
                wrapper = AudioRef.Loop.addToGui(screen.getTypeInfo().getParent());
                break;
            }
            case "main": {
                if (left) {
                    this.type.openAudioSelectionScreen(screen, list, wrappers);
                    break;
                }
                this.type.openTriggerSelectionScreen(screen, list, wrappers);
                break;
            }
            case "redirect": {
                wrapper = new RedirectElement(channel, "key = value");
                break;
            }
            case "renders": {
                Toml toml = Toml.getEmpty();
                if (left) {
                    this.type.openImageSelectionScreen(screen, list, wrappers);
                    break;
                }
                toml.addEntry("titles", new ArrayList());
                wrapper = new TitleElement(channel);
                wrapper.parse(toml);
                break;
            }
            case "to_list": {
                wrapper = Toggle.To.addToGui(screen.getTypeInfo().getParent());
                break;
            }
            case "toggles": {
                wrapper = new Toggle(channel.getHelper(), Toml.getEmpty());
            }
        }
        if (Objects.nonNull(wrapper)) {
            this.addNewWrapper(screen, list, wrappers, wrapper);
        }
    }

    private boolean deleteElement(DataList list, Button b, WrapperElement element, Collection<WrapperElement> wrappers) {
        Collection widgets = list.getWidgets();
        boolean remove = false;
        for (Widget widget : widgets) {
            if (!(widget instanceof SpecialButton) || !((SpecialButton)widget).isDeleting()) continue;
            remove = true;
            break;
        }
        if (remove) {
            widgets.remove(b);
            wrappers.remove(element);
            list.setWidgets(widgets);
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    public TextAPI<?> getDescription() {
        return MTGUIScreen.selectionDesc(this.type.getType(), new Object[0]);
    }

    @Override
    public TextAPI<?> getDisplayName() {
        return MTGUIScreen.selectionName(this.type.getType());
    }

    public WrapperElement getElementFor(ParameterWrapper wrapper) {
        WrapperElement element = new WrapperElement(this, wrapper);
        if (Objects.nonNull(this.type)) {
            element.setLink(this.type);
        }
        return element;
    }

    public DataList getList(MTGUIScreen screen) {
        return this.addElements(screen, this.dual ? -0.5 : 0.0, this.dual ? 1.0 : 2.0, this.wrappers, true);
    }

    @Nullable
    public DataList getOtherList(MTGUIScreen screen) {
        return this.dual ? this.addElements(screen, 0.5, 1.0, this.otherWrappers, false) : null;
    }

    @Override
    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        for (WrapperElement wrapper : this.wrappers) {
            if (!wrapper.link.isModified()) continue;
            return true;
        }
        for (WrapperElement wrapper : this.otherWrappers) {
            if (!wrapper.link.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void recalculateHoverText() {
    }

    public void setElementDisplayName(ParameterLink link, TextAPI<?> name) {
        for (WrapperElement element : this.wrappers) {
            if (element.link != link) continue;
            element.setDisplayName(name);
            return;
        }
        for (WrapperElement element : this.otherWrappers) {
            if (element.link != link) continue;
            element.setDisplayName(name);
            return;
        }
    }

    @Override
    public void setType(MTScreenInfo type) {
        this.type = type;
        for (WrapperElement wrapper : this.wrappers) {
            wrapper.setLink(type);
        }
        for (WrapperElement wrapper : this.otherWrappers) {
            wrapper.setLink(type);
        }
    }

    private TextAPI<?> wrapperDesc(ParameterWrapper wrapper) {
        String name = wrapper.getName();
        if (wrapper instanceof AudioRef) {
            AudioRef ref = (AudioRef)wrapper;
            String type = (ref.isFile() ? MTGUIScreen.type("file") : MTGUIScreen.type("redirect")) + " <" + ref.getLocation() + ">";
            return MTGUIScreen.selectionDesc("audio", type, MTGUIScreen.triggerNames(ref.getTriggers()));
        }
        if (wrapper instanceof CommandElement) {
            return MTGUIScreen.selectionDesc(name, wrapper.getParameterAsString("literal"));
        }
        if (wrapper instanceof Toggle) {
            return MTGUIScreen.selectionDesc(name, ((Toggle)wrapper).getTargetCount());
        }
        if (wrapper instanceof Toggle.From) {
            return MTGUIScreen.selectionDesc("from", wrapper.getParameterAsString("triggers"));
        }
        if (wrapper instanceof Toggle.To) {
            return MTGUIScreen.selectionDesc("to", wrapper.getParameterAsString("triggers"));
        }
        if (wrapper instanceof RedirectElement) {
            name = "redirect";
        } else if (wrapper instanceof RecordElement) {
            name = "jukebox";
        } else {
            if (wrapper instanceof TriggerAPI.Link) {
                return MTGUIScreen.selectionDesc("link", wrapper.getParameterAsList("linked_triggers"));
            }
            if (wrapper instanceof AudioRef.Loop) {
                return MTGUIScreen.selectionDesc("loop", wrapper.getName());
            }
        }
        return wrapper instanceof TriggerAPI ? MTGUIScreen.triggerDesc(name) : MTGUIScreen.selectionDesc(name, new Object[0]);
    }

    private TextAPI<?> wrapperName(ParameterLink link) {
        ParameterWrapper wrapper = link.getWrapper();
        String name = wrapper.getName();
        if (wrapper instanceof AudioRef) {
            return TextHelper.getLiteral((String)name);
        }
        if (wrapper instanceof Toggle.From) {
            name = "from";
        } else if (wrapper instanceof TriggerAPI.Link) {
            name = "link";
        } else if (wrapper instanceof AudioRef.Loop) {
            name = "loop";
        } else {
            if (wrapper instanceof RecordElement) {
                return MTGUIScreen.jukeboxName(link);
            }
            if (wrapper instanceof RedirectElement) {
                return MTGUIScreen.redirectName(link);
            }
            if (wrapper instanceof Toggle.To) {
                name = "to";
            } else if (wrapper instanceof TriggerAPI) {
                return MTGUIScreen.triggerName(name, String.valueOf(link.getModifiedValue("identifier")), wrapper instanceof HolderTrigger);
            }
        }
        return MTGUIScreen.selectionName(name);
    }

    @Override
    public void populateToml(Toml toml) {
        String tableName;
        Toml next;
        Toml parent = toml;
        String typeName = this.type.getType();
        if (Misc.equalsAny((Object)typeName, (Object[])new String[]{"main", "renders"})) {
            parent = Toml.getEmpty();
        }
        for (WrapperElement wrapper : this.wrappers) {
            next = Toml.getEmpty();
            wrapper.link.populateToml(next);
            if (next.getEntryValuesAsMap().isEmpty() && next.getAllTables().isEmpty()) continue;
            tableName = wrapper.link.getTypeName();
            if (tableName.equals("universal_audio")) {
                tableName = "universal";
            }
            parent.addTable(tableName, next);
        }
        if (typeName.equals("main")) {
            if (!parent.getAllTables().isEmpty()) {
                toml.addTable("songs", parent);
            }
            parent = Toml.getEmpty();
        } else if (typeName.equals("renders")) {
            if (!parent.getAllTables().isEmpty()) {
                toml.addTable("image", parent);
            }
            parent = Toml.getEmpty();
        }
        for (WrapperElement wrapper : this.otherWrappers) {
            next = Toml.getEmpty();
            wrapper.link.populateToml(next);
            if (next.getEntryValuesAsMap().isEmpty() && next.getAllTables().isEmpty()) continue;
            tableName = wrapper.link.getTypeName();
            if (tableName.equals("universal_triggers")) {
                tableName = "universal";
            }
            parent.addTable(tableName, next);
        }
        if (typeName.equals("main") && !parent.getAllTables().isEmpty()) {
            toml.addTable("triggers", parent);
        } else if (typeName.equals("renders") && !parent.getAllTables().isEmpty()) {
            toml.addTable("title", parent);
        }
    }

    @Generated
    public Set<WrapperElement> getWrappers() {
        return this.wrappers;
    }

    @Generated
    public Set<WrapperElement> getOtherWrappers() {
        return this.otherWrappers;
    }

    public static final class WrapperElement {
        final WrapperLink parent;
        final ParameterWrapper wrapper;
        DataLink link;
        Widget widget;

        WrapperElement(WrapperLink parent, ParameterWrapper wrapper) {
            this.parent = parent;
            this.wrapper = wrapper;
        }

        void setLink(MTScreenInfo type) {
            String nextType = this.wrapper.getName();
            if (this.wrapper instanceof RedirectElement) {
                nextType = "redirect_element";
            } else if (this.wrapper instanceof RecordElement) {
                nextType = "jukebox_element";
            } else if (this.wrapper instanceof TriggerAPI.Link) {
                nextType = "link";
            } else if (this.wrapper instanceof AudioRef.Loop) {
                nextType = "loop";
            } else if (this.wrapper instanceof Toggle.From) {
                nextType = "from";
            } else if (this.wrapper instanceof Toggle.To) {
                nextType = "to";
            }
            DataLink link = null;
            for (DataLink next : type.getCache()) {
                if (!(next instanceof ParameterLink) || ((ParameterLink)next).getWrapper() != this.wrapper) continue;
                link = next;
            }
            if (Objects.isNull(link)) {
                link = MTGUIScreen.findLink(type, nextType, this.wrapper);
            }
            MTScreenInfo next = type.next(nextType, link);
            if (Objects.nonNull(link)) {
                link.setType(next);
            }
            this.link = link;
        }

        @Nullable
        public ParameterLink getAsParameter() {
            return this.link instanceof ParameterLink ? (ParameterLink)this.link : null;
        }

        TextAPI<?> getDisplayName() {
            return this.parent.wrapperName((ParameterLink)this.link);
        }

        TextAPI<?> getDescription() {
            return this.parent.wrapperDesc(((ParameterLink)this.link).getWrapper());
        }

        public void setDisplayName(TextAPI<?> text) {
            if (this.widget instanceof Button) {
                Button button = (Button)this.widget;
                button.setText(text);
                button.setHoverText(w -> w.setText(text));
            }
        }
    }
}

