/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.SpecialButton;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicTypeableWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;

public class TextBox
extends BasicTypeableWidget {
    private final ParameterLink.ParameterElement link;
    private final Widget backgroundHover;
    private final Shape backgroundShape;

    public TextBox(ParameterLink.ParameterElement link, TextBuffer text, double x, double y, double width) {
        super(text, x, y, -1);
        this.link = link;
        this.backgroundShape = ShapeHelper.plane((Facing.Axis)Facing.Axis.Y, (double)width, (double)(RenderHelper.getScaledFontHeight() * 1.5));
        this.backgroundHover = ShapeWidget.from((Shape)this.backgroundShape, (ColorCache)ColorHelper.WHITE.withAlpha(0.33333334f));
        this.backgroundHover.setParent((Widget)this);
    }

    public TextBox copy() {
        TextBox copy = new TextBox(this.link, this.text.copy(), this.x, this.y, this.width);
        copy.copyBasic((Widget)this);
        this.cursorBlinkCounter = copy.cursorBlinkCounter;
        this.selected = copy.selected;
        return copy;
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (this.backgroundShape.isInside(mouseX - this.getX(), mouseY - this.getY() - center.dY(), 0.0)) {
            this.backgroundHover.draw(ctx, center, mouseX, mouseY);
            this.colorOverride = ColorHelper.AQUA;
        } else {
            this.colorOverride = ColorHelper.WHITE;
        }
        super.draw(ctx, center, mouseX, mouseY);
    }

    public boolean onLeftClick(double x, double y) {
        if (this.backgroundShape.isInside(x - this.getX(), y - this.getY(), 0.0)) {
            boolean remove = false;
            if (this.parent instanceof DataList) {
                DataList list = (DataList)this.parent;
                Collection widgets = ((DataList)this.parent).getWidgets();
                for (Widget widget : widgets) {
                    if (!(widget instanceof SpecialButton) || !((SpecialButton)widget).isDeleting()) continue;
                    remove = true;
                    break;
                }
                if (remove) {
                    widgets.remove((Object)this);
                    list.setWidgets(widgets);
                    this.link.removeFromSelf(this.toString());
                    ScreenHelper.playVanillaClickSound();
                    return true;
                }
            }
            this.selected = true;
            double width = this.getWidth();
            double parentWidth = Objects.nonNull(this.parent) ? this.parent.getWidth() : 0.0;
            double height = this.getHeight();
            Vector3 center = this.getCenter(0.0);
            int pos = this.text.getCharPos(RenderHelper.getContext(), x, y, this.getCenter(0.0), this.getMinX(center.dX(), width, parentWidth), this.getMinY(center.dY(), height), this.getMaxX(center.dX(), width, parentWidth), this.getMaxY(center.dY(), height));
            if (pos != -1) {
                this.text.setBlinkerPos(pos);
                return true;
            }
        } else {
            this.text.setBlinkerVisible(false);
            this.selected = false;
        }
        return false;
    }

    protected void onTextAdded(String text) {
        super.onTextAdded(text);
        this.trySaving();
    }

    protected String onTextRemoved() {
        String removed = super.onTextRemoved();
        if (TextHelper.isNotEmpty((String)removed)) {
            this.trySaving();
        }
        return removed;
    }

    private void trySaving() {
        if (this.parent instanceof DataList) {
            ArrayList<String> text = new ArrayList<String>();
            for (Widget widget : ((DataList)this.parent).getWidgets()) {
                if (!(widget instanceof TextBox)) continue;
                text.add(widget.toString());
            }
            this.link.save(text);
        } else {
            this.link.save(this.toString());
        }
    }
}

