/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui;

import java.util.Objects;
import java.util.function.Supplier;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataList;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.SelectionLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class WrapperScreen
extends MTGUIScreen {
    public WrapperScreen(ScreenAPI parent, MTScreenInfo typeInfo, MinecraftWindow window, int guiScale) {
        super(parent, typeInfo, window, guiScale);
        this.addTextBackground(v -> {
            DataLink data = this.typeInfo.getLink();
            if (data instanceof WrapperLink) {
                WrapperLink link = (WrapperLink)data;
                this.addElements(() -> link.getList(this), () -> link.getOtherList(this));
            } else if (data instanceof SelectionLink) {
                SelectionLink link = (SelectionLink)data;
                this.addElements(() -> link.getList(this), () -> link.getOtherList(this));
            }
        });
    }

    public <D extends DataLink> void addElements(Supplier<DataList> getList, Supplier<DataList> getOtherList) {
        DataList list = getList.get();
        this.addWidget((Widget)list);
        double typeOffset = -list.getScrollBar().getWidth();
        DataList otherList = getOtherList.get();
        if (Objects.nonNull((Object)otherList)) {
            this.addWidget((Widget)otherList);
            this.autoAddTypeTexture(-otherList.getScrollBar().getWidth());
            typeOffset -= 1.0;
        }
        this.autoAddTypeTexture(typeOffset);
    }

    public float defaultBackgroundDarkness() {
        return 0.6f;
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        RenderAPI renderer = ctx.getRenderer();
        renderer.translate(0.0, 0.0, -200.0);
        if (Objects.nonNull(this.parentScreen)) {
            this.parentScreen.draw(ctx, center, mouseX + 9999.0, mouseY + 9999.0);
        }
        renderer.translate(0.0, 0.0, 200.0);
        super.draw(ctx, center, mouseX, mouseY);
    }
}

