/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelClient;
import mods.thecomputerizer.musictriggers.api.client.channel.ChannelClientSpecial;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class PlaybackScreen
extends MTGUIScreen {
    private ChannelAPI channel;

    public PlaybackScreen(ScreenAPI parent, MTScreenInfo typeInfo, MinecraftWindow window, int guiScale) {
        super(parent, typeInfo, window, guiScale);
        for (ChannelAPI channel : ChannelHelper.getClientHelper().getChannels().values()) {
            if (!Objects.nonNull(channel) || !channel.isClientChannel() || channel instanceof ChannelClientSpecial) continue;
            this.channel = channel;
            break;
        }
    }

    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        super.draw(ctx, center, mouseX, mouseY);
        if (Objects.nonNull(this.channel)) {
            RenderAPI renderer = ctx.getRenderer();
            double x = ctx.withScreenScaledX(0.0);
            double y = ctx.withScreenScaledY(0.95);
            renderer.drawCenteredString(ctx.getFont(), "Channel: " + this.channel.getName(), (Number)x, (Number)y, ColorHelper.GREEN.getColorI());
            y = ctx.withScreenScaledY(0.75 + ctx.getScaledFontHeight() * 1.5);
            renderer.drawCenteredString(ctx.getFont(), "Song: " + this.channel.getPlayingSongName(), (Number)x, (Number)y, ColorHelper.GREEN.getColorI());
            y = ctx.withScreenScaledY(-0.75 - ctx.getScaledFontHeight() * 0.5);
            renderer.drawCenteredString(ctx.getFont(), this.channel.getFormattedSongTime(), (Number)x, (Number)y, ColorHelper.GREEN.getColorI());
        }
    }

    public void resetSong() {
        AudioTrack track;
        if (this.channel instanceof ChannelClient && Objects.nonNull(track = this.channel.getPlayer().getPlayingTrack())) {
            track.setPosition(0L);
        }
    }

    public void skipSong() {
        if (this.channel instanceof ChannelClient) {
            this.channel.getPlayer().stopCurrentTrack();
        }
    }

    @Generated
    public ChannelAPI getChannel() {
        return this.channel;
    }
}

