/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.MTClient;
import mods.thecomputerizer.musictriggers.api.client.MTClientEvents;
import mods.thecomputerizer.musictriggers.api.client.gui.LogVisualizer;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.ParameterScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.PlaybackScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.WrapperScreen;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.HelpLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BasicWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Button;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.ShapeWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.WidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderShape;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextureWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Circle;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Square;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;

public class MTGUIScreen
extends ScreenAPI
implements LoggableAPI {
    public static final KeyAPI<?> GUI_KEY = KeyHelper.create((String)String.format("key.%1$s.gui", "musictriggers"), (String)String.format("key.categories.%1$s", "musictriggers"), (KeyAPI.AlphaNum)KeyAPI.AlphaNum.R);
    public static boolean isActive;
    private static boolean fuzzy;
    protected final MTScreenInfo typeInfo;

    public static MTGUIScreen constructScreen(@Nullable ScreenAPI parent, MTScreenInfo typeInfo, MinecraftWindow window, int scale) {
        switch (typeInfo.getType()) {
            case "channels": 
            case "home": {
                return new MTGUIScreen(parent, typeInfo, window, scale);
            }
            case "commands": 
            case "jukebox": 
            case "main": 
            case "potential_audio": 
            case "potential_images": 
            case "potential_triggers": 
            case "redirect": 
            case "renders": 
            case "toggles": {
                return new WrapperScreen(parent, typeInfo, window, scale);
            }
            case "log": {
                return new LogVisualizer(parent, typeInfo, window, scale);
            }
            case "playback": {
                return new PlaybackScreen(parent, typeInfo, window, scale);
            }
        }
        return new ParameterScreen(parent, typeInfo, window, scale);
    }

    @Nullable
    public static DataLink findLink(MTScreenInfo parent, String type, @Nullable ParameterWrapper wrapper) {
        switch (type) {
            case "debug": {
                return ChannelHelper.getDebug().getLink();
            }
            case "help": {
                return MTGUIScreen.getHelpLink();
            }
            case "toggles": {
                return ChannelHelper.getClientHelper().getTogglesLink();
            }
        }
        return parent.findChannelLink(type, wrapper);
    }

    public static int getButtonCount(String screen) {
        switch (screen) {
            case "channels": {
                return 6;
            }
            case "home": {
                return 4;
            }
            case "playback": {
                return 2;
            }
        }
        return 1;
    }

    public static String getButtonType(String screen, int index) {
        switch (screen) {
            case "channels": {
                switch (index) {
                    case 0: {
                        return "commands";
                    }
                    case 1: {
                        return "jukebox";
                    }
                    case 2: {
                        return "redirect";
                    }
                    case 3: {
                        return "main";
                    }
                    case 4: {
                        return "channel_info";
                    }
                    case 5: {
                        return "renders";
                    }
                }
            }
            case "home": {
                switch (index) {
                    case 0: {
                        return "log";
                    }
                    case 1: {
                        return "reload";
                    }
                    case 2: {
                        return "channels";
                    }
                    case 3: {
                        return "playback";
                    }
                }
            }
            case "playback": {
                switch (index) {
                    case 0: {
                        return "reset_song";
                    }
                    case 1: {
                        return "skip_song";
                    }
                }
            }
        }
        return null;
    }

    protected static TextAPI<?> getDisplayName(String category, String name) {
        return TextHelper.getTranslated((String)MTGUIScreen.lang(String.format("%1$s.%2$s.name", category, name)), (Object[])new Object[0]);
    }

    protected static DataLink getHelpLink() {
        return HelpLink.getInstance();
    }

    public static Collection<TextAPI<?>> getTooltip(String category, String type) {
        ArrayList lines = new ArrayList();
        lines.add(MTGUIScreen.getDisplayName(category, type));
        for (int i = 1; i <= MTGUIScreen.getTooltipSize(type); ++i) {
            lines.add((TextAPI<?>)TextHelper.getTranslated((String)MTGUIScreen.lang(String.format("%1$s.%2$s.tooltip.%3$d", category, type, i)), (Object[])new Object[0]));
        }
        return lines;
    }

    public static int getTooltipSize(String type) {
        switch (type) {
            case "channel_info": 
            case "help": 
            case "jukebox": 
            case "reset_song": {
                return 1;
            }
            case "channels": 
            case "commands": 
            case "debug": 
            case "log": 
            case "playback": 
            case "redirect": 
            case "renders": 
            case "skip_song": 
            case "toggles": {
                return 2;
            }
            case "main": 
            case "reload": {
                return 3;
            }
        }
        return 0;
    }

    public static TextAPI<?> jukeboxName(ParameterLink link) {
        String key = String.valueOf(link.getModifiedValue("jukebox_key"));
        String value = String.valueOf(link.getModifiedValue("jukebox_value"));
        return TextHelper.getLiteral((String)(key + " = " + value));
    }

    protected static String lang(String key) {
        return String.format("gui.%1$s.%2$s", "musictriggers", key);
    }

    public static void open() {
        fuzzy = ChannelHelper.getDebugBool("gui_fuzz");
        MTGUIScreen.openRadial(null, MTScreenInfo.get("home"));
    }

    public static void open(MTGUIScreen screen) {
        ScreenHelper.open((ScreenAPI)screen);
        isActive = true;
    }

    protected static void openRadial(@Nullable ScreenAPI parent, MTScreenInfo info) {
        double heightRatio = RenderHelper.getCurrentHeightRatio();
        MTGUIScreen mtgui = MTGUIScreen.constructScreen(parent, info, ClientHelper.getWindow(), ClientHelper.getGuiScale());
        mtgui.addRadial(heightRatio, MTGUIScreen.getButtonCount(info.getType()), (index, button) -> {
            button.getShape().setColor(ColorHelper.BLACK);
            String type = MTGUIScreen.getButtonType(info.getType(), index);
            Square square = ShapeHelper.square((Facing.Axis)Facing.Axis.Y, (double)0.25, (double)heightRatio);
            ShapeWidget texture = ShapeWidget.from((Shape)square, info.getIconTexture(type, false));
            ShapeWidget hoverTexture = ShapeWidget.from((Shape)square.getScaled(0.95), info.getIconTexture(type, true));
            Vector3 pos = button.getShape().getCenterForGroup(VectorHelper.zero3D());
            texture.setX(pos.dX());
            texture.setY(pos.dY());
            hoverTexture.setX(pos.dX());
            hoverTexture.setY(pos.dY());
            button.addWidget((Widget)texture);
            button.setHoverLines(MTGUIScreen.getTooltip("button", type));
            button.setHover((Widget)BasicWidgetGroup.from((Widget[])new Widget[]{ShapeWidget.of((RenderShape)RenderShape.from((Shape)((Shape)button.getShape().getWrapped().getWrapped())), (double)0.0, (double)0.0), hoverTexture}));
            if (Objects.nonNull(type)) {
                MTGUIScreen.setClickFunction(mtgui, button, type);
            }
        });
        if (info.is("home")) {
            mtgui.addCenterIcon(MTClient.getLogoTexture(), heightRatio, 0.25);
            mtgui.addSquareButton(-0.6, 0.3, "debug");
            mtgui.addSquareButton(-0.6, -0.3, "toggles");
            mtgui.addSquareButton(0.6, 0.0, "help");
        } else {
            double radius = info.is("playback") ? 0.2 : 0.18;
            mtgui.addCenterIcon(info.getIconTexture(false), heightRatio, radius);
        }
        ScreenHelper.open((ScreenAPI)mtgui);
        isActive = true;
    }

    public static TextAPI<?> parameterDesc(String name) {
        return TextHelper.getTranslated((String)String.format("parameter.%1$s.%2$s.desc", "musictriggers", name), (Object[])new Object[0]);
    }

    public static TextAPI<?> parameterName(String name) {
        return TextHelper.getTranslated((String)String.format("parameter.%1$s.%2$s.name", "musictriggers", name), (Object[])new Object[0]);
    }

    public static TextAPI<?> redirectName(ParameterLink link) {
        String key = String.valueOf(link.getModifiedValue("redirect_key"));
        String value = String.valueOf(link.getModifiedValue("redirect_value"));
        return TextHelper.getLiteral((String)(key + " = " + value));
    }

    public static TextAPI<?> selectionDesc(String name, Object ... args) {
        return TextHelper.getTranslated((String)String.format("selection.%1$s.%2$s.desc", "musictriggers", name), (Object[])args);
    }

    public static TextAPI<?> selectionName(String name) {
        return TextHelper.getTranslated((String)String.format("selection.%1$s.%2$s.name", "musictriggers", name), (Object[])new Object[0]);
    }

    public static void setClickFunction(MTGUIScreen screen, Button button, String type) {
        MTGUIScreen.setClickFunction(screen, button, type, null);
    }

    public static void setClickFunction(MTGUIScreen screen, Button button, String type, @Nullable DataLink link) {
        button.setClickFunc(b -> {
            switch (type) {
                case "channels": 
                case "playback": {
                    MTScreenInfo nextType = screen.typeInfo.next(type, null);
                    nextType.setChannel(ChannelHelper.getClientHelper().findFirstUserChannel(), false);
                    MTGUIScreen.openRadial(screen, nextType);
                    break;
                }
                case "reload": {
                    if (screen.typeInfo.isGloballyModified()) {
                        screen.typeInfo.applyChanges();
                    } else {
                        MTClientEvents.queueReload(ClientHelper.getMinecraft(), 5);
                    }
                    isActive = false;
                    break;
                }
                case "reset_song": {
                    ((PlaybackScreen)screen).resetSong();
                    break;
                }
                case "skip_song": {
                    ((PlaybackScreen)screen).skipSong();
                    break;
                }
                default: {
                    MTScreenInfo nextType = screen.typeInfo.next(type, link);
                    MTGUIScreen.open(MTGUIScreen.constructScreen(screen, nextType, ClientHelper.getWindow(), ClientHelper.getGuiScale()));
                    break;
                }
            }
        });
    }

    public static void toggleFuzz(boolean fuzz) {
        fuzzy = fuzz;
    }

    public static TextAPI<?> triggerDesc(String name) {
        return TextHelper.getTranslated((String)String.format("trigger.%1$s.%2$s.desc", "musictriggers", name), (Object[])new Object[0]);
    }

    public static TextAPI<?> triggerName(String name, String id, boolean holder) {
        if (id.equals("null")) {
            id = "not_set";
        }
        if (holder) {
            name = name + ".id";
        }
        return TextHelper.getTranslated((String)String.format("trigger.%1$s.%2$s", "musictriggers", name), (Object[])new Object[]{id});
    }

    public static String triggerNames(Collection<TriggerAPI> triggers) {
        if (Objects.isNull(triggers) || triggers.isEmpty()) {
            return "[]";
        }
        String combo = MTGUIScreen.type("trigger") + "[" + MTGUIScreen.type("combination").toString() + " = ";
        StringJoiner joiner = new StringJoiner("+");
        for (TriggerAPI trigger : triggers) {
            String name = MTGUIScreen.triggerName(trigger.getName(), trigger.getIdentifier(), trigger instanceof HolderTrigger).toString();
            if (triggers.size() == 1) {
                return name;
            }
            joiner.add(name);
        }
        return combo + joiner + "]";
    }

    public static TextAPI<?> type(String type) {
        return TextHelper.getTranslated((String)String.format("types.%1$s.%2$s", "musictriggers", type), (Object[])new Object[0]);
    }

    public MTGUIScreen(ScreenAPI parent, MTScreenInfo typeInfo, MinecraftWindow window, int guiScale) {
        super(parent, typeInfo.getDisplayName(), window, guiScale);
        if (!typeInfo.is("home")) {
            this.addBackButton();
        }
        this.typeInfo = typeInfo;
        this.addApplyButton();
    }

    protected void addApplyButton() {
        Button apply = Button.basic(MTGUIScreen.getDisplayName("button", "apply"), (TextAPI[])new TextAPI[0]);
        double offset = 1.8181818181818181;
        apply.setX(1.0 - apply.getWidth() / offset);
        apply.setY(1.0 - apply.getHeight() / offset);
        apply.setClickFunc(button -> this.typeInfo.applyChanges());
        if (!this.typeInfo.isGloballyModified()) {
            apply.setVisible(false);
        }
        this.addWidget((Widget)apply);
        this.typeInfo.setApplyButton(apply);
    }

    protected void addBackButton() {
        Button back = Button.basic(MTGUIScreen.getDisplayName("button", "back"), (TextAPI[])new TextAPI[0]);
        double offset = 1.8181818181818181;
        back.setX(-1.0 + back.getWidth() / offset);
        back.setY(1.0 - back.getHeight() / offset);
        back.setClickFunc(button -> this.back());
        this.addWidget((Widget)back);
    }

    protected void addCenterIcon(ResourceLocationAPI<?> texture, double heightRatio, double radius) {
        this.addWidget((Widget)ShapeWidget.from((Shape)ShapeHelper.square((Facing.Axis)Facing.Axis.Y, (double)(radius * 2.0), (double)heightRatio), texture));
    }

    protected void addFuzz(Shape shape) {
        this.addWidget((Widget)ShapeWidget.fuzz((Shape)shape, (int)5));
    }

    protected void addRadial(double heightRatio, int slices, BiConsumer<Integer, Button> sliceSettings) {
        double radius = 0.65;
        double innerRadius = 0.35;
        Circle circle = ShapeHelper.circle((Facing.Axis)Facing.Axis.Y, (double)radius, (double)innerRadius, (double)heightRatio);
        Circle smallRing = circle.getScaled(0.46153846153846156);
        Circle bigRing = circle.getScaled(1.1);
        WidgetGroup radialMenu = Button.radialGroup((Circle)circle, (double)0.0, (double)0.0, (int)slices, (double)this.getRadialOffset(slices), sliceSettings);
        if (fuzzy) {
            this.addFuzz((Shape)bigRing);
        }
        this.addWidget((Widget)radialMenu);
        this.addWidget((Widget)ShapeWidget.from((Shape)ShapeHelper.circle((Facing.Axis)Facing.Axis.Y, (double)0.25, (double)heightRatio), (ColorCache)ColorHelper.BLACK));
        this.addWidget((Widget)ShapeWidget.outlineFrom((Shape)smallRing, (float)10.0f));
        this.addWidget((Widget)ShapeWidget.outlineFrom((Shape)bigRing, (float)10.0f));
    }

    protected void addSquareButton(double x, double y, String iconName) {
        Square shape = ShapeHelper.square((Facing.Axis)Facing.Axis.Y, (double)0.3, (double)RenderHelper.getCurrentHeightRatio());
        ShapeWidget widget = ShapeWidget.from((Shape)shape, (ColorCache)ColorHelper.BLACK);
        TextureWrapper texture = new TextureWrapper().setTexture(this.typeInfo.getIconTexture(iconName, false));
        TextureWrapper hoverTexture = new TextureWrapper().setTexture(this.typeInfo.getIconTexture(iconName, true));
        BasicWidgetGroup hover = BasicWidgetGroup.from((Widget[])new Widget[]{ShapeWidget.from((Shape)shape), ShapeWidget.from((Shape)shape.getScaled(0.75), (TextureWrapper)hoverTexture), ShapeWidget.outlineFrom((Shape)shape.getScaled(1.15), (float)5.0f)});
        Button button = new Button(widget, null, (Widget)hover);
        button.addWidget((Widget)ShapeWidget.from((Shape)shape.getScaled(0.8), (TextureWrapper)texture));
        button.addWidget((Widget)ShapeWidget.outlineFrom((Shape)shape.getScaled(1.15), (float)5.0f));
        button.setX(x);
        button.setY(y);
        button.setHoverLines(MTGUIScreen.getTooltip("button", iconName));
        MTGUIScreen.setClickFunction(this, button, iconName);
        this.addWidget((Widget)button);
    }

    protected void addTextBackground(Consumer<Void> doThisBetween) {
        Plane back = ShapeHelper.plane((Facing.Axis)Facing.Axis.Y, (Vector2)new Vector2((Number)-1.0, (Number)-0.9), (Vector2)new Vector2((Number)1.0, (Number)0.9));
        this.addWidget((Widget)ShapeWidget.from((Shape)back, (ColorCache)ColorHelper.BLACK.withAlpha(0.65f)));
        doThisBetween.accept(null);
        this.addWidget((Widget)ShapeWidget.outlineFrom((Shape)back, (float)5.0f));
    }

    public void addTypeTexture(double offsetX, double offsetY) {
        this.addTypeTexture(offsetX, offsetY, this.typeInfo.getDisplayName(), this.typeInfo.getIconTexture(false));
    }

    public void addTypeTexture(double offsetX, double offsetY, TextAPI<?> displayName) {
        this.addTypeTexture(offsetX, offsetY, displayName, this.typeInfo.getIconTexture(false));
    }

    public void addTypeTexture(double offsetX, double offsetY, String textureType) {
        this.addTypeTexture(offsetX, offsetY, this.typeInfo.getDisplayName(), this.typeInfo.getIconTexture(textureType, false));
    }

    public void addTypeTexture(double offsetX, double offsetY, TextAPI<?> displayName, String textureType) {
        this.addTypeTexture(offsetX, offsetY, displayName, this.typeInfo.getIconTexture(textureType, false));
    }

    public void addTypeTexture(double offsetX, double offsetY, TextAPI<?> displayName, ResourceLocationAPI<?> iconLocation) {
        Square shape = ShapeHelper.square((Facing.Axis)Facing.Axis.Y, (double)0.2, (double)RenderHelper.getCurrentHeightRatio());
        TextureWrapper texture = new TextureWrapper().setTexture(iconLocation);
        TextWidget text = TextWidget.from(displayName).setColor(ColorHelper.GREEN);
        double textHeight = text.getHeight();
        ShapeWidget widget = ShapeWidget.from((Shape)shape, (TextureWrapper)texture, (double)0.0, (double)(offsetY + 0.9 - textHeight * 2.0 - shape.getHeight() / 2.0));
        double width = Math.max(text.getWidth(), widget.getWidth()) / 2.0 * 1.05;
        double height = textHeight * 3.0 + widget.getHeight();
        text.setX(1.0 - width + offsetX);
        text.setY(0.9 - textHeight + offsetY);
        widget.setX(1.0 - width + offsetX);
        Plane total = ShapeHelper.plane((Facing.Axis)Facing.Axis.Y, (Vector2)new Vector2((Number)(-width), (Number)(0.9 - height)), (Vector2)new Vector2((Number)width, (Number)0.9));
        ShapeWidget back = ShapeWidget.from((Shape)total, (ColorCache)ColorHelper.BLACK, (double)(1.0 - width + offsetX), (double)offsetY);
        this.addWidget((Widget)back);
        this.addWidget((Widget)text);
        this.addWidget((Widget)widget);
        this.addWidget((Widget)ShapeWidget.outlineFrom((Shape)total, (float)3.0f, (double)(1.0 - width + offsetX), (double)offsetY));
    }

    protected void autoAddTypeTexture(double offsetX) {
        switch (this.typeInfo.getType()) {
            case "channel_info": 
            case "commands": 
            case "debug": 
            case "help": 
            case "jukebox": 
            case "log": 
            case "playback": 
            case "redirect": 
            case "toggles": {
                this.addTypeTexture(offsetX, 0.0);
                break;
            }
            case "command_element": {
                this.addTypeTexture(offsetX, 0.0, "commands");
                break;
            }
            case "event": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName(), MTClient.getLogoTexture());
                break;
            }
            case "from": 
            case "from_list": 
            case "to": 
            case "toggle": 
            case "to_list": {
                this.addTypeTexture(offsetX, 0.0, "toggles");
                break;
            }
            case "image_card": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName("image_element"), "renders");
                break;
            }
            case "image_element": 
            case "title_element": {
                this.addTypeTexture(offsetX, 0.0, "renders");
                break;
            }
            case "interrupt_handler": 
            case "link": 
            case "loop": 
            case "universal_audio": 
            case "universal_triggers": {
                this.addTypeTexture(offsetX, 0.0, "main");
                break;
            }
            case "jukebox_element": {
                this.addTypeTexture(offsetX, 0.0, "jukebox");
                break;
            }
            case "main": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName(offsetX <= -1.0 ? "songs" : "triggers"));
                break;
            }
            case "potential_audio": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName(offsetX <= -1.0 ? "potential_files" : "potential_redirects"), "main");
                break;
            }
            case "potential_triggers": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName(offsetX <= -1.0 ? "registered_triggers" : "potential_triggers"), "main");
                break;
            }
            case "redirect_element": {
                this.addTypeTexture(offsetX, 0.0, "redirect");
                break;
            }
            case "renders": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName(offsetX <= -1.0 ? "images" : "titles"));
                break;
            }
            case "title_card": {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getDisplayName("title_element"), "renders");
                break;
            }
            default: {
                this.addTypeTexture(offsetX, 0.0, this.typeInfo.getSpecialDisplayName(), "main");
            }
        }
    }

    public void back() {
        ScreenHelper.open((ScreenAPI)this.parentScreen);
    }

    protected double getRadialOffset(int slices) {
        switch (slices) {
            case 2: {
                return MathHelper.RADIANS_90;
            }
            case 4: {
                return MathHelper.RADIANS_45;
            }
        }
        return 0.0;
    }

    @Override
    public void logDebug(String msg, Object ... args) {
        MTLogger.logDebug("GUI", this.typeInfo.getType(), msg, args);
    }

    @Override
    public void logError(String msg, Object ... args) {
        MTLogger.logError("GUI", this.typeInfo.getType(), msg, args);
    }

    @Override
    public void logFatal(String msg, Object ... args) {
        MTLogger.logFatal("GUI", this.typeInfo.getType(), msg, args);
    }

    @Override
    public void logInfo(String msg, Object ... args) {
        MTLogger.logInfo("GUI", this.typeInfo.getType(), msg, args);
    }

    @Override
    public void logTrace(String msg, Object ... args) {
        MTLogger.logTrace("GUI", this.typeInfo.getType(), msg, args);
    }

    @Override
    public void logWarn(String msg, Object ... args) {
        MTLogger.logWarn("GUI", this.typeInfo.getType(), msg, args);
    }

    public boolean onCloseRequested(boolean pressedEsc) {
        boolean willClose = super.onCloseRequested(pressedEsc);
        if (willClose && pressedEsc) {
            isActive = false;
        }
        return willClose;
    }

    public void onScreenClosed() {
        if (Objects.isNull(this.parentScreen)) {
            isActive = false;
        }
    }

    public boolean shouldPauseGame() {
        return !this.typeInfo.is("playback");
    }

    @Generated
    public MTScreenInfo getTypeInfo() {
        return this.typeInfo;
    }
}

