/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.audio.resource;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.audio.resource.ResourceAudioTrack;
import mods.thecomputerizer.musictriggers.api.client.audio.resource.ResourceSeekableInputStream;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.ProbingAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;

public class ResourceAudioSourceManager
extends ProbingAudioSourceManager {
    private final ChannelAPI channel;

    public ResourceAudioSourceManager(ChannelAPI channel) {
        this(MediaContainerRegistry.DEFAULT_REGISTRY, channel);
    }

    public ResourceAudioSourceManager(MediaContainerRegistry registry, ChannelAPI channel) {
        super(registry);
        this.channel = channel;
    }

    @Override
    protected AudioTrack createTrack(AudioTrackInfo info, MediaContainerDescriptor trackFactory) {
        return new ResourceAudioTrack(info, trackFactory, this);
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo info, DataInput input) throws IOException {
        MediaContainerDescriptor trackFactory = this.decodeTrackFactory(input);
        return Objects.nonNull(trackFactory) ? new ResourceAudioTrack(info, trackFactory, this) : null;
    }

    private MediaContainerDetectionResult detectContainerForResource(AudioReference reference, ResourceLocationAPI<?> location) {
        MediaContainerDetectionResult mediaContainerDetectionResult;
        block8: {
            ResourceSeekableInputStream stream = ResourceSeekableInputStream.get(this.channel, location);
            try {
                int dotIndex = location.getPath().lastIndexOf(46);
                String ext = dotIndex >= 0 ? location.getPath().substring(dotIndex + 1) : null;
                mediaContainerDetectionResult = new MediaContainerDetection(this.containerRegistry, reference, stream, MediaContainerHints.from(null, ext)).detectContainer();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new FriendlyException("Failed to open file for reading.", FriendlyException.Severity.SUSPICIOUS, ex);
                }
            }
            stream.close();
        }
        return mediaContainerDetectionResult;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
        this.encodeTrackFactory(((ResourceAudioTrack)track).getTrackFactory(), output);
    }

    @Override
    public String getSourceName() {
        return "resource";
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        ResourceLocationAPI location = ResourceHelper.getResource((String)reference.identifier);
        return Objects.nonNull(location) ? this.handleLoadResult(this.detectContainerForResource(reference, location)) : null;
    }

    @Override
    public void shutdown() {
    }

    @Generated
    public ChannelAPI getChannel() {
        return this.channel;
    }
}

