/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client.audio;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.FunctionalResultHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioReference;

public class TrackLoader
extends ChannelElement {
    public TrackLoader(ChannelAPI channel) {
        super(channel, "");
    }

    protected AudioLoadResultHandler getResultHandler(AudioRef ref, String location) {
        return new FunctionalResultHandler(track -> this.itemLoaded(ref, (AudioItem)track, "track", location), playlist -> this.itemLoaded(ref, (AudioItem)playlist, "playlist", location), () -> this.noMatches(ref, location), ex -> this.loadFailed((FriendlyException)ex, ref, location));
    }

    public synchronized void load(AudioPlayerManager manager, @Nullable AudioReference ref, @Nullable AudioLoadResultHandler resultHandler, LoggableAPI logger) {
        if (Objects.nonNull(ref) && Objects.nonNull(resultHandler)) {
            manager.loadItem(ref, resultHandler);
        } else {
            logger.logError("Unable to load missing reference or handler!", new Object[0]);
        }
    }

    public void load(AudioPlayerManager manager, @Nullable String id, @Nullable String title, @Nullable AudioLoadResultHandler resultHandler, LoggableAPI logger) {
        this.load(manager, new AudioReference(id, title), resultHandler, logger);
    }

    public void loadLocal(AudioPlayerManager manager, AudioRef audio, File dir, @Nullable String path) {
        File file;
        File file2 = file = Objects.nonNull(path) ? new File(dir, path) : null;
        if (Objects.nonNull(file) && file.exists()) {
            audio.setLoading();
            this.load(manager, file.getPath(), file.getName(), this.getResultHandler(audio, path), audio);
        } else {
            audio.logError("Tried to load nonexistant or unreadable file {}!", path);
        }
    }

    public void loadRemote(AudioPlayerManager manager, AudioRef audio, @Nullable String location) {
        if (Objects.nonNull(location)) {
            audio.setLoading();
            this.load(manager, location, null, this.getResultHandler(audio, location), audio);
        } else {
            audio.logError("Tried to add null remote location!", new Object[0]);
        }
    }

    protected void loadFailed(FriendlyException ex, AudioRef audio, String location) {
        audio.logError("There was an error trying to load {}!", location, ex);
        audio.setItem(null);
    }

    protected void noMatches(AudioRef audio, String location) {
        audio.logError("No matches from {} were found", location);
        audio.setItem(null);
    }

    protected void itemLoaded(AudioRef audio, AudioItem item, String type, String location) {
        audio.logInfo("Successfully loaded {} from {}", type, location);
        audio.setItem(item);
    }

    @Override
    protected String getSubTypeName() {
        return "TrackLoader";
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return TrackLoader.class;
    }
}

