/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.global.Debug;
import mods.thecomputerizer.musictriggers.api.data.global.GlobalElement;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectInstanceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextTranslationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;

public class MTDebugInfo
extends GlobalElement {
    private static final double MAX_WIDTH_PERCENT = 0.6666666666666666;
    private static final Comparator<Element> elementComparator = Comparator.comparingInt(Element::getPriority);
    private static final Comparator<Element> elementSorter = Collections.reverseOrder(elementComparator);
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private ChannelHelper helper;
    private int maxWidth;
    private String structureID = "?";
    private String structureName = "?";

    public MTDebugInfo(ChannelHelper helper) {
        super("Debug_Info");
        this.helper = helper;
        this.elements = new ArrayList<Element>();
        this.visibleElements = new ArrayList<Element>();
        this.addDefaultElements();
    }

    public void initChannelElements() {
        int priority = 10000;
        for (Map.Entry<String, ChannelAPI> entry : this.helper.getChannels().entrySet()) {
            String name = entry.getKey();
            ChannelAPI channel = entry.getValue();
            this.addElement(ElementType.CHANNEL, "song", true, priority).setVisibility(helper -> channel.showDebugSongInfo()).setArgSetter(helper -> {
                String song = channel.getPlayingSongName();
                String time = channel.getFormattedSongTime();
                if (Objects.isNull(song)) {
                    song = "?";
                }
                if (Objects.isNull(time)) {
                    time = "?";
                }
                return new Object[]{name, song, time};
            });
            this.addElement(ElementType.CHANNEL, "trigger", true, --priority).setVisibility(helper -> channel.showDebugTriggerInfo()).setArgSetter(helper -> {
                Collection<TriggerAPI> triggers;
                String active = null;
                String playable = null;
                TriggerAPI trigger = channel.getActiveTrigger();
                if (Objects.nonNull(trigger)) {
                    active = trigger.toString();
                }
                if (!(triggers = channel.getPlayableTriggers()).isEmpty()) {
                    playable = triggers.toString();
                }
                if (Objects.isNull(active)) {
                    active = "?";
                }
                if (Objects.isNull(playable)) {
                    playable = "?";
                }
                return new Object[]{name, active, playable};
            });
            --priority;
        }
    }

    private void addDefaultElements() {
        this.addElement(ElementType.HEADER, "").setVisibility(helper -> true);
        this.addElement(ElementType.POSITION, "dimension", true, 1003).setVisibility(helper -> ChannelHelper.getDebugBool("show_position_info")).setArgSetter(helper -> {
            DimensionAPI dimension;
            PlayerAPI<?, ?> player = helper.getPlayer();
            if (Objects.nonNull(player) && Objects.nonNull(dimension = player.getDimension())) {
                return new Object[]{dimension.getName(), dimension.getRegistryName()};
            }
            return new Object[]{"?", "?"};
        });
        this.addElement(ElementType.POSITION, "structure", true, 1002).setVisibility(helper -> ChannelHelper.getDebugBool("show_position_info")).setArgSetter(helper -> {
            String name = Objects.nonNull(this.structureName) ? this.structureName : "?";
            String id = Objects.nonNull(this.structureID) ? this.structureID : "?";
            return new Object[]{name, id};
        });
        this.addElement(ElementType.POSITION, "biome", true, 1001).setVisibility(helper -> ChannelHelper.getDebugBool("show_position_info")).setArgSetter(helper -> {
            WorldAPI world;
            BiomeAPI biome;
            PlayerAPI<?, ?> player = helper.getPlayer();
            if (Objects.nonNull(player) && Objects.nonNull(biome = (world = player.getWorld()).getBiomeAt(player.getPosRounded()))) {
                String name = biome.getName(world);
                ResourceLocationAPI registryName = biome.getRegistryName(world);
                Set tags = biome.getTagNames(world);
                return new Object[]{name, registryName, tags};
            }
            return new Object[]{"?", "?", "?"};
        });
        this.addElement(ElementType.POSITION, "light").setVisibility(helper -> ChannelHelper.getDebugBool("show_position_info")).setArgSetter(helper -> {
            PlayerAPI<?, ?> player = helper.getPlayer();
            if (Objects.nonNull(player)) {
                WorldAPI world = player.getWorld();
                BlockPosAPI pos = player.getPosRounded();
                int blockLight = world.getLightBlock(pos);
                int skyLight = world.getLightSky(pos);
                int totalLight = world.getLightTotal(pos);
                return new Object[]{blockLight, skyLight, totalLight};
            }
            return new Object[]{"?", "?", "?"};
        });
        this.addElement(ElementType.STATUS, "effects").setVisibility(helper -> ChannelHelper.getDebugBool("show_status_info")).setArgSetter(helper -> {
            PlayerAPI<?, ?> player = helper.getPlayer();
            if (Objects.nonNull(player)) {
                WorldAPI world = player.getWorld();
                StringJoiner joiner = new StringJoiner(", ");
                for (EffectInstanceAPI instance : player.getActiveEffects()) {
                    String registryName;
                    EffectAPI effect = instance.getEffect();
                    ResourceLocationAPI registryLoc = effect.getRegistryName(world);
                    String name = Objects.nonNull(registryLoc) ? effect.getName(world) : "?";
                    String string = registryName = Objects.nonNull(registryLoc) ? registryLoc.toString() : "?";
                    TextTranslationAPI<?> text = this.getTranslated("status", "effect", name, registryName);
                    if (!Objects.nonNull(text)) continue;
                    joiner.add(text.getApplied());
                }
                return new Object[]{joiner.toString()};
            }
            return new Object[]{"?"};
        });
        this.addElement(ElementType.TARGET, "block_entity").setVisibility(helper -> ChannelHelper.getDebugBool("show_target_info")).setArgSetter(helper -> {
            WorldAPI world;
            ResourceLocationAPI registryName;
            String name = "?";
            String id = "?";
            BlockEntityAPI target = ClientHelper.getTargetBlockEntity();
            if (Objects.nonNull(target) && Objects.nonNull(registryName = target.getRegistryName(world = target.getWorld()))) {
                name = target.getName(world);
                id = registryName.toString();
            }
            return new Object[]{name, id};
        });
        this.addElement(ElementType.TARGET, "entity").setVisibility(helper -> ChannelHelper.getDebugBool("show_target_info")).setArgSetter(helper -> {
            WorldAPI world;
            ResourceLocationAPI registryName;
            String name = "?";
            String id = "?";
            EntityAPI target = ClientHelper.getTargetEntity();
            if (Objects.nonNull(target) && Objects.nonNull(registryName = target.getRegistryName(world = target.getWorld()))) {
                name = target.getName(world);
                id = registryName.toString();
            }
            return new Object[]{name, id};
        });
        this.addElement(ElementType.OTHER, "blocked.mods", true, 5000).setVisibility(helper -> true).setArgSetter(helper -> {
            Debug debug = ChannelHelper.getDebug();
            if (Objects.isNull(debug)) {
                return new Object[]{"Unknown"};
            }
            StringJoiner joiner = new StringJoiner(", ");
            Map<String, List<String>> blockedMods = ChannelHelper.getDebug().getFormattedBlockedMods();
            for (Map.Entry<String, List<String>> mod : blockedMods.entrySet()) {
                TextTranslationAPI<?> text = this.getTranslated("other", "blocked.mod", mod.getKey(), mod.getValue());
                if (!Objects.nonNull(text)) continue;
                joiner.add(text.getApplied());
            }
            return new Object[]{joiner.toString()};
        });
    }

    public Element addElement(ElementType type, String text) {
        return this.addElement(type, text, true, 0);
    }

    public Element addElement(ElementType type, String text, boolean isTranlation, int priority) {
        Element element = new Element(type, text, isTranlation, priority);
        this.elements.add(element);
        return element;
    }

    public void compute() {
        this.visibleElements.clear();
        for (Element element : this.elements) {
            if (!element.computeVisibility(this.helper).visible) continue;
            element.computeArgs(this.helper);
            this.visibleElements.add(element);
        }
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    public TextTranslationAPI<?> getTranslated(String type, String key, Object ... args) {
        String built = "debug.musictriggers." + type;
        if (TextHelper.isNotEmpty((String)key)) {
            built = built + "." + key;
        }
        return TextHelper.getTranslated((String)built, (Object[])args);
    }

    public void setWidth(int width) {
        this.maxWidth = width <= 1 ? 0 : (int)((double)width * 0.6666666666666666);
    }

    public void toLines(FontAPI<?> font, Collection<String> lines) {
        this.compute();
        if (this.visibleElements.isEmpty() || this.maxWidth <= 0) {
            return;
        }
        this.visibleElements.sort(elementSorter);
        for (Element element : this.visibleElements) {
            element.toLines(font, this.maxWidth, lines);
        }
    }

    public void toLines(FontAPI<?> font, int width, Collection<String> lines) {
        this.setWidth(width);
        this.toLines(font, lines);
    }

    public void updateStructure(String name, String id) {
        this.structureName = name;
        this.structureID = id;
    }

    @Generated
    public void setHelper(ChannelHelper helper) {
        this.helper = helper;
    }

    public static enum ElementType {
        HEADER(Integer.MAX_VALUE),
        CHANNEL(10000),
        POSITION(1000),
        STATUS(100),
        TARGET(10),
        OTHER(0);

        final String id = this.name().toLowerCase();
        final int defaultPriority;

        private ElementType(int priority) {
            this.defaultPriority = priority;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public int getDefaultPriority() {
            return this.defaultPriority;
        }
    }

    public static class Element {
        private final ElementType type;
        private final String text;
        private final boolean translation;
        private final int priority;
        private Function<ChannelHelper, Boolean> visibility;
        private Function<ChannelHelper, Object[]> argSetter;
        private boolean visible;
        private Object[] args;

        private Element(ElementType type, String text, boolean isTranlation, int priority) {
            this.type = type;
            this.text = text;
            this.translation = isTranlation;
            this.priority = priority != 0 ? priority : type.defaultPriority;
        }

        void computeArgs(ChannelHelper helper) {
            this.args = Objects.nonNull(this.argSetter) ? this.argSetter.apply(helper) : null;
        }

        Element computeVisibility(ChannelHelper helper) {
            this.visible = Objects.isNull(this.visibility) || this.visibility.apply(helper) != false;
            return this;
        }

        @Nullable
        public String getNotBlankLine() {
            TextTranslationAPI<?> line;
            TextTranslationAPI<?> textTranslationAPI = this.translation ? this.getTranslated(this.text, Objects.nonNull(this.args) ? this.args : new Object[]{}) : (line = TextHelper.getLiteral((String)this.text));
            if (Objects.isNull(line)) {
                return null;
            }
            String applied = line.getApplied();
            return TextHelper.isNotBlank((String)applied) ? applied : null;
        }

        private TextTranslationAPI<?> getTranslated(String key, Object ... args) {
            String built = "debug.musictriggers." + this.type.getId();
            if (TextHelper.isNotEmpty((String)key)) {
                built = built + "." + key;
            }
            return TextHelper.getTranslated((String)built, (Object[])args);
        }

        private Element setVisibility(Function<ChannelHelper, Boolean> visibility) {
            this.visibility = visibility;
            return this;
        }

        public void toLines(FontAPI<?> font, int maxWidth, Collection<String> lines) {
            if (Objects.isNull(font)) {
                return;
            }
            String applied = this.getNotBlankLine();
            if (Objects.nonNull(applied)) {
                lines.addAll(TextHelper.hangingIndent((List)FontHelper.splitLines(font, (String)applied, (Number)maxWidth)));
            }
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public void setArgSetter(Function<ChannelHelper, Object[]> argSetter) {
            this.argSetter = argSetter;
        }

        @Generated
        public boolean isVisible() {
            return this.visible;
        }

        @Generated
        public Object[] getArgs() {
            return this.args;
        }
    }
}

