/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.client;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.client.MTClient;
import mods.thecomputerizer.musictriggers.api.client.gui.MTGUIScreen;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.ResourceContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.MinecraftAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.ClientEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.ClientConnectedEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.ClientDisconnectedEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.ClientTickEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.InputKeyEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.PlaySoundEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.RenderOverlayPreEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.events.RenderOverlayTextEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.event.types.ClientOverlayEventType;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.ScreenHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.advancement.AdvancementAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.CommonEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.events.PlayerAdvancementEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.events.PlayerInteractBlockEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.types.CommonTickableEventType;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextStyleAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;

public class MTClientEvents {
    private static AdvancementAPI<?> recentAdvancement;
    private static int ticksUntilReload;

    public static boolean checkAdvancement(ResourceContext ctx) {
        if (Objects.isNull(recentAdvancement)) {
            return false;
        }
        ResourceLocationAPI id = recentAdvancement.getID();
        if (ctx.checkMatch(id.toString(), id.getPath())) {
            recentAdvancement = null;
            return true;
        }
        return false;
    }

    public static void handleError(@Nullable MinecraftAPI<?> mc, String channel) {
        if (Objects.nonNull(mc)) {
            ClientHelper.sendMessage(MTClientEvents.getReloadMessage("error", new Object[]{channel}, TextStyleAPI::italics, TextStyleAPI::darkRed));
            MTClientEvents.queueReload(mc, 100);
        }
    }

    public static void init() {
        MTRef.logInfo("Initializing client event invokers {}", ClientHelper.getMinecraft());
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.CLIENT_CONNECTED, MTClientEvents::onClientConnected);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.CLIENT_DISCONNECTED, MTClientEvents::onClientDisconnected);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.KEY_INPUT, MTClientEvents::onKeyPress);
        EventHelper.addListener((EventWrapper.EventType)CommonEventWrapper.CommonType.PLAYER_ADVANCEMENT, MTClientEvents::onAdvancement);
        EventHelper.addListener((EventWrapper.EventType)CommonEventWrapper.CommonType.PLAYER_INTERACT_BLOCK, MTClientEvents::onRightClickBlock);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.RENDER_OVERLAY_PRE, MTClientEvents::onRenderOverlayPre);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.RENDER_OVERLAY_TEXT, MTClientEvents::onRenderOverlayText);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.SOUND_PLAY, MTClientEvents::onPlaySound);
        EventHelper.addListener((EventWrapper.EventType)ClientEventWrapper.ClientType.TICK_CLIENT, MTClientEvents::onClientTick);
    }

    private static void onAdvancement(PlayerAdvancementEventWrapper<?> wrapper) {
        recentAdvancement = wrapper.getAdvancement();
    }

    private static void onClientConnected(ClientConnectedEventWrapper<?> wrapper) {
        ChannelHelper.onClientConnected();
    }

    private static void onClientDisconnected(ClientDisconnectedEventWrapper<?> wrapper) {
        ChannelHelper.onClientDisconnected();
    }

    private static void onClientTick(ClientTickEventWrapper<?> wrapper) {
        if (ticksUntilReload < 0) {
            return;
        }
        if (wrapper.isPhase(CommonTickableEventType.TickPhase.END)) {
            MinecraftAPI mc = wrapper.getMinecraft();
            if (ticksUntilReload == 0) {
                ChannelHelper.reload(true);
                mc.sendMessageToPlayer(MTClientEvents.getReloadMessage("finished", null, TextStyleAPI::italics, TextStyleAPI::green));
            }
            --ticksUntilReload;
        }
    }

    public static void onKeyPress(InputKeyEventWrapper<?> wrapper) {
        if (MTGUIScreen.GUI_KEY.isDown()) {
            MTGUIScreen.open();
        }
    }

    private static void onPlaySound(PlaySoundEventWrapper<?> wrapper) {
    }

    private static void onRenderOverlayPre(RenderOverlayPreEventWrapper<?> wrapper) {
        if (wrapper.isType(ClientOverlayEventType.OverlayType.ALL) && MTGUIScreen.isActive) {
            wrapper.setCanceled(true);
        }
    }

    private static void onRenderOverlayText(RenderOverlayTextEventWrapper<?> wrapper) {
        ChannelHelper helper;
        if (!MTGUIScreen.isActive && Objects.nonNull(helper = ChannelHelper.getClientHelper()) && ChannelHelper.getDebugBool("enable_debug_info")) {
            MinecraftAPI mc = wrapper.getMinecraft();
            helper.getDebugInfo().toLines(mc.getFont(), (int)mc.getWindow().getWidthF(), wrapper.getLeft());
        }
    }

    private static void onRightClickBlock(PlayerInteractBlockEventWrapper<?> wrapper) {
        BlockPosAPI pos;
        BlockStateAPI state;
        ResourceLocationAPI registryName;
        WorldAPI world = wrapper.getPlayer().getWorld();
        if (world.isClient() && "jukebox".equals((registryName = (state = world.getStateAt(pos = wrapper.getPos())).getBlock().getRegistryName()).getPath()) && state.getPropertyBool("has_record")) {
            ChannelHelper.getClientHelper().stopJukeboxAt(pos);
        }
    }

    public static void queueReload(@Nullable MinecraftAPI<?> mc, int ticks) {
        ScreenHelper.open((ScreenAPI)null);
        if (ChannelHelper.getLoader().isLoading()) {
            ChannelHelper.logGlobalWarn("Tried to reload channels while they were already being reloaded", new Object[0]);
            return;
        }
        if (Objects.nonNull(mc) && ticks > 0) {
            ClientHelper.sendMessage(MTClientEvents.getReloadMessage("queue", new Object[]{ticks}, TextStyleAPI::italics, TextStyleAPI::red));
        }
        ChannelHelper.onReloadQueued(true);
        ticksUntilReload = ticks;
    }

    @SafeVarargs
    private static <S> TextAPI<?> getReloadMessage(String type, @Nullable Object[] args, Function<TextStyleAPI<S>, S> ... styleFuncs) {
        return MTClient.getStyledTranslated("message", "reload." + type, args, styleFuncs);
    }

    static {
        ticksUntilReload = -1;
    }
}

