/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.CPUInfo;
import com.github.natanbc.nativeloader.system.CacheInfo;
import com.github.natanbc.nativeloader.system.DefaultArchitectureTypes;
import com.github.natanbc.nativeloader.system.FeatureFormatter;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class ArmCPUInfo
extends CPUInfo {
    private final int cpuId;
    private final int implementer;
    private final int architecture;
    private final int variant;
    private final int part;
    private final int revision;

    public ArmCPUInfo(@Nonnull Map<String, Boolean> features, @Nonnull CacheInfo cacheInfo, int cpuId, int implementer, int architecture, int variant, int part, int revision) {
        super(DefaultArchitectureTypes.ARM, features, cacheInfo);
        this.cpuId = cpuId;
        this.implementer = implementer;
        this.architecture = architecture;
        this.variant = variant;
        this.part = part;
        this.revision = revision;
    }

    @CheckReturnValue
    public int cpuId() {
        return this.cpuId;
    }

    @CheckReturnValue
    public int implementer() {
        return this.implementer;
    }

    @CheckReturnValue
    public int architecture() {
        return this.architecture;
    }

    @CheckReturnValue
    public int variant() {
        return this.variant;
    }

    @CheckReturnValue
    public int part() {
        return this.part;
    }

    @CheckReturnValue
    public int revision() {
        return this.revision;
    }

    public String toString() {
        return "ArmCPU{features = " + FeatureFormatter.formatFeatures(this) + ", cpuId = " + this.cpuId() + ", implementer = " + this.implementer() + ", architecture = " + this.architecture() + ", variant = " + this.variant() + ", part = " + this.part() + ", revision = " + this.revision() + ", cache = " + this.cacheInfo() + "}";
    }
}

