/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.nativeloader.system;

import com.github.natanbc.nativeloader.system.CPUInfo;
import com.github.natanbc.nativeloader.system.CacheInfo;
import com.github.natanbc.nativeloader.system.DefaultArchitectureTypes;
import com.github.natanbc.nativeloader.system.FeatureFormatter;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class Aarch64CPUInfo
extends CPUInfo {
    private final int implementer;
    private final int variant;
    private final int part;
    private final int revision;

    public Aarch64CPUInfo(@Nonnull Map<String, Boolean> features, @Nonnull CacheInfo cacheInfo, int implementer, int variant, int part, int revision) {
        super(DefaultArchitectureTypes.ARMv8_64, features, cacheInfo);
        this.implementer = implementer;
        this.variant = variant;
        this.part = part;
        this.revision = revision;
    }

    @CheckReturnValue
    public int implementer() {
        return this.implementer;
    }

    @CheckReturnValue
    public int variant() {
        return this.variant;
    }

    @CheckReturnValue
    public int part() {
        return this.part;
    }

    @CheckReturnValue
    public int revision() {
        return this.revision;
    }

    public String toString() {
        return "Aarch64CPU{features = " + FeatureFormatter.formatFeatures(this) + ", implementer = " + this.implementer() + ", variant = " + this.variant() + ", part = " + this.part() + ", revision = " + this.revision() + ", cache = " + this.cacheInfo() + "}";
    }
}

