/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.vibrato;

import com.github.natanbc.lavadsp.Converter;

public class VibratoConverter
implements Converter {
    private static final int ADDITIONAL_DELAY = 3;
    private static final float BASE_DELAY_SEC = 0.002f;
    private static final float VIBRATO_FREQUENCY_DEFAULT_HZ = 2.0f;
    private static final float VIBRATO_FREQUENCY_MAX_HZ = 14.0f;
    private static final float VIBRATO_DEPTH_DEFAULT_PERCENT = 50.0f;
    private final float sampleRate;
    private final Lfo lfo;
    private final RingBuffer buffer;
    private float depth = 0.5f;

    public VibratoConverter(int sampleRate) {
        if (sampleRate < 1) {
            throw new IllegalArgumentException("Sample rate < 1");
        }
        this.sampleRate = sampleRate;
        this.lfo = new Lfo(sampleRate);
        this.buffer = new RingBuffer((int)(0.002f * (float)sampleRate * 2.0f));
    }

    public void setDepth(float depth) {
        if (depth <= 0.0f) {
            throw new IllegalArgumentException("Depth <= 0");
        }
        if (depth > 1.0f) {
            throw new IllegalArgumentException("Depth > 1");
        }
        this.depth = depth;
    }

    public void setFrequency(float frequency) {
        if (frequency <= 0.0f) {
            throw new IllegalArgumentException("Frequency <= 0");
        }
        if (frequency > 14.0f) {
            throw new IllegalArgumentException("Frequency > max (14.0)");
        }
        this.lfo.frequency = frequency;
    }

    @Override
    public void process(float[] input, int inputOffset, float[] output, int outputOffset, int samples) {
        for (int i = 0; i < samples; ++i) {
            float lfoValue = this.lfo.getValue();
            int maxDelay = (int)(0.002f * this.sampleRate);
            float delay = lfoValue * this.depth * (float)maxDelay + 3.0f;
            output[outputOffset + i] = this.buffer.getHermiteAt(delay);
            this.buffer.writeMargined(input[inputOffset + i]);
        }
    }

    private static class RingBuffer {
        private static final int INTERPOLATOR_MARGIN = 3;
        private final float[] buffer;
        private final int size;
        private int writeIndex;

        RingBuffer(int size) {
            this.buffer = new float[size + 3];
            this.size = size;
        }

        void writeMargined(float sample) {
            this.buffer[this.writeIndex] = sample;
            if (this.writeIndex < 3) {
                this.buffer[this.size + this.writeIndex] = sample;
            }
            ++this.writeIndex;
            if (this.writeIndex == this.size) {
                this.writeIndex = 0;
            }
        }

        float getHermiteAt(float delay) {
            float fReadIndex;
            for (fReadIndex = (float)(this.writeIndex - 1) - delay; fReadIndex < 0.0f; fReadIndex += (float)this.size) {
            }
            while (fReadIndex >= (float)this.size) {
                fReadIndex -= (float)this.size;
            }
            int iPart = (int)fReadIndex;
            float fPart = fReadIndex - (float)iPart;
            return RingBuffer.getSampleHermite4p3o(fPart, this.buffer, iPart);
        }

        private static float getSampleHermite4p3o(float x, float[] buffer, int offset) {
            float y0 = buffer[offset];
            float y1 = buffer[offset + 1];
            float y2 = buffer[offset + 2];
            float y3 = buffer[offset + 3];
            float c1 = 0.5f * (y2 - y0);
            float c2 = y0 - 2.5f * y1 + (2.0f * y2 - 0.5f * y3);
            float c3 = 0.5f * (y3 - y0) + 1.5f * (y1 - y2);
            return ((c3 * x + c2) * x + c1) * x + y1;
        }
    }

    private static class Lfo {
        private final float sampleRate;
        float frequency = 2.0f;
        float phase;

        Lfo(float sampleRate) {
            this.sampleRate = sampleRate;
        }

        float getValue() {
            float dp = (float)Math.PI * 2 * this.frequency / this.sampleRate;
            float value = (float)((Math.sin(this.phase) + 1.0) * 0.5);
            this.phase += dp;
            while ((double)this.phase > Math.PI * 2) {
                this.phase = (float)((double)this.phase - Math.PI * 2);
            }
            return value;
        }
    }
}

