/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.karaoke;

public class KaraokeConverter {
    private final int sampleRate;
    private float level = 1.0f;
    private float monoLevel = 1.0f;
    private float filterBand = 220.0f;
    private float filterWidth = 100.0f;
    private float A;
    private float B;
    private float C;
    private float y1;
    private float y2;

    public KaraokeConverter(int sampleRate) {
        if (sampleRate < 1) {
            throw new IllegalArgumentException("Sample rate < 1");
        }
        this.sampleRate = sampleRate;
    }

    public void setLevel(float level) {
        this.level = level;
    }

    public void setMonoLevel(float monoLevel) {
        this.monoLevel = monoLevel;
    }

    public void setFilterBand(float filterBand) {
        this.filterBand = filterBand;
        this.updateFilters();
    }

    public void setFilterWidth(float filterWidth) {
        this.filterWidth = filterWidth;
        this.updateFilters();
    }

    public void process(float[] leftIn, float[] rightIn, int inputOffset, float[] leftOut, float[] rightOut, int outputOffset, int samples) {
        for (int i = 0; i < samples; ++i) {
            float l = leftIn[inputOffset + i];
            float r = rightIn[inputOffset + i];
            float y = this.A * ((l + r) / 2.0f) - this.B * this.y1 - this.C * this.y2;
            this.y2 = this.y1;
            this.y1 = y;
            float o = y * this.monoLevel * this.level;
            leftOut[outputOffset + i] = l - r * this.level + o;
            rightOut[outputOffset + i] = r - l * this.level + o;
        }
    }

    private void updateFilters() {
        this.C = (float)Math.exp(Math.PI * -2 * (double)this.filterWidth / (double)this.sampleRate);
        this.B = (float)((double)(-4.0f * this.C / (1.0f + this.C)) * Math.cos(Math.PI * 2 * (double)this.filterBand / (double)this.sampleRate));
        this.A = (float)(Math.sqrt(1.0f - this.B * this.B / (4.0f * this.C)) * (double)(1.0f - this.C));
        this.y1 = 0.0f;
        this.y2 = 0.0f;
    }
}

