/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp.distortion;

import com.github.natanbc.lavadsp.ConverterPcmAudioFilter;
import com.github.natanbc.lavadsp.distortion.DistortionConverter;
import java.util.concurrent.atomic.AtomicInteger;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class DistortionPcmAudioFilter
extends ConverterPcmAudioFilter<DistortionConverter> {
    public static final int SIN = 1;
    public static final int COS = 2;
    public static final int TAN = 4;
    private volatile float sinOffset = 0.0f;
    private volatile float sinScale = 1.0f;
    private volatile float cosOffset = 0.0f;
    private volatile float cosScale = 1.0f;
    private volatile float tanOffset = 0.0f;
    private volatile float tanScale = 1.0f;
    private volatile float offset = 0.0f;
    private volatile float scale = 1.0f;
    private final AtomicInteger enabled = new AtomicInteger(7);

    public DistortionPcmAudioFilter(FloatPcmAudioFilter downstream, int channelCount) {
        super(DistortionConverter::new, downstream, channelCount);
    }

    public DistortionPcmAudioFilter enableFunctions(int functions) {
        for (DistortionConverter converter : this.converters()) {
            converter.enable(functions);
        }
        this.enabled.updateAndGet(v -> v | functions & 7);
        return this;
    }

    public DistortionPcmAudioFilter disableFunctions(int functions) {
        for (DistortionConverter converter : this.converters()) {
            converter.disable(functions);
        }
        this.enabled.updateAndGet(v -> v & ~functions);
        return this;
    }

    public boolean isEnabled(int function) {
        return (this.enabled.get() & (function & 7)) != 0;
    }

    public boolean allEnabled(int functions) {
        return (this.enabled.get() & (functions & 7)) == functions;
    }

    public float getSinOffset() {
        return this.sinOffset;
    }

    public DistortionPcmAudioFilter setSinOffset(float sinOffset) {
        for (DistortionConverter converter : this.converters()) {
            converter.setSinOffset(sinOffset);
        }
        this.sinOffset = sinOffset;
        return this;
    }

    public float getSinScale() {
        return this.sinScale;
    }

    public DistortionPcmAudioFilter setSinScale(float sinScale) {
        for (DistortionConverter converter : this.converters()) {
            converter.setSinScale(sinScale);
        }
        this.sinScale = sinScale;
        return this;
    }

    public float getCosOffset() {
        return this.cosOffset;
    }

    public DistortionPcmAudioFilter setCosOffset(float cosOffset) {
        for (DistortionConverter converter : this.converters()) {
            converter.setCosOffset(cosOffset);
        }
        this.cosOffset = cosOffset;
        return this;
    }

    public float getCosScale() {
        return this.cosScale;
    }

    public DistortionPcmAudioFilter setCosScale(float cosScale) {
        for (DistortionConverter converter : this.converters()) {
            converter.setCosScale(cosScale);
        }
        this.cosScale = cosScale;
        return this;
    }

    public float getTanOffset() {
        return this.tanOffset;
    }

    public DistortionPcmAudioFilter setTanOffset(float tanOffset) {
        for (DistortionConverter converter : this.converters()) {
            converter.setTanOffset(tanOffset);
        }
        this.tanOffset = tanOffset;
        return this;
    }

    public float getTanScale() {
        return this.tanScale;
    }

    public DistortionPcmAudioFilter setTanScale(float tanScale) {
        for (DistortionConverter converter : this.converters()) {
            converter.setTanScale(tanScale);
        }
        this.tanScale = tanScale;
        return this;
    }

    public float getOffset() {
        return this.offset;
    }

    public DistortionPcmAudioFilter setOffset(float offset) {
        for (DistortionConverter converter : this.converters()) {
            converter.setOffset(offset);
        }
        this.offset = offset;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public DistortionPcmAudioFilter setScale(float scale) {
        for (DistortionConverter converter : this.converters()) {
            converter.setScale(scale);
        }
        this.scale = scale;
        return this;
    }
}

