/*
 * Decompiled with CFR 0.152.
 */
package com.github.natanbc.lavadsp;

import com.github.natanbc.lavadsp.Converter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class ConverterPcmAudioFilter<T extends Converter>
implements FloatPcmAudioFilter {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    protected final List<T> converters;
    protected final FloatPcmAudioFilter downstream;
    protected final float[][] outputSegments;
    protected final int bufferSize;

    public ConverterPcmAudioFilter(Supplier<T> converterFactory, FloatPcmAudioFilter downstream, int channelCount, int bufferSize) {
        int i;
        ArrayList<T> converters = new ArrayList<T>(channelCount);
        for (i = 0; i < channelCount; ++i) {
            converters.add(converterFactory.get());
        }
        this.converters = Collections.unmodifiableList(converters);
        this.downstream = downstream;
        this.bufferSize = bufferSize;
        if (bufferSize < 1) {
            this.outputSegments = null;
        } else {
            this.outputSegments = new float[channelCount][];
            for (i = 0; i < channelCount; ++i) {
                this.outputSegments[i] = new float[bufferSize];
            }
        }
    }

    public ConverterPcmAudioFilter(Supplier<T> converterFactory, FloatPcmAudioFilter downstream, int channelCount) {
        this(converterFactory, downstream, channelCount, 4096);
    }

    public List<T> converters() {
        return this.converters;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        if (this.outputSegments == null) {
            for (int i = 0; i < input.length; ++i) {
                ((Converter)this.converters.get(i)).process(input[i], offset, input[i], 0, length);
            }
            this.downstream.process(input, 0, length);
        } else {
            for (int l = length; l > 0; l -= this.bufferSize) {
                int size = Math.min(l, this.bufferSize);
                for (int i = 0; i < input.length; ++i) {
                    ((Converter)this.converters.get(i)).process(input[i], offset, this.outputSegments[i], 0, size);
                }
                this.downstream.process(this.outputSegments, 0, size);
            }
        }
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        for (Converter converter : this.converters) {
            converter.close();
        }
    }

    @Deprecated
    protected final void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

