/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.asmc.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GeneralConfig {
    public static Configuration config;
    public static boolean versionChecker;
    public static boolean debugMessages;
    public static boolean moreCaveSounds;
    public static boolean woodendoorSounds_legacy;
    public static boolean woodendoorSounds_modern;
    public static boolean lilypadSounds;
    public static boolean noteBlockSounds;
    public static boolean beaconSounds;
    public static boolean soulsandSounds;
    public static boolean netherwartblockSounds;
    public static boolean boneblockSounds;
    public static boolean basaltblockSounds;
    public static boolean netherrackSounds;
    public static boolean netherquartzoreSounds;
    public static boolean netherbrickSounds;
    public static boolean mooshroommilkingSounds;
    public static boolean cropplantingSounds;
    public static boolean cropbreakingSounds;
    public static boolean redstoneSounds;
    public static boolean bookpageSounds;
    public static boolean swimSounds_legacy;
    public static boolean swimSounds_modern;
    public static boolean armorequipSounds;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GeneralConfig.loadConfiguration();
        }
    }

    protected static void loadConfiguration() {
        versionChecker = config.getBoolean("Version Checker", "General", true, "Displays a client-side chat message if there's an update available");
        debugMessages = config.getBoolean("Debug Messages", "General", false, "Print ALL positional sound occurrences to the console. This includes sound event path, the sound's location, and what block is in that location.");
        moreCaveSounds = config.getBoolean("More Cave", "Sounds: Ambient", true, "Add the [1.13+] cave sounds (affects client side only)");
        woodendoorSounds_legacy = config.getBoolean("Wooden Door: Legacy", "Sounds: Block", false, "Use the [1.9-1.12] Wooden Door sounds (affects client side only)");
        woodendoorSounds_modern = config.getBoolean("Wooden Door: Modern", "Sounds: Block", true, "Add the [1.13+] Wooden Door sounds (affects client side only)");
        lilypadSounds = config.getBoolean("Lilypad", "Sounds: Block", true, "Use proper sound when placing a lilypad onto ice as per [1.13+]");
        noteBlockSounds = config.getBoolean("Note Blocks", "Sounds: Block", true, "Add the [1.14+] Note Block tones");
        beaconSounds = config.getBoolean("Beacon", "Sounds: Block", true, "Add the [1.13+] ambient and start/stop sounds for the Beacon (affects client side only; disable if you experience tick lag)");
        soulsandSounds = config.getBoolean("Soul Sand", "Sounds: Block", true, "Use the [1.16+] Soul Sand sounds (affects client side only)");
        netherwartblockSounds = config.getBoolean("Nether Wart", "Sounds: Block", true, "Use the [1.16+] Nether Wart Block sounds (affects client side only)");
        boneblockSounds = config.getBoolean("Bone", "Sounds: Block", true, "Use the [1.16+] Bone Block sounds (affects client side only)");
        basaltblockSounds = config.getBoolean("Basalt", "Sounds: Block", true, "Use the [1.16+] Basalt Block sounds (affects client side only)");
        netherrackSounds = config.getBoolean("Netherrack", "Sounds: Block", true, "Use the [1.16+] Netherrack sounds (affects client side only)");
        netherquartzoreSounds = config.getBoolean("Nether Quartz Ore", "Sounds: Block", true, "Use the [1.16+] Quartz Ore sounds (affects client side only)");
        netherbrickSounds = config.getBoolean("Nether Brick", "Sounds: Block", true, "Use the [1.16+] Nether Brick sounds (affects client side only)");
        mooshroommilkingSounds = config.getBoolean("Mooshroom Milking", "Sounds: Entity", true, "Add the [1.14+] Mooshroom bowling sounds");
        cropplantingSounds = config.getBoolean("Crop Planting", "Sounds: Item", true, "Use the [1.14+] sounds when planting seeds or nether wart");
        cropbreakingSounds = config.getBoolean("Crop Breaking", "Sounds: Item", true, "Use the [1.14+] sounds when breaking seeds or nether wart (affects client side only)");
        redstoneSounds = config.getBoolean("Redstone", "Sounds: Item", true, "Use the [1.14+] stone sounds when placing redstone dust");
        bookpageSounds = config.getBoolean("Book", "Sounds: Player", true, "Use the [1.14+] sounds when turning a book page (affects client side only)");
        swimSounds_legacy = config.getBoolean("Swimming: Legacy", "Sounds: Player", false, "Include the swimming sounds used up through [1.12] (affects client side only)");
        swimSounds_modern = config.getBoolean("Swimming: Modern", "Sounds: Player", true, "Add the [1.13+] swimming sounds (affects client side only)");
        armorequipSounds = config.getBoolean("Armor Equip", "Sounds: Player", true, "Play armor equip sounds any way equipment is equipped, rather than only when right-clicked");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("asmc")) {
            this.loadConfiguration();
        }
    }
}

