/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RayCastUtil {
    @Nullable
    public static RayTraceResult rayTraceBlocksSight(@Nonnull World world, @Nonnull Entity entity, float scale) {
        return RayCastUtil.rayTraceBlocksSight(world, entity, scale, false);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksSight(@Nonnull World world, @Nonnull Entity entity, float scale, boolean fluid) {
        return RayCastUtil.rayTraceBlocksSight(world, entity, scale, fluid, false);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksSight(@Nonnull World world, @Nonnull Entity entity, float scale, boolean fluid, boolean bounding) {
        return RayCastUtil.rayTraceBlocksSight(world, entity, scale, fluid, bounding, false);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksSight(@Nonnull World world, @Nonnull Entity entity, float scale, boolean fluid, boolean bounding, boolean lastBlock) {
        Vec3d position = entity.func_174791_d();
        float eyeHeight = entity.func_70047_e();
        Vec3d vec1 = position.func_72441_c(0.0, (double)eyeHeight, 0.0);
        Vec3d vec2 = entity.func_70040_Z().func_186678_a((double)scale).func_178787_e(vec1);
        return world.func_147447_a(vec1, vec2, fluid, bounding, lastBlock);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(@Nonnull World world, @Nonnull Vec3d vec31, @Nonnull Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean allowNonfullCube) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, stopOnLiquid) || !block.isAir(iblockstate, (IBlockAccess)world, blockpos) && !block.func_176209_a(iblockstate, stopOnLiquid) && allowNonfullCube) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k && (!block.func_176209_a(iblockstate, stopOnLiquid) || block.isAir(iblockstate, (IBlockAccess)world, blockpos) || block.func_176209_a(iblockstate, stopOnLiquid) || !allowNonfullCube)) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid) || allowNonfullCube) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static Entity mouseOverEntity(EntityLivingBase entity) {
        return RayCastUtil.mouseOverEntity(entity, 3.0);
    }

    @Nullable
    public static Entity mouseOverEntity(EntityLivingBase entity, double maxReach) {
        RayTraceAndEntityResult result = RayCastUtil.rayTraceMouseOver(entity, maxReach);
        return result.getPointedEntity();
    }

    public static RayTraceAndEntityResult rayTraceMouseOver(EntityLivingBase traceEntity) {
        return RayCastUtil.rayTraceMouseOver(traceEntity, 3.0);
    }

    public static RayTraceAndEntityResult rayTraceMouseOver(EntityLivingBase traceEntity, double maxEntity) {
        World world = traceEntity.field_70170_p;
        Entity pointedEntity = null;
        boolean player = traceEntity instanceof EntityPlayer;
        Vec3d eyePos = traceEntity.func_174824_e(1.0f);
        Vec3d lookVec = traceEntity.func_70676_i(1.0f);
        double reach = player ? traceEntity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0;
        Vec3d modifiedLookVec = eyePos.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        RayTraceResult objectMouseOver = world.func_147447_a(eyePos, modifiedLookVec, false, false, true);
        boolean flag = false;
        double distance = reach;
        if (player && ((EntityPlayer)traceEntity).func_184812_l_()) {
            distance = 6.0;
        } else if (reach > maxEntity) {
            flag = true;
        }
        if (objectMouseOver != null) {
            distance = objectMouseOver.field_72307_f.func_72438_d(eyePos);
        }
        Vec3d hitVec = null;
        List list = world.func_175674_a((Entity)traceEntity, traceEntity.func_174813_aQ().func_72321_a(modifiedLookVec.field_72450_a, modifiedLookVec.field_72448_b, modifiedLookVec.field_72449_c).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, e -> e != null && e.func_70067_L()));
        double distance2 = distance;
        for (Entity entity : list) {
            double d3;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(eyePos, modifiedLookVec);
            if (axisalignedbb.func_72318_a(eyePos)) {
                if (!(distance2 >= 0.0)) continue;
                pointedEntity = entity;
                hitVec = raytraceresult == null ? eyePos : raytraceresult.field_72307_f;
                distance2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = eyePos.func_72438_d(raytraceresult.field_72307_f)) < distance2) && distance2 != 0.0) continue;
            if (entity.func_184208_bv() == traceEntity.func_184208_bv() && !entity.canRiderInteract()) {
                if (distance2 != 0.0) continue;
                pointedEntity = entity;
                hitVec = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity;
            hitVec = raytraceresult.field_72307_f;
            distance2 = d3;
        }
        if (pointedEntity != null && flag && eyePos.func_72438_d(hitVec) > maxEntity) {
            pointedEntity = null;
            objectMouseOver = new RayTraceResult(RayTraceResult.Type.MISS, hitVec, null, new BlockPos(hitVec));
        }
        if (pointedEntity != null && (distance2 < distance || objectMouseOver == null)) {
            objectMouseOver = new RayTraceResult(pointedEntity, hitVec);
        }
        return new RayTraceAndEntityResult(objectMouseOver, pointedEntity);
    }

    public static <T extends Entity> List<T> rayTraceEntities(Class<T> clazz, Entity traceTarget, double distance) {
        return RayCastUtil.rayTraceEntities(clazz, traceTarget, distance, 0.1);
    }

    public static List<Vec3d> rayTraceEntitiesPositions(Entity traceTarget, double distance) {
        float eyes = traceTarget.func_70047_e();
        Vec3d pos = traceTarget.func_174791_d();
        Vec3d posEyes = pos.func_72441_c(0.0, (double)eyes, 0.0);
        Vec3d lookVec = traceTarget.func_70040_Z();
        double yaw = Math.toRadians(-90.0f - traceTarget.field_70177_z);
        double offX = 0.5 * Math.sin(yaw);
        double offZ = 0.5 * Math.cos(yaw);
        Vec3d startPosition = new Vec3d(traceTarget.field_70165_t + offX, traceTarget.field_70163_u + (double)eyes, traceTarget.field_70161_v + offZ);
        RayTraceResult result = traceTarget.field_70170_p.func_147447_a(posEyes, posEyes.func_178787_e(lookVec.func_186678_a(distance)), false, true, true);
        Vec3d stopPosition = result == null ? posEyes.func_178787_e(lookVec.func_186678_a(distance)) : result.field_72307_f;
        return Arrays.asList(startPosition, stopPosition);
    }

    public static <T extends Entity> List<T> rayTraceEntities(Class<T> clazz, Entity traceTarget, double distance, double width) {
        List<Vec3d> positions = RayCastUtil.rayTraceEntitiesPositions(traceTarget, distance);
        Vec3d startPosition = positions.get(0);
        Vec3d stopPosition = positions.get(1);
        HashSet entities = new HashSet();
        double bx = Math.abs(stopPosition.field_72450_a - startPosition.field_72450_a) * width;
        double by = Math.abs(stopPosition.field_72448_b - startPosition.field_72448_b) * width;
        double bz = Math.abs(stopPosition.field_72449_c - startPosition.field_72449_c) * width;
        for (float i = 0.0f; i < 1.0f; i += 0.1f) {
            double x = startPosition.field_72450_a * (double)(1.0f - i) + stopPosition.field_72450_a * (double)i;
            double y = startPosition.field_72448_b * (double)(1.0f - i) + stopPosition.field_72448_b * (double)i;
            double z = startPosition.field_72449_c * (double)(1.0f - i) + stopPosition.field_72449_c * (double)i;
            entities.addAll(traceTarget.field_70170_p.func_175647_a(clazz, new AxisAlignedBB(x - bx, y - by, z - bz, x + bx, y + by, z + bz), o -> o != traceTarget));
        }
        ArrayList res = new ArrayList(entities);
        res.sort((o1, o2) -> Float.compare(o1.func_70032_d(traceTarget), o2.func_70032_d(traceTarget)));
        return res;
    }

    public static class RayTraceAndEntityResult {
        private RayTraceResult result;
        private Entity pointedEntity;

        public RayTraceAndEntityResult(RayTraceResult result, Entity pointedEntity) {
            this.result = result;
            this.pointedEntity = pointedEntity;
        }

        @Nullable
        public RayTraceResult getResult() {
            return this.result;
        }

        @Nullable
        public void setResult(RayTraceResult result) {
            this.result = result;
        }

        public Entity getPointedEntity() {
            return this.pointedEntity;
        }

        public void setPointedEntity(Entity pointedEntity) {
            this.pointedEntity = pointedEntity;
        }
    }
}

