/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.block.BlockBase;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOreBase
extends BlockBase {
    private final Item drop;
    private final int minXP;
    private final int maxXP;

    public BlockOreBase(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name, @Nullable Item drop, int level, int minXP, int maxXP) {
        super(mat, type, hardness, name);
        this.drop = drop;
        this.setHarvestLevel("pickaxe", level);
        this.minXP = minXP;
        this.maxXP = maxXP;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.drop != null) {
            return this.drop;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_149679_a(int fortune, Random random) {
        if (this.drop == null) {
            return super.func_149679_a(fortune, random);
        }
        int i = random.nextInt(fortune + 2) - 1;
        if (i < 0) {
            i = 0;
        }
        return this.func_149745_a(random) * (i + 1);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.minXP == -1 || this.maxXP == -1) {
            return 0;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)this.minXP, (int)this.maxXP);
    }
}

