/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.config;

import de.mennomax.astikorcarts.AstikorCarts;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="astikorcarts")
public class ModConfig {
    @Config.LangKey(value="config.astikorcarts:speedmodifier")
    @Config.RequiresMcRestart
    @Config.RangeDouble(min=-1.0, max=0.0)
    public static double speedModifier = -0.65;
    @Config.LangKey(value="entity.astikorcarts:cargocart.name")
    public static CargoCart cargoCart = new CargoCart();
    @Config.LangKey(value="entity.astikorcarts:plowcart.name")
    public static PlowCart plowCart = new PlowCart();
    @Config.LangKey(value="entity.astikorcarts:mobcart.name")
    public static MobCart mobCart = new MobCart();
    @Config.LangKey(value="entity.astikorcarts:conversionshoe.name")
    public static ConversionsHoe conversionsHoe = new ConversionsHoe();
    @Config.LangKey(value="entity.astikorcarts:conversionsshovel.name")
    public static ConversionsShovel conversionsShovel = new ConversionsShovel();
    @Config.LangKey(value="entity.astikorcarts:extrafoliage.name")
    public static ExtraFoliageBreaks extraFoliageBreaks = new ExtraFoliageBreaks();
    @Config.LangKey(value="entity.astikorcarts:conversionscustom")
    public static ConversionsCustom conversionsCustom = new ConversionsCustom();

    public static void generateMappings() {
        IBlockState blockstate2;
        IBlockState blockstate1;
        int meta2;
        Block block2;
        ResourceLocation resourceLocation2;
        int meta1;
        Block block1;
        ResourceLocation resourceLocation1;
        String[] ids2;
        String[] ids1;
        String blockString2;
        String blockString1;
        String[] twoEntries;
        AstikorCarts.shovelBlockConversionMap.clear();
        AstikorCarts.hoeBlockConversionMap.clear();
        AstikorCarts.foliageBreakSet.clear();
        for (String entry : ModConfig.conversionsShovel.blockConversionsShovel) {
            twoEntries = entry.replace(" ", "").split(",");
            if (twoEntries.length != 2) {
                System.err.println("AstikorCarts - Invalid config entry: " + entry);
                continue;
            }
            blockString1 = twoEntries[0];
            blockString2 = twoEntries[1];
            ids1 = blockString1.split(":");
            ids2 = blockString2.split(":");
            resourceLocation1 = new ResourceLocation(ids1[0], ids1[1]);
            block1 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation1);
            meta1 = ids1.length > 2 && ids1[2] != null ? Integer.parseInt(ids1[2]) : 0;
            resourceLocation2 = new ResourceLocation(ids2[0], ids2[1]);
            block2 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation2);
            int n = meta2 = ids2.length > 2 && ids2[2] != null ? Integer.parseInt(ids2[2]) : 0;
            if (block1 != null && block2 != null) {
                blockstate1 = block1.func_176203_a(meta1);
                blockstate2 = block2.func_176203_a(meta2);
                AstikorCarts.shovelBlockConversionMap.put(blockstate1, blockstate2);
                continue;
            }
            System.err.println("AstikorCarts - Invalid id: " + resourceLocation1 + " OR " + resourceLocation2);
        }
        for (String entry : ModConfig.conversionsHoe.blockConversionsHoe) {
            twoEntries = entry.replace(" ", "").split(",");
            if (twoEntries.length != 2) {
                System.err.println("AstikorCarts - Invalid config entry: " + entry);
                continue;
            }
            blockString1 = twoEntries[0];
            blockString2 = twoEntries[1];
            ids1 = blockString1.split(":");
            ids2 = blockString2.split(":");
            resourceLocation1 = new ResourceLocation(ids1[0], ids1[1]);
            block1 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation1);
            meta1 = ids1.length > 2 && ids1[2] != null ? Integer.parseInt(ids1[2]) : 0;
            resourceLocation2 = new ResourceLocation(ids2[0], ids2[1]);
            block2 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation2);
            int n = meta2 = ids2.length > 2 && ids2[2] != null ? Integer.parseInt(ids2[2]) : 0;
            if (block1 != null && block2 != null) {
                blockstate1 = block1.func_176203_a(meta1);
                blockstate2 = block2.func_176203_a(meta2);
                AstikorCarts.hoeBlockConversionMap.put(blockstate1, blockstate2);
                continue;
            }
            System.err.println("AstikorCarts - Invalid id: " + resourceLocation1 + " OR " + resourceLocation2);
        }
        for (String entry : ModConfig.extraFoliageBreaks.extraFoliageBreaks) {
            int meta;
            String cleanEntry = entry.replace(" ", "");
            String[] ids = cleanEntry.split(":");
            ResourceLocation resourceLocation = new ResourceLocation(ids[0], ids[1]);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            int n = meta = ids.length > 2 && ids[2] != null ? Integer.parseInt(ids[2]) : 0;
            if (block != null) {
                IBlockState blockstate = block.func_176203_a(meta);
                AstikorCarts.foliageBreakSet.add(blockstate);
                continue;
            }
            System.err.println("AstikorCarts - Invalid id: " + resourceLocation);
        }
        for (String entry : ModConfig.conversionsCustom.conversionsCustom) {
            String[] entries = entry.replace(" ", "").split(",");
            if (entries.length != 3) {
                System.err.println("AstikorCarts - Invalid config entry: " + entry);
                continue;
            }
            blockString1 = entries[0];
            blockString2 = entries[1];
            String itemString = entries[2];
            String[] ids12 = blockString1.split(":");
            resourceLocation1 = new ResourceLocation(ids12[0], ids12[1]);
            block1 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation1);
            meta1 = ids12.length > 2 && ids12[2] != null ? Integer.parseInt(ids12[2]) : 0;
            String[] ids22 = blockString2.split(":");
            ResourceLocation resourceLocation22 = new ResourceLocation(ids22[0], ids22[1]);
            Block block22 = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation22);
            int meta22 = ids22.length > 2 && ids22[2] != null ? Integer.parseInt(ids22[2]) : 0;
            String[] itemIds = itemString.split(":");
            ResourceLocation itemResourceLocation = new ResourceLocation(itemIds[0], itemIds[1]);
            Item requiredItem = (Item)ForgeRegistries.ITEMS.getValue(itemResourceLocation);
            if (block1 != null && block22 != null && requiredItem != null) {
                IBlockState blockstate12 = block1.func_176203_a(meta1);
                IBlockState blockstate22 = block22.func_176203_a(meta22);
                if (!AstikorCarts.customConversionMap.containsKey(blockstate12)) {
                    AstikorCarts.customConversionMap.put(blockstate12, new HashMap());
                }
                AstikorCarts.customConversionMap.get(blockstate12).put(requiredItem, blockstate22);
                AstikorCarts.allowedToolSet.add(requiredItem);
                continue;
            }
            System.err.println("AstikorCarts - Invalid block or item id: " + resourceLocation1 + ", " + resourceLocation22 + ", " + itemResourceLocation);
        }
    }

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("astikorcarts")) {
                ConfigManager.sync((String)"astikorcarts", (Config.Type)Config.Type.INSTANCE);
                ModConfig.generateMappings();
            }
        }
    }

    public static class ConversionsCustom {
        public String[] conversionsCustom = new String[]{"minecraft:sand, minecraft:clay, minecraft:bow"};
    }

    public static class ExtraFoliageBreaks {
        public String[] extraFoliageBreaks = new String[]{"minecraft:stone_button"};
    }

    public static class ConversionsShovel {
        public String[] blockConversionsShovel = new String[]{"minecraft:clay:0, minecraft:sand:0"};
    }

    public static class ConversionsHoe {
        public String[] blockConversionsHoe = new String[]{"minecraft:sponge:1, minecraft:sponge:0"};
    }

    public static class MobCart {
        public String[] canPull = new String[]{"minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig"};
    }

    public static class PlowCart {
        public String[] canPull = new String[]{"minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig"};
    }

    public static class CargoCart {
        public String[] canPull = new String[]{"minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig"};
    }
}

