/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.minecraft;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import gloomyfolken.hooklib.api.FieldLens;
import gloomyfolken.hooklib.api.HookContainer;
import gloomyfolken.hooklib.api.OnExpression;
import gloomyfolken.hooklib.asm.HookClassTransformer;
import gloomyfolken.hooklib.asm.HookContainerParser;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import gloomyfolken.hooklib.helper.KeepHookLibLastList;
import gloomyfolken.hooklib.helper.Logger;
import gloomyfolken.hooklib.helper.SideOnlyUtils;
import gloomyfolken.hooklib.helper.annotation.AnnotationMap;
import gloomyfolken.hooklib.helper.annotation.AnnotationUtils;
import gloomyfolken.hooklib.minecraft.Config;
import gloomyfolken.hooklib.minecraft.HookLibPlugin;
import gloomyfolken.hooklib.minecraft.HookLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class MainHookLoader
extends HookLoader {
    private boolean transformersListReplaced = false;

    @Override
    public String[] getASMTransformerClass() {
        if (!this.transformersListReplaced) {
            this.transformersListReplaced = true;
            ClassLoader classLoader = MainHookLoader.class.getClassLoader();
            if (classLoader instanceof LaunchClassLoader) {
                try {
                    Field field = LaunchClassLoader.class.getDeclaredField("transformers");
                    field.setAccessible(true);
                    List originalList = (List)field.get(classLoader);
                    KeepHookLibLastList replacementList = new KeepHookLibLastList(originalList);
                    field.set(classLoader, replacementList);
                }
                catch (NoSuchFieldException field) {
                }
                catch (Throwable e) {
                    throw new RuntimeException("unexpected exception while hooking up transformers collection", e);
                }
            } else {
                throw new IllegalStateException("HookLib was not loaded by LaunchClassLoader");
            }
        }
        return new String[]{HookClassTransformer.class.getName()};
    }

    @Override
    protected void registerHooks() {
        ListMultimap hooks = (ListMultimap)this.findHookContainers().stream().flatMap(HookContainerParser::parseHooks).distinct().collect(Multimaps.toMultimap(AsmInjection::getTargetClassName, Function.identity(), ArrayListMultimap::create));
        HookClassTransformer.registerAllHooks((ListMultimap<String, AsmInjection>)hooks);
    }

    private List<ClassNode> findHookContainers() {
        ArrayList<File> jarCandidates = new ArrayList<File>(10);
        ArrayList<File> classCandidates = new ArrayList<File>(100);
        ArrayList<ClassNode> result = new ArrayList<ClassNode>(1);
        this.addFromModsDir(jarCandidates, new File("./mods/"));
        this.addFromModsDir(jarCandidates, new File("./mods/1.12.2"));
        if (Config.instance.useClasspathCandidates) {
            this.addFromClasspath(jarCandidates, classCandidates);
        }
        HashSet<File> jarWithHooks = new HashSet<File>();
        for (File jar : jarCandidates) {
            try {
                Logger.instance.info("Finding hooks in jar: " + jar);
                ZipFile zipFile = new ZipFile(jar);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                    try {
                        InputStream is = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            if (is == null || !this.findHooksInStream(result, is)) continue;
                            jarWithHooks.add(jar);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof IllegalArgumentException && e.getStackTrace()[0].getClassName().equals(ClassReader.class.getName()) && e.getStackTrace()[0].getMethodName().equals("<init>")) {
                            Logger.instance.error("Failed to parse java9+ class " + jar + "#" + entry.getName());
                            continue;
                        }
                        Logger.instance.error("Failed to parse class " + jar + "#" + entry.getName(), e);
                    }
                }
            }
            catch (Throwable e) {
                Logger.instance.error("Failed to parse jar " + jar);
                e.printStackTrace();
            }
        }
        for (File classFile : classCandidates) {
            try {
                FileInputStream is = FileUtils.openInputStream((File)classFile);
                Throwable throwable = null;
                try {
                    this.findHooksInStream(result, is);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                Logger.instance.error("Failed to parse class " + classFile, e);
            }
        }
        for (File jar : jarWithHooks) {
            Logger.instance.info("Jar contains hooks, adding to classpath: " + jar);
            try {
                ((LaunchClassLoader)this.getClass().getClassLoader()).addURL(jar.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (!HookLibPlugin.getObfuscated()) continue;
            CoreModManager.getReparseableCoremods().add(jar.getName());
        }
        return result;
    }

    private void addFromClasspath(List<File> jarCandidates, List<File> classCandidates) {
        File[] minecraftSources;
        ModClassLoader modClassLoader = Loader.instance().getModClassLoader();
        for (File source : minecraftSources = modClassLoader.getParentSources()) {
            if (source.isFile()) {
                jarCandidates.add(source);
                continue;
            }
            if (!source.isDirectory()) continue;
            Collection classFiles = FileUtils.listFiles((File)source, (String[])new String[]{"class"}, (boolean)true);
            classCandidates.addAll(classFiles);
        }
    }

    private void addFromModsDir(List<File> jarCandidates, File folder) {
        File[] jarFiles = folder.listFiles(pathname -> pathname.getName().endsWith(".jar"));
        if (jarFiles != null) {
            jarCandidates.addAll(Arrays.asList(jarFiles));
        }
    }

    private boolean findHooksInStream(List<ClassNode> result, InputStream stream) throws IOException {
        ClassNode classNode = new ClassNode(327680);
        ClassReader classReader = new ClassReader(stream);
        classReader.accept((ClassVisitor)classNode, 1);
        AnnotationMap annotationMap = AnnotationUtils.annotationOf(classNode);
        if (annotationMap.contains(HookContainer.class) && SideOnlyUtils.isValidSide(annotationMap)) {
            if (this.needToParseFully(classNode)) {
                classNode = new ClassNode(327680);
                classReader.accept((ClassVisitor)classNode, 0);
            }
            result.add(classNode);
            return true;
        }
        return false;
    }

    private boolean needToParseFully(ClassNode classNode) {
        return this.haveExpressionHooks(classNode) || this.haveCreationFieldLenses(classNode);
    }

    private boolean haveExpressionHooks(ClassNode classNode) {
        return classNode.methods.stream().map(AnnotationUtils::annotationOf).anyMatch(a -> a.contains(OnExpression.class));
    }

    private boolean haveCreationFieldLenses(ClassNode classNode) {
        return classNode.fields.stream().map(AnnotationUtils::annotationOf).anyMatch(a -> a.contains(FieldLens.class) && a.get(FieldLens.class).createField());
    }
}

