/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.minecraft;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Config {
    instance;

    public boolean useClasspathCandidates = false;
    public boolean dumpChangedClasses = false;
    private final File file = new File("./config/hooklib.cfg");
    public final File dumpLocation = new File("./hooklib_dump");

    private Config() {
        this.loadConfig();
    }

    public void loadConfig() {
        try {
            this.file.getParentFile().mkdirs();
            if (!this.file.exists()) {
                this.writeDefaultConfig();
            }
            Map fields = Arrays.stream(Config.class.getFields()).collect(Collectors.toMap(Field::getName, Function.identity()));
            List<String> lines = Files.readAllLines(this.file.toPath());
            for (String line : lines) {
                Field field;
                if (!line.contains("=") || (field = (Field)fields.get(line.substring(line.indexOf(58) + 1, line.indexOf(61)))) == null) continue;
                field.set((Object)this, this.parseLine(line));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object parseLine(String line) {
        String type;
        switch (type = line.substring(0, line.indexOf(58))) {
            case "B": {
                return this.parseBoolean(line);
            }
        }
        return null;
    }

    private boolean parseBoolean(String line) {
        return Boolean.parseBoolean(line.substring(line.indexOf("=") + 1));
    }

    private void writeDefaultConfig() throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            writer.write("# Find hook-containers in classpath\n");
            writer.write("B:useClasspathCandidates=" + this.useClasspathCandidates + "\n\n");
            writer.write("# Will save classes which have affected by hooks to " + this.dumpLocation + "\n");
            writer.write("B:dumpChangedClasses=" + this.dumpChangedClasses + "\n\n");
        }
    }
}

