/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.helper.annotation;

import gloomyfolken.hooklib.helper.annotation.AnnotationInvocationHandler;
import gloomyfolken.hooklib.helper.annotation.AnnotationMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AnnotationUtils {
    public static AnnotationMap annotationOf(ClassNode classNode) {
        return AnnotationUtils.getAnnotationMap(classNode.invisibleAnnotations, classNode.visibleAnnotations);
    }

    public static AnnotationMap annotationOf(MethodNode methodNode) {
        return AnnotationUtils.getAnnotationMap(methodNode.invisibleAnnotations, methodNode.visibleAnnotations);
    }

    public static AnnotationMap annotationOf(FieldNode fieldNode) {
        return AnnotationUtils.getAnnotationMap(fieldNode.invisibleAnnotations, fieldNode.visibleAnnotations);
    }

    public static AnnotationMap annotationOfParameter(MethodNode methodNode, int parameter) {
        int length = Type.getArgumentTypes((String)methodNode.desc).length;
        List[] defaultValue = new List[length];
        return AnnotationUtils.getAnnotationMap(AnnotationUtils.notNull(methodNode.invisibleParameterAnnotations, defaultValue)[parameter], AnnotationUtils.notNull(methodNode.visibleParameterAnnotations, defaultValue)[parameter]);
    }

    private static <A> A notNull(A value, A defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    private static AnnotationMap getAnnotationMap(List<AnnotationNode> invisibleAnnotations, List<AnnotationNode> visibleAnnotations) {
        HashMap<String, Supplier<Object>> map = new HashMap<String, Supplier<Object>>();
        AnnotationUtils.notNullList(invisibleAnnotations).forEach(node -> map.put(node.desc, () -> AnnotationUtils.createInstance(node)));
        AnnotationUtils.notNullList(visibleAnnotations).forEach(node -> map.put(node.desc, () -> AnnotationUtils.createInstance(node)));
        return new AnnotationMap(map);
    }

    private static <A> List<A> notNullList(List<A> list) {
        return AnnotationUtils.notNull(list, Collections.emptyList());
    }

    private static Object createInstance(AnnotationNode annotationNode) {
        String className = Type.getType((String)annotationNode.desc).getClassName();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> annotationClass = Class.forName(className);
            List values = AnnotationUtils.notNullList(annotationNode.values);
            for (int i = 0; i < values.size(); i += 2) {
                String name = (String)values.get(i);
                Object value = values.get(i + 1);
                map.put(name, AnnotationUtils.parseValue(value));
            }
            return AnnotationUtils.annotation(annotationClass, map);
        }
        catch (ClassNotFoundException | NullPointerException e) {
            System.out.println("Error with annotation " + className + " parsing");
            e.printStackTrace();
            return null;
        }
    }

    private static Object parseValue(Object value) throws ClassNotFoundException {
        if (value instanceof String[]) {
            String[] enum1 = (String[])value;
            String enumType = Type.getType((String)enum1[0].replace('/', '.')).getClassName();
            String enumValue = enum1[1];
            Class<?> enumClass = Class.forName(enumType);
            return Enum.valueOf(enumClass, enumValue);
        }
        if (value instanceof AnnotationNode) {
            return AnnotationUtils.createInstance((AnnotationNode)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            Object[] arr = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = AnnotationUtils.parseValue(list.get(i));
            }
            return arr;
        }
        return value;
    }

    public static <A extends Annotation> A annotation(Class<A> annotationType, Map<String, Object> values) {
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(annotationType, values)));
    }
}

