/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.helper.annotation;

import com.google.common.collect.ImmutableMap;
import gloomyfolken.hooklib.helper.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class AnnotationInvocationHandler
implements Annotation,
InvocationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> values;
    private final int hashCode;
    private static final Map<Class<?>, Class<?>> boxedToPrimitive = ImmutableMap.builder().put(Boolean.class, Boolean.TYPE).put(Character.class, Character.TYPE).put(Byte.class, Byte.TYPE).put(Short.class, Short.TYPE).put(Integer.class, Integer.TYPE).put(Long.class, Long.TYPE).put(Float.class, Float.TYPE).put(Double.class, Double.TYPE).put(Void.class, Void.TYPE).build();

    AnnotationInvocationHandler(Class<? extends Annotation> annotationType, Map<String, Object> values) {
        this.annotationType = annotationType;
        this.values = Collections.unmodifiableMap(AnnotationInvocationHandler.normalize(annotationType, values));
        this.hashCode = HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"hashCode"});
    }

    static Map<String, Object> normalize(Class<? extends Annotation> annotationType, Map<String, Object> values) {
        HashMap<String, Object> valid = new HashMap<String, Object>();
        for (Method element : annotationType.getDeclaredMethods()) {
            String elementName = element.getName();
            if (values.containsKey(elementName)) {
                Object value;
                Class<?> actualType;
                Class<?> expectedType = element.getReturnType();
                if (!expectedType.isAssignableFrom(actualType = (value = values.get(elementName)).getClass())) {
                    if (elementName.equals("ordinal") && expectedType.equals(int[].class)) {
                        if (actualType.equals(Integer.class) || actualType.equals(Integer.TYPE)) {
                            value = new int[]{(Integer)value};
                        } else if (actualType.equals(Object[].class) || actualType.equals(Integer[].class)) {
                            value = Arrays.stream((Object[])value).mapToInt(i -> (Integer)i).toArray();
                        } else if (AnnotationInvocationHandler.isNotBoxedPrimitive(expectedType, actualType)) {
                            throw new IllegalArgumentException("actual type of " + elementName + " is " + actualType + ", expected " + expectedType);
                        }
                    } else if (AnnotationInvocationHandler.isNotBoxedPrimitive(expectedType, actualType)) {
                        throw new IllegalArgumentException("actual type of " + elementName + " is " + actualType + ", expected " + expectedType);
                    }
                }
                if (expectedType.isArray()) {
                    Class<?> componentType = expectedType.getComponentType();
                    int length = Array.getLength(value);
                    Object value2 = Array.newInstance(componentType, length);
                    for (int i2 = 0; i2 < length; ++i2) {
                        Array.set(value2, i2, Array.get(value, i2));
                    }
                    valid.put(elementName, value2);
                    continue;
                }
                valid.put(elementName, value);
                continue;
            }
            if (element.getDefaultValue() == null) continue;
            valid.put(elementName, element.getDefaultValue());
        }
        return valid;
    }

    private static boolean isNotBoxedPrimitive(Class<?> expectedType, Class<?> actualType) {
        if (expectedType.isPrimitive()) {
            return boxedToPrimitive.get(actualType) != expectedType;
        }
        return true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.values.containsKey(method.getName())) {
            return this.values.get(method.getName());
        }
        Logger.instance.error("wtf annotation " + this + " " + method);
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.annotationType.isInstance(other)) {
            return false;
        }
        Annotation that = this.annotationType.cast(other);
        for (Map.Entry<String, Object> element : this.values.entrySet()) {
            Object otherValue;
            Object value = element.getValue();
            try {
                otherValue = that.annotationType().getMethod(element.getKey(), new Class[0]).invoke((Object)that, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            if (Objects.deepEquals(value, otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.annotationType.getName()).append('(');
        TreeSet<String> sorted = new TreeSet<String>(this.values.keySet());
        for (String elementName : sorted) {
            String value = this.values.get(elementName).getClass().isArray() ? Arrays.deepToString(new Object[]{this.values.get(elementName)}).replaceAll("^\\[\\[", "[").replaceAll("]]$", "]") : this.values.get(elementName).toString();
            result.append(elementName).append('=').append(value).append(", ");
        }
        if (this.values.size() > 0) {
            result.delete(result.length() - 2, result.length());
        }
        result.append(")");
        return result.toString();
    }
}

