/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.helper;

import gloomyfolken.hooklib.helper.LogFormat;
import java.util.logging.FileHandler;

public enum Logger {
    instance;

    private java.util.logging.Logger toFileLogger;
    private boolean canLogToFile;

    private Logger() {
        try {
            this.toFileLogger = java.util.logging.Logger.getLogger("hooklib");
            FileHandler fh = new FileHandler("./logs/hooklib.log", true);
            this.toFileLogger.addHandler(fh);
            fh.setFormatter(new LogFormat());
            this.canLogToFile = true;
        }
        catch (Throwable e) {
            this.toFileLogger = null;
            this.canLogToFile = false;
            this.error("unable to init HookLib logger", e);
        }
    }

    public void debug(String message) {
        System.out.println("[HookLib][DEBUG] " + message);
        if (this.canLogToFile) {
            this.toFileLogger.fine(message);
        }
    }

    public void warning(String message) {
        System.out.println("[HookLib][WARNING] " + message);
        if (this.canLogToFile) {
            this.toFileLogger.warning(message);
        }
    }

    public void error(String message) {
        System.out.println("[HookLib][ERROR] " + message);
        if (this.canLogToFile) {
            this.toFileLogger.severe(message);
        }
    }

    public void error(String message, Throwable cause) {
        this.error(message);
        cause.printStackTrace();
        if (this.canLogToFile) {
            this.toFileLogger.throwing("", "", cause);
        }
    }

    public void info(String message) {
        System.out.println("[HookLib][INFO] " + message);
        if (this.canLogToFile) {
            this.toFileLogger.info(message);
        }
    }
}

