/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm.injections;

import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AsmMethodLensHook
implements AsmMethodInjection {
    private final String hookClassName;
    private final String hookMethodLensName;
    private final String hookMethodLensDescription;
    private final String targetClassInternalName;
    private final String targetMethodName;
    private final String targetMethodDescription;
    private final boolean isMandatory;

    public AsmMethodLensHook(String hookClassName, String hookMethodLensName, String hookMethodLensDescription, String targetClassName, String targetMethodName, String targetMethodDescription, boolean isMandatory) {
        this.hookClassName = hookClassName.replace('/', '.');
        this.hookMethodLensName = hookMethodLensName;
        this.hookMethodLensDescription = hookMethodLensDescription;
        this.targetClassInternalName = targetClassName.replace('.', '/');
        this.targetMethodName = targetMethodName;
        this.targetMethodDescription = targetMethodDescription;
        this.isMandatory = isMandatory;
    }

    @Override
    public String getTargetClassName() {
        return this.hookClassName;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public boolean isTargetMethod(String name, String desc) {
        return name.equals(this.hookMethodLensName) && desc.equals(this.hookMethodLensDescription);
    }

    @Override
    public HookInjectorFactory getInjectorFactory() {
        return HookInjectorFactory.BeginFactory.INSTANCE;
    }

    @Override
    public boolean isRequiredPrintLocalVariables() {
        return false;
    }

    @Override
    public void inject(HookInjectorMethodVisitor inj) {
        Type methodType = Type.getMethodType((String)this.hookMethodLensDescription);
        int variableId = 0;
        for (Type parameterType : methodType.getArgumentTypes()) {
            inj.visitVarInsn(parameterType.getOpcode(21), variableId);
            if (parameterType.getSort() == 8 || parameterType.getSort() == 7) {
                variableId += 2;
                continue;
            }
            ++variableId;
        }
        inj.visitMethodInsn(184, this.targetClassInternalName, this.targetMethodName + "$hook$lens$invoke", this.hookMethodLensDescription, false);
        inj.visitInsn(methodType.getReturnType().getOpcode(172));
    }

    @Override
    public InsnList injectNode(MethodNode methodNode, HookInjectorClassVisitor cv) {
        InsnList r = new InsnList();
        Type methodType = Type.getMethodType((String)this.hookMethodLensDescription);
        int variableId = 0;
        for (Type parameterType : methodType.getArgumentTypes()) {
            r.add((AbstractInsnNode)new VarInsnNode(parameterType.getOpcode(21), variableId));
            if (parameterType.getSort() == 8 || parameterType.getSort() == 7) {
                variableId += 2;
                continue;
            }
            ++variableId;
        }
        r.add((AbstractInsnNode)new MethodInsnNode(184, this.targetClassInternalName, this.targetMethodName + "$hook$lens$invoke", this.targetMethodDescription, false));
        return r;
    }

    @Override
    public boolean needToCreate() {
        return false;
    }

    @Override
    public void create(HookInjectorClassVisitor hookInjectorClassVisitor) {
    }
}

