/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm.injections;

import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjectionObserving;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class AsmMethodLens
implements AsmMethodInjectionObserving {
    static final String methodAccessorSuffix = "$hook$lens$invoke";
    private final String targetClassName;
    private final String targetMethodName;
    private final String targetMethodDescription;
    private final String invokerMethodDesc;
    private final boolean isMandatory;
    private boolean found = false;
    private boolean isStaticMethod = false;
    private String actualTargetMethodName;
    private String actualTargetMethodDescription;

    public AsmMethodLens(String targetClassName, String targetMethodName, String targetMethodDescription, String invokerMethodDesc, boolean isMandatory) {
        this.targetClassName = targetClassName;
        this.targetMethodName = targetMethodName;
        this.targetMethodDescription = targetMethodDescription;
        this.invokerMethodDesc = invokerMethodDesc;
        this.isMandatory = isMandatory;
        this.actualTargetMethodName = targetMethodName;
        this.actualTargetMethodDescription = targetMethodDescription;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public boolean isTargetMethod(String name, String desc) {
        return name.equals(this.targetMethodName) && desc.equals(this.targetMethodDescription);
    }

    @Override
    public HookInjectorFactory getInjectorFactory() {
        return HookInjectorFactory.ObservingFactory.INSTANCE;
    }

    @Override
    public void visitedMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.found = true;
        this.isStaticMethod = AsmUtils.isStatic(access);
        this.actualTargetMethodName = name;
        this.actualTargetMethodDescription = desc;
    }

    @Override
    public boolean needToCreate() {
        return true;
    }

    @Override
    public void create(HookInjectorClassVisitor classVisitor) {
        if (this.found) {
            this.createAccessorMethod(classVisitor);
        }
    }

    private void createAccessorMethod(HookInjectorClassVisitor classVisitor) {
        MethodVisitor mv = classVisitor.visitMethod(9, this.targetMethodName + methodAccessorSuffix, this.invokerMethodDesc, null, null);
        Type methodType = Type.getMethodType((String)this.targetMethodDescription);
        mv.visitCode();
        mv.visitLabel(new Label());
        if (!this.isStaticMethod) {
            mv.visitVarInsn(25, 0);
        }
        int variableId = 1;
        for (Type parameterType : methodType.getArgumentTypes()) {
            mv.visitVarInsn(parameterType.getOpcode(21), variableId);
            if (parameterType.getSort() == 8 || parameterType.getSort() == 7) {
                variableId += 2;
                continue;
            }
            ++variableId;
        }
        int invokeOpcode = this.isStaticMethod ? 184 : 182;
        mv.visitMethodInsn(invokeOpcode, this.getTargetClassInternalName(), this.actualTargetMethodName, this.actualTargetMethodDescription, false);
        mv.visitInsn(methodType.getReturnType().getOpcode(172));
        mv.visitLabel(new Label());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        classVisitor.markInjected(this);
    }

    @Override
    public boolean isRequiredPrintLocalVariables() {
        return false;
    }

    @Override
    public void inject(HookInjectorMethodVisitor inj) {
    }

    @Override
    public InsnList injectNode(MethodNode methodNode, HookInjectorClassVisitor cv) {
        return new InsnList();
    }
}

