/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm.injections;

import gloomyfolken.hooklib.api.HookPriority;
import gloomyfolken.hooklib.api.ReturnSolve;
import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.ReturnCondition;
import gloomyfolken.hooklib.asm.TypeHelper;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AsmHook
implements AsmMethodInjection,
Cloneable {
    private String targetClassName;
    private String targetMethodName;
    private List<Type> targetMethodParameters = new ArrayList<Type>(2);
    @Nullable
    private Type targetMethodReturnType;
    private String hooksClassName;
    private String hookMethodName;
    private List<Integer> transmittableVariableIds = new ArrayList<Integer>(2);
    private List<Type> hookMethodParameters = new ArrayList<Type>(2);
    public Type hookMethodReturnType = Type.VOID_TYPE;
    private boolean hasReturnValueParameter;
    private ReturnCondition returnCondition = ReturnCondition.NEVER;
    private HookInjectorFactory injectorFactory = HookInjectorFactory.BeginFactory.INSTANCE;
    private HookPriority priority = HookPriority.NORMAL;
    private String targetMethodDescription1;
    private String targetMethodDescription2;
    private String hookMethodDescription;
    private boolean createMethod;
    private boolean isMandatory = true;
    private boolean requiredPrintLocalVariables = false;

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    private String getHookClassInternalName() {
        return this.hooksClassName.replace('.', '/');
    }

    @Override
    public boolean isTargetMethod(String name, String desc) {
        if (!name.equals(this.targetMethodName)) {
            return false;
        }
        if (this.targetMethodReturnType == null) {
            return desc.startsWith(this.targetMethodDescription1);
        }
        return desc.equals(this.targetMethodDescription1) || desc.equals(this.targetMethodDescription2);
    }

    @Override
    public boolean needToCreate() {
        return this.createMethod;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public boolean isRequiredPrintLocalVariables() {
        return this.requiredPrintLocalVariables;
    }

    @Override
    public HookInjectorFactory getInjectorFactory() {
        return this.injectorFactory;
    }

    private boolean hasHookMethod() {
        return true;
    }

    @Override
    public void create(HookInjectorClassVisitor classVisitor) {
        HookInjectorMethodVisitor inj;
        ClassMetadataReader.MethodReference superMethod = classVisitor.transformer.classMetadataReader.findVirtualMethod(this.getTargetClassInternalName(), this.targetMethodName, this.targetMethodDescription1);
        MethodVisitor mv = classVisitor.visitMethod(1, superMethod == null ? this.targetMethodName : superMethod.name, this.targetMethodDescription1, null, null);
        if (mv instanceof HookInjectorMethodVisitor) {
            inj = (HookInjectorMethodVisitor)mv;
            inj.visitCode();
            inj.visitLabel(new Label());
            if (superMethod == null) {
                this.injectDefaultValue(inj, this.targetMethodReturnType);
            } else {
                this.injectSuperCall(inj, superMethod);
            }
        } else {
            throw new IllegalArgumentException("Hook injector not created");
        }
        this.injectReturn(inj, this.targetMethodReturnType);
        inj.visitLabel(new Label());
        inj.visitMaxs(0, 0);
        inj.visitEnd();
    }

    @Override
    public InsnList injectNode(MethodNode methodNode, HookInjectorClassVisitor cv) {
        InsnList r = new InsnList();
        Type targetMethodReturnType = Type.getReturnType((String)methodNode.desc);
        int returnLocalId = -1;
        if (this.hasReturnValueParameter) {
            returnLocalId = methodNode.maxLocals++;
            r.add((AbstractInsnNode)new VarInsnNode(targetMethodReturnType.getOpcode(54), returnLocalId));
        }
        r.add(this.injectInvokeStaticNode(methodNode, returnLocalId, this.hookMethodName, this.hookMethodDescription));
        if (this.returnCondition == ReturnCondition.ALWAYS) {
            r.add((AbstractInsnNode)new InsnNode(targetMethodReturnType.getOpcode(172)));
        } else if (this.returnCondition == ReturnCondition.ON_SOLVE) {
            LabelNode doNotReturn = new LabelNode(new Label());
            int hookResultLocalId = methodNode.maxLocals++;
            r.add((AbstractInsnNode)new VarInsnNode(this.hookMethodReturnType.getOpcode(54), hookResultLocalId));
            r.add((AbstractInsnNode)new VarInsnNode(this.hookMethodReturnType.getOpcode(21), hookResultLocalId));
            r.add((AbstractInsnNode)new TypeInsnNode(193, Type.getDescriptor(ReturnSolve.Yes.class)));
            r.add((AbstractInsnNode)new JumpInsnNode(153, doNotReturn));
            if (targetMethodReturnType != Type.VOID_TYPE) {
                r.add((AbstractInsnNode)new VarInsnNode(this.hookMethodReturnType.getOpcode(21), hookResultLocalId));
                r.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(ReturnSolve.Yes.class)));
                Type boxed = (Type)AsmUtils.objectToPrimitive.inverse().getOrDefault((Object)targetMethodReturnType, (Object)targetMethodReturnType);
                r.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(ReturnSolve.Yes.class), "value", Type.getDescriptor(Object.class)));
                r.add((AbstractInsnNode)new TypeInsnNode(192, boxed.getInternalName()));
                if (boxed != targetMethodReturnType) {
                    r.add((AbstractInsnNode)new MethodInsnNode(182, boxed.getInternalName(), AsmUtils.primitiveToUnboxingMethod.get(targetMethodReturnType), Type.getMethodDescriptor((Type)targetMethodReturnType, (Type[])new Type[0]), false));
                }
            }
            r.add((AbstractInsnNode)new InsnNode(targetMethodReturnType.getOpcode(172)));
            r.add((AbstractInsnNode)doNotReturn);
        }
        if (this.hasReturnValueParameter) {
            r.add((AbstractInsnNode)new VarInsnNode(targetMethodReturnType.getOpcode(21), returnLocalId));
        }
        return r;
    }

    @Override
    public void inject(HookInjectorMethodVisitor inj) {
        Type targetMethodReturnType = inj.methodType.getReturnType();
        int returnLocalId = -1;
        if (this.hasReturnValueParameter) {
            returnLocalId = inj.newLocal(targetMethodReturnType);
            inj.visitVarInsn(targetMethodReturnType.getOpcode(54), returnLocalId);
        }
        this.injectInvokeStatic(inj, returnLocalId, this.hookMethodName, this.hookMethodDescription);
        if (this.returnCondition == ReturnCondition.ALWAYS) {
            this.injectReturn(inj, targetMethodReturnType);
        } else if (this.returnCondition == ReturnCondition.ON_SOLVE) {
            Label doNotReturn = inj.newLabel();
            int hookResultLocalId = inj.newLocal(this.hookMethodReturnType);
            inj.visitVarInsn(this.hookMethodReturnType.getOpcode(54), hookResultLocalId);
            inj.visitVarInsn(this.hookMethodReturnType.getOpcode(21), hookResultLocalId);
            inj.visitTypeInsn(193, Type.getInternalName(ReturnSolve.Yes.class));
            inj.visitJumpInsn(153, doNotReturn);
            if (targetMethodReturnType != Type.VOID_TYPE) {
                inj.visitVarInsn(this.hookMethodReturnType.getOpcode(21), hookResultLocalId);
                inj.visitTypeInsn(192, Type.getInternalName(ReturnSolve.Yes.class));
                Type boxed = (Type)AsmUtils.objectToPrimitive.inverse().getOrDefault((Object)targetMethodReturnType, (Object)targetMethodReturnType);
                inj.visitFieldInsn(180, Type.getInternalName(ReturnSolve.Yes.class), "value", Type.getDescriptor(Object.class));
                inj.visitTypeInsn(192, boxed.getInternalName());
                if (boxed != targetMethodReturnType) {
                    inj.visitMethodInsn(182, boxed.getInternalName(), AsmUtils.primitiveToUnboxingMethod.get(targetMethodReturnType), Type.getMethodDescriptor((Type)targetMethodReturnType, (Type[])new Type[0]), false);
                }
            }
            this.injectReturn(inj, targetMethodReturnType);
            inj.visitLabel(doNotReturn);
        }
        if (this.hasReturnValueParameter) {
            this.injectLoad(inj, targetMethodReturnType, returnLocalId);
        }
    }

    private void injectLoad(HookInjectorMethodVisitor inj, Type parameterType, int variableId) {
        int opcode = parameterType == Type.INT_TYPE || parameterType == Type.BYTE_TYPE || parameterType == Type.CHAR_TYPE || parameterType == Type.BOOLEAN_TYPE || parameterType == Type.SHORT_TYPE ? 21 : (parameterType == Type.LONG_TYPE ? 22 : (parameterType == Type.FLOAT_TYPE ? 23 : (parameterType == Type.DOUBLE_TYPE ? 24 : 25)));
        inj.visitVarInsn(opcode, variableId);
    }

    private void injectSuperCall(HookInjectorMethodVisitor inj, ClassMetadataReader.MethodReference method) {
        int variableId = 0;
        for (int i = 0; i <= this.targetMethodParameters.size(); ++i) {
            Type parameterType = i == 0 ? TypeHelper.getType(this.targetClassName) : this.targetMethodParameters.get(i - 1);
            this.injectLoad(inj, parameterType, variableId);
            if (parameterType.getSort() == 8 || parameterType.getSort() == 7) {
                variableId += 2;
                continue;
            }
            ++variableId;
        }
        inj.visitMethodInsn(183, method.owner, method.name, method.desc, false);
    }

    private void injectDefaultValue(HookInjectorMethodVisitor inj, Type targetMethodReturnType) {
        switch (targetMethodReturnType.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                inj.visitInsn(3);
                break;
            }
            case 6: {
                inj.visitInsn(11);
                break;
            }
            case 7: {
                inj.visitInsn(9);
                break;
            }
            case 8: {
                inj.visitInsn(14);
                break;
            }
            default: {
                inj.visitInsn(1);
            }
        }
    }

    private void injectReturn(HookInjectorMethodVisitor inj, Type targetMethodReturnType) {
        inj.visitInsn(targetMethodReturnType.getOpcode(172));
    }

    private InsnList injectInvokeStaticNode(MethodNode methodNode, int returnLocalId, String name, String desc) {
        InsnList r = new InsnList();
        for (int i = 0; i < this.hookMethodParameters.size(); ++i) {
            Type parameterType = this.hookMethodParameters.get(i);
            int variableId = this.transmittableVariableIds.get(i);
            if (AsmUtils.isStatic(methodNode)) {
                if (variableId == 0) {
                    r.add((AbstractInsnNode)new InsnNode(1));
                    continue;
                }
                if (variableId > 0) {
                    --variableId;
                }
            }
            if (variableId == -1) {
                variableId = returnLocalId;
            }
            r.add((AbstractInsnNode)new VarInsnNode(parameterType.getOpcode(21), variableId));
        }
        r.add((AbstractInsnNode)new MethodInsnNode(184, this.getHookClassInternalName(), name, desc, false));
        return r;
    }

    private void injectInvokeStatic(HookInjectorMethodVisitor inj, int returnLocalId, String name, String desc) {
        for (int i = 0; i < this.hookMethodParameters.size(); ++i) {
            Type parameterType = this.hookMethodParameters.get(i);
            int variableId = this.transmittableVariableIds.get(i);
            if (inj.isStatic) {
                if (variableId == 0) {
                    inj.visitInsn(1);
                    continue;
                }
                if (variableId > 0) {
                    --variableId;
                }
            }
            if (variableId == -1) {
                variableId = returnLocalId;
            }
            this.injectLoad(inj, parameterType, variableId);
        }
        inj.visitMethodInsn(184, this.getHookClassInternalName(), name, desc, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsmHook: ");
        sb.append(this.targetClassName).append('#').append(this.targetMethodName);
        sb.append(this.targetMethodDescription1);
        sb.append(" -> ");
        sb.append(this.hooksClassName).append('#').append(this.hookMethodName);
        sb.append(this.hookMethodDescription);
        sb.append(", ReturnCondition=" + (Object)((Object)this.returnCondition));
        sb.append(", InjectorFactory: " + this.injectorFactory.getClass().getName());
        sb.append(", CreateMethod = " + this.createMethod);
        return sb.toString();
    }

    @Override
    public int compareTo(AsmInjection o) {
        if (o instanceof AsmHook) {
            AsmHook otherHook = (AsmHook)o;
            if (this.injectorFactory.isPriorityInverted && otherHook.injectorFactory.isPriorityInverted) {
                return this.priority.ordinal() > otherHook.priority.ordinal() ? -1 : 1;
            }
            if (!this.injectorFactory.isPriorityInverted && !otherHook.injectorFactory.isPriorityInverted) {
                return this.priority.ordinal() > otherHook.priority.ordinal() ? 1 : -1;
            }
            return this.injectorFactory.isPriorityInverted ? 1 : -1;
        }
        return 0;
    }

    public static Builder newBuilder() {
        AsmHook asmHook = new AsmHook();
        asmHook.getClass();
        return asmHook.new Builder();
    }

    public class Builder
    extends AsmHook {
        private Builder() {
        }

        public Builder setTargetClass(String className) {
            AsmHook.this.targetClassName = className;
            return this;
        }

        public Builder setTargetMethod(String methodName) {
            AsmHook.this.targetMethodName = methodName;
            return this;
        }

        public Builder addTargetMethodParameters(Type ... parameterTypes) {
            for (Type type : parameterTypes) {
                AsmHook.this.targetMethodParameters.add(type);
            }
            return this;
        }

        public Builder setTargetMethodReturnType(Type type) {
            AsmHook.this.targetMethodReturnType = type;
            return this;
        }

        public Builder setHookClass(String className) {
            AsmHook.this.hooksClassName = className;
            return this;
        }

        public Builder setHookMethod(String methodName) {
            AsmHook.this.hookMethodName = methodName;
            return this;
        }

        public Builder addHookMethodParameter(Type parameterType, int variableId) {
            AsmHook.this.hookMethodParameters.add(parameterType);
            AsmHook.this.transmittableVariableIds.add(variableId);
            return this;
        }

        public Builder addThisToHookMethodParameters() {
            AsmHook.this.hookMethodParameters.add(TypeHelper.getType(AsmHook.this.targetClassName));
            AsmHook.this.transmittableVariableIds.add(0);
            return this;
        }

        public Builder addReturnValueToHookMethodParameters() {
            if (AsmHook.this.targetMethodReturnType == Type.VOID_TYPE) {
                throw new IllegalStateException("Target method's return type is void, it does not make sense to transmit its return value to hook method.");
            }
            AsmHook.this.hookMethodParameters.add(AsmHook.this.targetMethodReturnType);
            AsmHook.this.transmittableVariableIds.add(-1);
            AsmHook.this.hasReturnValueParameter = true;
            return this;
        }

        public Builder setReturnCondition(ReturnCondition condition) {
            AsmHook.this.returnCondition = condition;
            return this;
        }

        public void setHookMethodReturnType(Type type) {
            AsmHook.this.hookMethodReturnType = type;
        }

        public Builder setInjectorFactory(HookInjectorFactory factory) {
            AsmHook.this.injectorFactory = factory;
            return this;
        }

        public Builder setPriority(HookPriority priority) {
            AsmHook.this.priority = priority;
            return this;
        }

        public Builder setCreateMethod(boolean createMethod) {
            AsmHook.this.createMethod = createMethod;
            return this;
        }

        public Builder setMandatory(boolean isMandatory) {
            AsmHook.this.isMandatory = isMandatory;
            return this;
        }

        public Builder setRequiredPrintLocalVariables(boolean requiredPrintLocalVariables) {
            AsmHook.this.requiredPrintLocalVariables = requiredPrintLocalVariables;
            return this;
        }

        private String getMethodDesc(Type returnType, List<Type> paramTypes) {
            Type[] paramTypesArray = paramTypes.toArray(new Type[0]);
            if (returnType == null) {
                String voidDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypesArray);
                return voidDesc.substring(0, voidDesc.length() - 1);
            }
            return Type.getMethodDescriptor((Type)returnType, (Type[])paramTypesArray);
        }

        public AsmHook build() {
            AsmHook hook = AsmHook.this;
            if (hook.createMethod && hook.targetMethodReturnType == null) {
                hook.targetMethodReturnType = hook.hookMethodReturnType;
            }
            hook.targetMethodDescription1 = this.getMethodDesc(hook.targetMethodReturnType, hook.targetMethodParameters);
            Type maybePrimitive = (Type)AsmUtils.objectToPrimitive.get((Object)hook.targetMethodReturnType);
            if (maybePrimitive == null) {
                hook.targetMethodDescription2 = hook.targetMethodDescription1;
            } else {
                hook.targetMethodDescription2 = this.getMethodDesc(maybePrimitive, hook.targetMethodParameters);
            }
            hook.hookMethodDescription = Type.getMethodDescriptor((Type)hook.hookMethodReturnType, (Type[])hook.hookMethodParameters.toArray(new Type[0]));
            try {
                hook = (AsmHook)AsmHook.this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (hook.targetClassName == null) {
                throw new IllegalStateException("Target class name is not specified. Call setTargetClassName() before build().");
            }
            if (hook.targetMethodName == null) {
                throw new IllegalStateException("Target method name is not specified. Call setTargetMethodName() before build().");
            }
            if (!(hook.injectorFactory instanceof HookInjectorFactory.ReturnFactory) && hook.hasReturnValueParameter) {
                throw new IllegalStateException("Can not pass return value to hook method because hook location is not return insn.");
            }
            return hook;
        }
    }
}

