/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm.injections;

import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.GeneratedClassLoader;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.SafeClassWriter;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class AsmFieldLensHook
implements AsmMethodInjection {
    private final String hookClassName;
    private final String hookFieldLensName;
    private final String targetClassInternalName;
    private final String targetFieldName;
    private final Type targetFieldType;
    private final boolean isMandatory;
    private final String setterDesc;
    private final String getterDesc;

    public AsmFieldLensHook(String hookClassName, String hookFieldLensName, String targetClassName, String targetFieldName, Type targetFieldType, boolean isMandatory, String setterDesc, String getterDesc) {
        this.hookClassName = hookClassName.replace('/', '.');
        this.hookFieldLensName = hookFieldLensName;
        this.targetClassInternalName = targetClassName.replace('.', '/');
        this.targetFieldName = targetFieldName;
        this.targetFieldType = targetFieldType;
        this.isMandatory = isMandatory;
        this.setterDesc = setterDesc;
        this.getterDesc = getterDesc;
    }

    @Override
    public String getTargetClassName() {
        return this.hookClassName;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public boolean needToCreate() {
        return true;
    }

    @Override
    public void create(HookInjectorClassVisitor classVisitor) {
        MethodVisitor mv = classVisitor.visitMethod(8, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        if (!(mv instanceof HookInjectorMethodVisitor)) {
            throw new IllegalArgumentException("Hook injector not created");
        }
        HookInjectorMethodVisitor inj = (HookInjectorMethodVisitor)mv;
        inj.visitCode();
        inj.visitLabel(new Label());
        inj.visitInsn(177);
        inj.visitMaxs(0, 0);
        inj.visitEnd();
    }

    @Override
    public boolean isTargetMethod(String name, String desc) {
        return name.equals("<clinit>");
    }

    @Override
    public HookInjectorFactory getInjectorFactory() {
        return new HookInjectorFactory.ReturnFactory(new int[0]);
    }

    @Override
    public boolean isRequiredPrintLocalVariables() {
        return false;
    }

    @Override
    public void inject(HookInjectorMethodVisitor inj) {
        String lensClassName = this.hookClassName + "$" + this.hookFieldLensName + "$lens";
        this.generateLensClass(lensClassName, inj.cv.transformer.classMetadataReader);
        inj.visitLdcInsn(lensClassName);
        inj.visitInsn(4);
        inj.visitFieldInsn(178, "gloomyfolken/hooklib/asm/GeneratedClassLoader", "instance", "Lgloomyfolken/hooklib/asm/GeneratedClassLoader;");
        inj.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
        inj.visitMethodInsn(182, "java/lang/Class", "newInstance", "()Ljava/lang/Object;", false);
        inj.visitTypeInsn(192, "gloomyfolken/hooklib/api/FieldAccessor");
        inj.visitFieldInsn(179, this.hookClassName.replace('.', '/'), this.hookFieldLensName, "Lgloomyfolken/hooklib/api/FieldAccessor;");
    }

    private void generateLensClass(String lensClassName, ClassMetadataReader classMetadataReader) {
        String lensClassInternalName = lensClassName.replace('.', '/');
        SafeClassWriter classWriter = new SafeClassWriter(classMetadataReader, 2);
        String targetClassDescriptor = Type.getObjectType((String)this.targetClassInternalName).getDescriptor();
        String lensClassDescriptor = Type.getObjectType((String)lensClassInternalName).getDescriptor();
        classWriter.visit(52, 33, lensClassInternalName, "Ljava/lang/Object;Lgloomyfolken/hooklib/api/FieldAccessor<" + targetClassDescriptor + this.targetFieldType.getDescriptor() + ">;", Type.getInternalName(Object.class), new String[]{"gloomyfolken/hooklib/api/FieldAccessor"});
        classWriter.visitSource(".dynamic", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(7, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", lensClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        Type boxed = (Type)AsmUtils.objectToPrimitive.inverse().getOrDefault((Object)this.targetFieldType, (Object)this.targetFieldType);
        String getDescriptor = Type.getMethodDescriptor((Type)boxed, (Type[])new Type[]{Type.getObjectType((String)this.targetClassInternalName)});
        methodVisitor = classWriter.visitMethod(1, "get", getDescriptor, null, null);
        methodVisitor.visitCode();
        Label label02 = new Label();
        methodVisitor.visitLabel(label02);
        methodVisitor.visitLineNumber(11, label02);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(184, this.targetClassInternalName, this.targetFieldName + "$hook$lens$get", this.getterDesc, false);
        if (boxed != this.targetFieldType) {
            methodVisitor.visitMethodInsn(184, boxed.getInternalName(), "valueOf", Type.getMethodDescriptor((Type)boxed, (Type[])new Type[]{this.targetFieldType}), false);
        }
        methodVisitor.visitInsn(176);
        Label label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitLocalVariable("this", lensClassDescriptor, null, label02, label12, 0);
        methodVisitor.visitLocalVariable("instance", targetClassDescriptor, null, label02, label12, 1);
        methodVisitor.visitMaxs(1, 2);
        methodVisitor.visitEnd();
        String setDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getObjectType((String)this.targetClassInternalName), boxed});
        methodVisitor = classWriter.visitMethod(1, "set", setDescriptor, null, null);
        methodVisitor.visitCode();
        Label label03 = new Label();
        methodVisitor.visitLabel(label03);
        methodVisitor.visitLineNumber(16, label03);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        if (boxed != this.targetFieldType) {
            methodVisitor.visitMethodInsn(182, boxed.getInternalName(), AsmUtils.primitiveToUnboxingMethod.get(this.targetFieldType), Type.getMethodDescriptor((Type)this.targetFieldType, (Type[])new Type[0]), false);
        }
        methodVisitor.visitMethodInsn(184, this.targetClassInternalName, this.targetFieldName + "$hook$lens$set", this.setterDesc, false);
        Label label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLineNumber(17, label13);
        methodVisitor.visitInsn(177);
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLocalVariable("this", lensClassDescriptor, null, label03, label2, 0);
        methodVisitor.visitLocalVariable("instance", targetClassDescriptor, null, label03, label2, 1);
        methodVisitor.visitLocalVariable("newValue", this.targetFieldType.getDescriptor(), null, label03, label2, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        label03 = new Label();
        methodVisitor.visitLabel(label03);
        methodVisitor.visitLineNumber(7, label03);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.targetClassInternalName);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, boxed.getInternalName());
        methodVisitor.visitMethodInsn(182, lensClassInternalName, "set", setDescriptor, false);
        methodVisitor.visitInsn(177);
        label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLocalVariable("this", lensClassDescriptor, null, label03, label13, 0);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label03 = new Label();
        methodVisitor.visitLabel(label03);
        methodVisitor.visitLineNumber(7, label03);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.targetClassInternalName);
        methodVisitor.visitMethodInsn(182, lensClassInternalName, "get", getDescriptor, false);
        methodVisitor.visitInsn(176);
        label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLocalVariable("this", lensClassDescriptor, null, label03, label13, 0);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        GeneratedClassLoader.instance.addClass(lensClassName, classWriter.toByteArray());
    }

    @Override
    public InsnList injectNode(MethodNode methodNode, HookInjectorClassVisitor cv) {
        return null;
    }

    @Override
    public String getPatchedMethodName(String actualName, String actualDescription) {
        return this.hookClassName + '#' + "<clinit>";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsmLensHook: ");
        sb.append(this.targetClassInternalName).append('#').append(this.targetFieldName).append(": ");
        sb.append(this.targetFieldType);
        sb.append(" -> ");
        sb.append(this.hookClassName).append('#').append(this.hookFieldLensName);
        return sb.toString();
    }
}

