/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm.injections;

import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmFieldLens
implements AsmInjection {
    static final String setterSuffix = "$hook$lens$set";
    static final String getterSuffix = "$hook$lens$get";
    private final String targetClassName;
    private final String targetFieldName;
    private final Set<String> expectedTargetFieldTypeDescriptors;
    private final boolean isMandatory;
    private final Type boxedType;
    private final boolean createField;
    private final String setterDesc;
    private final String getterDesc;
    private boolean found = false;
    private boolean isStaticField = false;
    private String actualFieldName;
    private Type actualFieldType;

    public AsmFieldLens(String targetClassName, String targetFieldName, Type expectedTargetFieldType, boolean isMandatory, boolean createField, String setterDesc, String getterDesc) {
        this.targetClassName = targetClassName;
        this.targetFieldName = targetFieldName;
        this.expectedTargetFieldTypeDescriptors = Stream.of(expectedTargetFieldType, (Type)AsmUtils.objectToPrimitive.get((Object)expectedTargetFieldType)).filter(Objects::nonNull).map(Type::getDescriptor).collect(Collectors.toSet());
        this.boxedType = expectedTargetFieldType;
        this.isMandatory = isMandatory;
        this.createField = createField;
        this.actualFieldName = targetFieldName;
        this.actualFieldType = expectedTargetFieldType;
        this.setterDesc = setterDesc;
        this.getterDesc = getterDesc;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    public String getPatchedFieldName() {
        return this.targetClassName + '#' + this.targetFieldName + " " + this.actualFieldType.getDescriptor() + " (actually named " + this.actualFieldName + ")";
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public boolean needToCreate() {
        return true;
    }

    public void foundExistedField(String name, int access, String desc) {
        this.found = true;
        this.isStaticField = AsmUtils.isStatic(access);
        this.actualFieldName = name;
        this.actualFieldType = Type.getType((String)desc);
    }

    @Override
    public void create(HookInjectorClassVisitor hookInjectorClassVisitor) {
        if (!this.found) {
            if (this.createField) {
                hookInjectorClassVisitor.visitField(0, this.actualFieldName, this.actualFieldType.getDescriptor(), null, null).visitEnd();
            } else {
                return;
            }
        }
        MethodVisitor mv = hookInjectorClassVisitor.visitMethod(9, this.targetFieldName + setterSuffix, this.setterDesc, null, null);
        mv.visitCode();
        mv.visitLabel(new Label());
        if (!this.isStaticField) {
            mv.visitVarInsn(25, 0);
        }
        mv.visitVarInsn(this.boxedType.getOpcode(21), 1);
        if (!this.boxedType.equals((Object)this.actualFieldType)) {
            mv.visitMethodInsn(182, this.boxedType.getInternalName(), AsmUtils.primitiveToUnboxingMethod.get(this.actualFieldType), Type.getMethodDescriptor((Type)this.actualFieldType, (Type[])new Type[0]), false);
        }
        mv.visitFieldInsn(this.isStaticField ? 179 : 181, this.getTargetClassInternalName(), this.actualFieldName, this.actualFieldType.getDescriptor());
        mv.visitInsn(177);
        mv.visitLabel(new Label());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = hookInjectorClassVisitor.visitMethod(9, this.targetFieldName + getterSuffix, this.getterDesc, null, null);
        mv.visitCode();
        mv.visitLabel(new Label());
        if (!this.isStaticField) {
            mv.visitVarInsn(25, 0);
        }
        mv.visitFieldInsn(this.isStaticField ? 178 : 180, this.getTargetClassInternalName(), this.actualFieldName, this.actualFieldType.getDescriptor());
        if (!this.boxedType.equals((Object)this.actualFieldType)) {
            mv.visitMethodInsn(184, this.boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor((Type)this.boxedType, (Type[])new Type[]{this.actualFieldType}), false);
        }
        mv.visitInsn(this.boxedType.getOpcode(172));
        mv.visitLabel(new Label());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        hookInjectorClassVisitor.markInjected(this);
    }

    @Override
    public int compareTo(AsmInjection o) {
        if (o instanceof AsmFieldLens) {
            if (this.createField) {
                return -1;
            }
            return ((AsmFieldLens)o).createField ? 1 : 0;
        }
        return AsmInjection.super.compareTo(o);
    }

    public boolean isTargetField(String name, String desc) {
        return name.equals(this.targetFieldName) && this.expectedTargetFieldTypeDescriptors.contains(desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsmFieldLens lens = (AsmFieldLens)o;
        return this.isMandatory == lens.isMandatory && this.createField == lens.createField && this.targetClassName.equals(lens.targetClassName) && this.targetFieldName.equals(lens.targetFieldName) && this.boxedType.equals((Object)lens.boxedType);
    }

    public int hashCode() {
        return Objects.hash(this.targetClassName, this.targetFieldName, this.boxedType, this.isMandatory, this.createField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsmLens: ");
        sb.append(this.targetClassName).append('#').append(this.targetFieldName).append(": ");
        sb.append(this.boxedType);
        sb.append(", CreateField = " + this.createField);
        return sb.toString();
    }
}

