/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;

public class TypeHelper {
    private static final Map<String, Type> primitiveTypes = new HashMap<String, Type>(9);

    public static Type getType(String className) {
        Type primitive = primitiveTypes.get(className);
        return Type.getType((String)(primitive != null ? primitive.getDescriptor() : "L" + className.replace(".", "/") + ";"));
    }

    static {
        primitiveTypes.put("void", Type.VOID_TYPE);
        primitiveTypes.put("boolean", Type.BOOLEAN_TYPE);
        primitiveTypes.put("byte", Type.BYTE_TYPE);
        primitiveTypes.put("short", Type.SHORT_TYPE);
        primitiveTypes.put("char", Type.CHAR_TYPE);
        primitiveTypes.put("int", Type.INT_TYPE);
        primitiveTypes.put("float", Type.FLOAT_TYPE);
        primitiveTypes.put("long", Type.LONG_TYPE);
        primitiveTypes.put("double", Type.DOUBLE_TYPE);
    }
}

