/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SignatureExtractor {
    public static TypeRepr fromReturnType(MethodNode methodNode) {
        if (methodNode.signature == null) {
            return new FlatTypeRepr(Type.getMethodType((String)methodNode.desc).getReturnType());
        }
        ReturnTypeVisitor v = new ReturnTypeVisitor();
        new SignatureReader(methodNode.signature).accept((SignatureVisitor)v);
        return v.result;
    }

    public static TypeRepr fromField(FieldNode fieldNode) {
        if (fieldNode.signature == null) {
            return new FlatTypeRepr(Type.getType((String)fieldNode.desc));
        }
        AtomicReference result = new AtomicReference();
        new SignatureReader(fieldNode.signature).acceptType((SignatureVisitor)new ParametrizedVisitor(result::set));
        return (TypeRepr)result.get();
    }

    private static class ParametrizedVisitor
    extends SignatureVisitor {
        private final Consumer<TypeRepr> addParameter;
        Type rawType;
        List<TypeRepr> parameters = new ArrayList<TypeRepr>();

        public ParametrizedVisitor(Consumer<TypeRepr> addParameter) {
            super(327680);
            this.addParameter = addParameter;
        }

        public void visitClassType(String name) {
            this.rawType = Type.getObjectType((String)name);
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return new ParametrizedVisitor(this.parameters::add);
        }

        public void visitEnd() {
            if (this.parameters.isEmpty()) {
                this.addParameter.accept(new FlatTypeRepr(this.rawType));
            } else {
                this.addParameter.accept(new ParametrizedTypeRepr(this.rawType, this.parameters));
            }
        }
    }

    private static class ReturnTypeVisitor
    extends SignatureVisitor {
        public TypeRepr result;

        public ReturnTypeVisitor() {
            super(327680);
        }

        public SignatureVisitor visitReturnType() {
            return new ParametrizedVisitor(t -> {
                this.result = t;
            });
        }
    }

    public static class FlatTypeRepr
    implements TypeRepr {
        public final Type type;

        public FlatTypeRepr(Type type) {
            this.type = type;
        }

        public String toString() {
            return "FlatTypeRepr{type=" + this.type + '}';
        }

        @Override
        public Type getRawType() {
            return this.type;
        }
    }

    public static class ParametrizedTypeRepr
    implements TypeRepr {
        public final Type rawType;
        public final List<TypeRepr> parameters;

        public ParametrizedTypeRepr(Type rawType, List<TypeRepr> parameters) {
            this.rawType = rawType;
            this.parameters = parameters;
        }

        public String toString() {
            return "ParametrizedTypeRepr{rawType=" + this.rawType + ", parameters=" + this.parameters + '}';
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }
    }

    public static interface TypeRepr {
        public Type getRawType();
    }
}

