/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.api.Shift;
import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.injections.AsmHook;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import gloomyfolken.hooklib.helper.Logger;
import gloomyfolken.hooklib.minecraft.Deobfuscation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class HookInjectorMethodVisitor
extends AdviceAdapter {
    protected final AsmMethodInjection hook;
    public final HookInjectorClassVisitor cv;
    public final String methodName;
    public final Type methodType;
    public final boolean isStatic;

    protected HookInjectorMethodVisitor(MethodVisitor mv, int access, String name, String desc, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
        super(327680, mv, access, name, desc);
        this.hook = hook;
        this.cv = cv;
        this.isStatic = (access & 8) != 0;
        this.methodName = name;
        this.methodType = Type.getMethodType((String)desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        if (this.hook.isRequiredPrintLocalVariables()) {
            Logger.instance.info(this.methodName + ":  @LocalVariable(" + index + ") " + Type.getType((String)desc).getClassName() + " " + name);
        }
    }

    protected final void visitHook() {
        if (!this.cv.visitingHook) {
            this.cv.visitingHook = true;
            this.hook.inject(this);
            this.cv.visitingHook = false;
            this.cv.markInjected(this.hook);
        }
    }

    private static int getPopOpcode(Type argumentType) {
        return argumentType == Type.LONG_TYPE || argumentType == Type.DOUBLE_TYPE ? 88 : 87;
    }

    static class ExpressionVisitor
    extends MethodNode {
        private final MethodVisitor targetVisitor;
        private final AsmMethodInjection hook;
        private final HookInjectorClassVisitor cv;
        private final List<AbstractInsnNode> expressionPattern;
        private final Set<Integer> suitableOrdinal;
        private final boolean allSuitable;
        private final Shift shift;
        private final Type patternType;

        public ExpressionVisitor(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv, List<AbstractInsnNode> expressionPattern, int[] ordinal, Shift shift, Type patternType) {
            super(327680, access, name, desc, signature, exceptions);
            this.targetVisitor = mv;
            this.hook = hook;
            this.cv = cv;
            this.expressionPattern = expressionPattern;
            this.suitableOrdinal = Arrays.stream(ordinal).boxed().collect(Collectors.toSet());
            this.allSuitable = this.suitableOrdinal.isEmpty() || this.suitableOrdinal.contains(-1);
            this.shift = shift;
            this.patternType = patternType;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
            if (this.hook.isRequiredPrintLocalVariables()) {
                Logger.instance.info(this.name + ":  @LocalVariable(" + index + ") " + Type.getType((String)desc).getClassName() + " " + name);
            }
        }

        public void visitEnd() {
            List<Pair<AbstractInsnNode, AbstractInsnNode>> foundNodes = this.findSimilarCode();
            if (this.allSuitable) {
                for (Pair<AbstractInsnNode, AbstractInsnNode> e : foundNodes) {
                    this.insertExpressionInjectCall(e);
                }
                if (foundNodes.size() > 0) {
                    this.cv.markInjected(this.hook);
                }
            } else {
                boolean allInjected = true;
                for (Integer ordinal : this.suitableOrdinal) {
                    if (foundNodes.size() > ordinal) {
                        this.insertExpressionInjectCall(foundNodes.get(ordinal));
                        continue;
                    }
                    allInjected = false;
                }
                if (allInjected) {
                    this.cv.markInjected(this.hook);
                }
            }
            this.accept(this.targetVisitor);
        }

        private void insertExpressionInjectCall(Pair<AbstractInsnNode, AbstractInsnNode> found) {
            switch (this.shift) {
                case BEFORE: {
                    this.instructions.insertBefore((AbstractInsnNode)found.getLeft(), this.hook.injectNode(this, this.cv));
                    break;
                }
                case INSTEAD: {
                    this.instructions.insert((AbstractInsnNode)found.getRight(), this.hook.injectNode(this, this.cv));
                    this.instructions.insert((AbstractInsnNode)found.getRight(), (AbstractInsnNode)new InsnNode(HookInjectorMethodVisitor.getPopOpcode(this.patternType.getReturnType())));
                    break;
                }
                case AFTER: {
                    this.instructions.insert((AbstractInsnNode)found.getRight(), this.hook.injectNode(this, this.cv));
                }
            }
        }

        private List<Pair<AbstractInsnNode, AbstractInsnNode>> findSimilarCode() {
            ArrayList<Pair<AbstractInsnNode, AbstractInsnNode>> r = new ArrayList<Pair<AbstractInsnNode, AbstractInsnNode>>();
            HashMap<Integer, Integer> variableColors = new HashMap<Integer, Integer>();
            HashMap<LabelNode, LabelNode> jumpColors = new HashMap<LabelNode, LabelNode>();
            AbstractInsnNode start = null;
            int findingPosition = 0;
            AbstractInsnNode current = this.instructions.getFirst();
            while (current != null) {
                if (AsmUtils.isPatternSensitive(current)) {
                    AbstractInsnNode currentExpectation = this.expressionPattern.get(findingPosition);
                    if (findingPosition == 0) {
                        start = current;
                    }
                    if (this.fuzzyEquals(current, currentExpectation, variableColors, jumpColors)) {
                        if (++findingPosition == this.expressionPattern.size()) {
                            r.add((Pair<AbstractInsnNode, AbstractInsnNode>)Pair.of((Object)start, (Object)current));
                            findingPosition = 0;
                            variableColors.clear();
                            jumpColors.clear();
                        }
                        current = current.getNext();
                        continue;
                    }
                    findingPosition = 0;
                    variableColors.clear();
                    jumpColors.clear();
                    current = start.getNext();
                    continue;
                }
                current = current.getNext();
            }
            return r;
        }

        private boolean fuzzyEquals(AbstractInsnNode current, AbstractInsnNode currentExpectation, Map<Integer, Integer> variableColors, Map<LabelNode, LabelNode> jumpColors) {
            if (current instanceof VarInsnNode && currentExpectation instanceof VarInsnNode) {
                return this.equalsWithVarColor((VarInsnNode)current, (VarInsnNode)currentExpectation, i -> i.var, variableColors);
            }
            if (current instanceof JumpInsnNode && currentExpectation instanceof JumpInsnNode) {
                return this.equalsWithVarColor((JumpInsnNode)current, (JumpInsnNode)currentExpectation, i -> i.label, jumpColors);
            }
            return current.getType() == currentExpectation.getType() && EqualsBuilder.reflectionEquals((Object)current, (Object)currentExpectation, (String[])new String[]{"prev", "next", "index", "previousInsn", "nextInsn"});
        }

        private <A, Node extends AbstractInsnNode> boolean equalsWithVarColor(Node current, Node currentExpectation, Function<Node, A> colorExtractor, Map<A, A> colorCompliance) {
            if (current.getOpcode() == currentExpectation.getOpcode()) {
                boolean colorEquals;
                A patternColor = colorExtractor.apply(currentExpectation);
                A currentColor = colorExtractor.apply(current);
                A ePair = colorCompliance.get(patternColor);
                if (ePair == null) {
                    if (!colorCompliance.containsValue(currentColor)) {
                        colorCompliance.put(patternColor, currentColor);
                        colorEquals = true;
                    } else {
                        colorEquals = false;
                    }
                } else {
                    colorEquals = ePair == currentColor;
                }
                return colorEquals;
            }
            return false;
        }
    }

    static class MethodCallVisitor
    extends OrderedVisitor {
        private final String requiredMethodName;
        private final String methodDesc;
        private final Shift shift;

        protected MethodCallVisitor(MethodVisitor mv, int access, String name, String desc, AsmMethodInjection hook, HookInjectorClassVisitor cv, String methodName, String methodDesc, int[] ordinal, Shift shift) {
            super(mv, access, name, desc, hook, cv, ordinal);
            this.requiredMethodName = methodName;
            this.methodDesc = methodDesc;
            this.shift = shift;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            String actualMethodName = Deobfuscation.instance.deobfMethod(name);
            if (this.requiredMethodName.equals(actualMethodName) && (this.methodDesc.isEmpty() || desc.startsWith(this.methodDesc)) && (this.shift != Shift.INSTEAD || !(this.hook instanceof AsmHook) || Type.getMethodType((String)desc).getReturnType().equals((Object)((AsmHook)this.hook).hookMethodReturnType))) {
                switch (this.shift) {
                    case BEFORE: {
                        this.visitOrderedHook();
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        break;
                    }
                    case AFTER: {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        this.visitOrderedHook();
                        break;
                    }
                    case INSTEAD: {
                        if (this.canVisitOrderedHook()) {
                            Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                            for (int i = argumentTypes.length - 1; i >= 0; --i) {
                                this.visitInsn(HookInjectorMethodVisitor.getPopOpcode(argumentTypes[i]));
                            }
                            if (opcode != 184) {
                                this.visitInsn(87);
                            }
                            this.visitHook();
                            break;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    static class ReturnVisitor
    extends OrderedVisitor {
        public ReturnVisitor(MethodVisitor mv, int access, String name, String desc, AsmMethodInjection hook, HookInjectorClassVisitor cv, int[] ordinal) {
            super(mv, access, name, desc, hook, cv, ordinal);
        }

        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.visitOrderedHook();
            }
        }
    }

    static class BeginVisitor
    extends HookInjectorMethodVisitor {
        public BeginVisitor(MethodVisitor mv, int access, String name, String desc, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
        }

        protected void onMethodEnter() {
            this.visitHook();
        }
    }

    static class OrderedVisitor
    extends HookInjectorMethodVisitor {
        private final Set<Integer> suitableOrdinal;
        private final boolean allSuitable;
        private int currentOrdinal = -1;

        protected OrderedVisitor(MethodVisitor mv, int access, String name, String desc, AsmMethodInjection hook, HookInjectorClassVisitor cv, int[] ordinal) {
            super(mv, access, name, desc, hook, cv);
            this.suitableOrdinal = Arrays.stream(ordinal).boxed().collect(Collectors.toSet());
            this.allSuitable = this.suitableOrdinal.isEmpty() || this.suitableOrdinal.contains(-1);
        }

        protected boolean canVisitOrderedHook() {
            ++this.currentOrdinal;
            return this.allSuitable || this.suitableOrdinal.contains(this.currentOrdinal);
        }

        protected boolean visitOrderedHook() {
            if (this.canVisitOrderedHook()) {
                this.visitHook();
                return true;
            }
            return false;
        }
    }
}

