/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.api.Shift;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.HookInjectorMethodVisitor;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjectionObserving;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public abstract class HookInjectorFactory {
    public boolean isPriorityInverted = false;

    abstract MethodVisitor createHookInjector(MethodVisitor var1, int var2, String var3, String var4, String var5, String[] var6, AsmMethodInjection var7, HookInjectorClassVisitor var8);

    static final class ExpressionFactory
    extends HookInjectorFactory {
        public final List<AbstractInsnNode> expressionPattern;
        public final Shift shift;
        public final int[] ordinal;
        public final Type patternType;

        @Override
        MethodVisitor createHookInjector(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            return new HookInjectorMethodVisitor.ExpressionVisitor(mv, access, name, desc, signature, exceptions, hook, cv, this.expressionPattern, this.ordinal, this.shift, this.patternType);
        }

        public ExpressionFactory(List<AbstractInsnNode> expressionPattern, Shift shift, int[] ordinal, Type patternType) {
            this.expressionPattern = expressionPattern;
            this.shift = shift;
            this.ordinal = ordinal;
            this.patternType = patternType;
        }

        public List<AbstractInsnNode> getExpressionPattern() {
            return this.expressionPattern;
        }

        public Shift getShift() {
            return this.shift;
        }

        public int[] getOrdinal() {
            return this.ordinal;
        }

        public Type getPatternType() {
            return this.patternType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionFactory)) {
                return false;
            }
            ExpressionFactory other = (ExpressionFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AbstractInsnNode> this$expressionPattern = this.getExpressionPattern();
            List<AbstractInsnNode> other$expressionPattern = other.getExpressionPattern();
            if (this$expressionPattern == null ? other$expressionPattern != null : !((Object)this$expressionPattern).equals(other$expressionPattern)) {
                return false;
            }
            Shift this$shift = this.getShift();
            Shift other$shift = other.getShift();
            if (this$shift == null ? other$shift != null : !((Object)((Object)this$shift)).equals((Object)other$shift)) {
                return false;
            }
            if (!Arrays.equals(this.getOrdinal(), other.getOrdinal())) {
                return false;
            }
            Type this$patternType = this.getPatternType();
            Type other$patternType = other.getPatternType();
            return !(this$patternType == null ? other$patternType != null : !this$patternType.equals(other$patternType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpressionFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AbstractInsnNode> $expressionPattern = this.getExpressionPattern();
            result = result * 59 + ($expressionPattern == null ? 43 : ((Object)$expressionPattern).hashCode());
            Shift $shift = this.getShift();
            result = result * 59 + ($shift == null ? 43 : ((Object)((Object)$shift)).hashCode());
            result = result * 59 + Arrays.hashCode(this.getOrdinal());
            Type $patternType = this.getPatternType();
            result = result * 59 + ($patternType == null ? 43 : $patternType.hashCode());
            return result;
        }

        public String toString() {
            return "HookInjectorFactory.ExpressionFactory(expressionPattern=" + this.getExpressionPattern() + ", shift=" + (Object)((Object)this.getShift()) + ", ordinal=" + Arrays.toString(this.getOrdinal()) + ", patternType=" + this.getPatternType() + ")";
        }
    }

    static final class MethodCallFactory
    extends HookInjectorFactory {
        public final String methodName;
        public final String methodDesc;
        public final int[] ordinal;
        public final Shift shift;

        @Override
        MethodVisitor createHookInjector(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            return new HookInjectorMethodVisitor.MethodCallVisitor(mv, access, name, desc, hook, cv, this.methodName, this.methodDesc, this.ordinal, this.shift);
        }

        public MethodCallFactory(String methodName, String methodDesc, int[] ordinal, Shift shift) {
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.ordinal = ordinal;
            this.shift = shift;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDesc() {
            return this.methodDesc;
        }

        public int[] getOrdinal() {
            return this.ordinal;
        }

        public Shift getShift() {
            return this.shift;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodCallFactory)) {
                return false;
            }
            MethodCallFactory other = (MethodCallFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$methodDesc = this.getMethodDesc();
            String other$methodDesc = other.getMethodDesc();
            if (this$methodDesc == null ? other$methodDesc != null : !this$methodDesc.equals(other$methodDesc)) {
                return false;
            }
            if (!Arrays.equals(this.getOrdinal(), other.getOrdinal())) {
                return false;
            }
            Shift this$shift = this.getShift();
            Shift other$shift = other.getShift();
            return !(this$shift == null ? other$shift != null : !((Object)((Object)this$shift)).equals((Object)other$shift));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodCallFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $methodDesc = this.getMethodDesc();
            result = result * 59 + ($methodDesc == null ? 43 : $methodDesc.hashCode());
            result = result * 59 + Arrays.hashCode(this.getOrdinal());
            Shift $shift = this.getShift();
            result = result * 59 + ($shift == null ? 43 : ((Object)((Object)$shift)).hashCode());
            return result;
        }

        public String toString() {
            return "HookInjectorFactory.MethodCallFactory(methodName=" + this.getMethodName() + ", methodDesc=" + this.getMethodDesc() + ", ordinal=" + Arrays.toString(this.getOrdinal()) + ", shift=" + (Object)((Object)this.getShift()) + ")";
        }
    }

    public static class ReturnFactory
    extends HookInjectorFactory {
        public final int[] ordinal;

        public ReturnFactory(int[] ordinal) {
            this.ordinal = ordinal;
            this.isPriorityInverted = true;
        }

        @Override
        public MethodVisitor createHookInjector(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            return new HookInjectorMethodVisitor.ReturnVisitor(mv, access, name, desc, hook, cv, this.ordinal);
        }
    }

    public static class BeginFactory
    extends HookInjectorFactory {
        public static final BeginFactory INSTANCE = new BeginFactory();

        private BeginFactory() {
        }

        @Override
        public MethodVisitor createHookInjector(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            return new HookInjectorMethodVisitor.BeginVisitor(mv, access, name, desc, hook, cv);
        }
    }

    public static class ObservingFactory
    extends HookInjectorFactory {
        public static final ObservingFactory INSTANCE = new ObservingFactory();

        @Override
        MethodVisitor createHookInjector(MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions, AsmMethodInjection hook, HookInjectorClassVisitor cv) {
            if (hook instanceof AsmMethodInjectionObserving) {
                ((AsmMethodInjectionObserving)hook).visitedMethod(access, name, desc, signature, exceptions);
                return mv;
            }
            throw new IllegalArgumentException("ObservingFactory should be used only with AsmMethodInjectionObserving");
        }
    }
}

