/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.asm.HookClassTransformer;
import gloomyfolken.hooklib.asm.injections.AsmFieldLens;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import gloomyfolken.hooklib.asm.injections.AsmMethodInjection;
import gloomyfolken.hooklib.helper.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class HookInjectorClassVisitor
extends ClassVisitor {
    List<AsmInjection> hooks;
    Set<AsmInjection> injectedHooks = new HashSet<AsmInjection>(1);
    boolean visitingHook;
    public HookClassTransformer transformer;
    String superName;

    public HookInjectorClassVisitor(HookClassTransformer transformer, ClassVisitor finalizeVisitor, List<AsmInjection> hooks) {
        super(327680, finalizeVisitor);
        this.hooks = hooks;
        this.transformer = transformer;
    }

    public void markInjected(AsmInjection injection) {
        this.injectedHooks.add(injection);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        for (AsmInjection injection : this.hooks) {
            AsmFieldLens lens;
            if (!(injection instanceof AsmFieldLens) || !this.isTargetField(lens = (AsmFieldLens)injection, name, desc)) continue;
            lens.foundExistedField(name, access &= 0xFFFFFFEF, desc);
            Logger.instance.debug("Patching field " + ((AsmFieldLens)injection).getPatchedFieldName());
            return super.visitField(access, name, desc, signature, value);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        for (AsmInjection injection : this.hooks) {
            AsmMethodInjection hook;
            if (!(injection instanceof AsmMethodInjection) || !this.isTargetMethod(hook = (AsmMethodInjection)injection, name, desc) || this.injectedHooks.contains(hook)) continue;
            MethodVisitor prevMV = mv;
            if (prevMV != (mv = hook.getInjectorFactory().createHookInjector(mv, access, name, desc, signature, exceptions, hook, this))) {
                Logger.instance.debug("Patching method " + hook.getPatchedMethodName(name, desc));
                continue;
            }
            Logger.instance.debug("Observing method " + hook.getPatchedMethodName(name, desc));
        }
        return mv;
    }

    public void visitEnd() {
        for (AsmInjection injection : this.hooks) {
            if (!injection.needToCreate() || this.injectedHooks.contains(injection)) continue;
            injection.create(this);
        }
        super.visitEnd();
    }

    protected boolean isTargetMethod(AsmMethodInjection hook, String name, String desc) {
        return hook.isTargetMethod(name, desc);
    }

    protected boolean isTargetField(AsmFieldLens lens, String name, String desc) {
        return lens.isTargetField(name, desc);
    }
}

