/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import gloomyfolken.hooklib.api.FieldAccessor;
import gloomyfolken.hooklib.api.FieldLens;
import gloomyfolken.hooklib.api.Hook;
import gloomyfolken.hooklib.api.LocalVariable;
import gloomyfolken.hooklib.api.MethodLens;
import gloomyfolken.hooklib.api.OnBegin;
import gloomyfolken.hooklib.api.OnExpression;
import gloomyfolken.hooklib.api.OnMethodCall;
import gloomyfolken.hooklib.api.OnReturn;
import gloomyfolken.hooklib.api.Primitive;
import gloomyfolken.hooklib.api.PrintLocalVariables;
import gloomyfolken.hooklib.api.ReturnSolve;
import gloomyfolken.hooklib.api.ReturnValue;
import gloomyfolken.hooklib.api.Shift;
import gloomyfolken.hooklib.asm.AsmUtils;
import gloomyfolken.hooklib.asm.HookInjectorFactory;
import gloomyfolken.hooklib.asm.ReturnCondition;
import gloomyfolken.hooklib.asm.SignatureExtractor;
import gloomyfolken.hooklib.asm.injections.AsmFieldLens;
import gloomyfolken.hooklib.asm.injections.AsmFieldLensHook;
import gloomyfolken.hooklib.asm.injections.AsmFieldLensInit;
import gloomyfolken.hooklib.asm.injections.AsmHook;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import gloomyfolken.hooklib.asm.injections.AsmMethodLens;
import gloomyfolken.hooklib.asm.injections.AsmMethodLensHook;
import gloomyfolken.hooklib.helper.Logger;
import gloomyfolken.hooklib.helper.SideOnlyUtils;
import gloomyfolken.hooklib.helper.annotation.AnnotationMap;
import gloomyfolken.hooklib.helper.annotation.AnnotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class HookContainerParser {
    private static Set<Integer> forbiddenDefaultValueOpcodes = ImmutableSet.builder().add((Object)0).add((Object)167).add((Object)168).add((Object)169).add((Object)170).add((Object)171).add((Object)171).add((Object)172).add((Object)173).add((Object)174).add((Object)175).add((Object)176).add((Object)177).add((Object)179).add((Object)181).add((Object)153).add((Object)154).add((Object)155).add((Object)156).add((Object)157).add((Object)158).add((Object)159).add((Object)160).add((Object)161).add((Object)162).add((Object)163).add((Object)164).add((Object)165).add((Object)166).add((Object)191).add((Object)194).add((Object)195).add((Object)198).add((Object)199).add((Object)132).build();

    private static Stream<AsmHook> invalidHook(String message, ClassNode classNode, MethodNode methodNode) {
        Logger.instance.warning("Found invalid hook " + classNode.name.replace('/', '.') + "#" + methodNode.name);
        Logger.instance.warning(message);
        return Stream.empty();
    }

    private static Stream<AsmHook> invalidFieldLens(String message, ClassNode classNode, FieldNode fieldNode) {
        Logger.instance.warning("Found invalid hook lens " + classNode.name.replace('/', '.') + "#" + fieldNode.name);
        Logger.instance.warning(message);
        return Stream.empty();
    }

    private static Stream<AsmInjection> invalidMethodLens(String message, ClassNode classNode, MethodNode methodNode) {
        Logger.instance.warning("Found invalid hook lens " + classNode.name.replace('/', '.') + "#" + methodNode.name);
        Logger.instance.warning(message);
        return Stream.empty();
    }

    private static boolean checkRegularConditions(ClassNode classNode, MethodNode methodNode, Type[] argumentTypes) {
        if (!AsmUtils.isPublic(methodNode) || !AsmUtils.isStatic(methodNode)) {
            HookContainerParser.invalidHook("Hook method must be public and static.", classNode, methodNode);
            return false;
        }
        if (argumentTypes.length < 1) {
            HookContainerParser.invalidHook("Hook method has no parameters. First parameter of a hook method must belong the type of the target class.", classNode, methodNode);
            return false;
        }
        if (argumentTypes[0].getSort() != 10) {
            HookContainerParser.invalidHook("First parameter of the hook method is not an object. First parameter of a hook method must belong the type of the target class.", classNode, methodNode);
            return false;
        }
        return true;
    }

    private static boolean checkRegularConditionsMethodLens(ClassNode classNode, MethodNode methodNode, Type[] argumentTypes) {
        if (!AsmUtils.isStatic(methodNode)) {
            HookContainerParser.invalidMethodLens("Hook lens must be static.", classNode, methodNode);
            return false;
        }
        if (argumentTypes.length < 1) {
            HookContainerParser.invalidMethodLens("Hook lens has no parameters. First parameter of a lens method must belong the type of the target class.", classNode, methodNode);
            return false;
        }
        if (argumentTypes[0].getSort() != 10) {
            HookContainerParser.invalidMethodLens("First parameter of the hook lens is not an object. First parameter of a lens method must belong the type of the target class.", classNode, methodNode);
            return false;
        }
        return true;
    }

    public static Stream<AsmInjection> parseHooks(ClassNode classNode) {
        Optional<MethodNode> maybeClinit = classNode.methods.stream().filter(mn -> mn.name.equals("<clinit>")).findFirst();
        return Stream.concat(classNode.methods.stream().flatMap(methodNode -> {
            try {
                AnnotationMap annotationMap = AnnotationUtils.annotationOf(methodNode);
                if (!SideOnlyUtils.isValidSide(annotationMap)) {
                    return Stream.empty();
                }
                Hook hookAnnotation = annotationMap.get(Hook.class);
                MethodLens methodLensAnnotation = annotationMap.get(MethodLens.class);
                if (hookAnnotation != null) {
                    return HookContainerParser.parseRegularHook(classNode, methodNode, annotationMap, hookAnnotation);
                }
                if (methodLensAnnotation != null) {
                    return HookContainerParser.parseMethodLens(classNode, methodNode, annotationMap, methodLensAnnotation);
                }
            }
            catch (Throwable e) {
                throw new UnexpectedHookParsingError(classNode.name, methodNode.name, e);
            }
            return Stream.empty();
        }), classNode.fields.stream().flatMap(fieldNode -> {
            AnnotationMap annotationMap = AnnotationUtils.annotationOf(fieldNode);
            FieldLens lensAnnotation = annotationMap.get(FieldLens.class);
            if (lensAnnotation != null) {
                return HookContainerParser.parseFieldLens(classNode, fieldNode, lensAnnotation, maybeClinit);
            }
            return Stream.empty();
        }));
    }

    private static Stream<? extends AsmInjection> parseFieldLens(ClassNode classNode, FieldNode fieldNode, FieldLens lensAnnotation, Optional<MethodNode> maybeClinit) {
        if (Type.getType((String)fieldNode.desc).getClassName().equals(FieldAccessor.class.getCanonicalName())) {
            SignatureExtractor.TypeRepr typeRepr = SignatureExtractor.fromField(fieldNode);
            if (typeRepr instanceof SignatureExtractor.FlatTypeRepr) {
                return HookContainerParser.invalidFieldLens("field lens type is raw FieldAccessor, should be parametrized", classNode, fieldNode);
            }
            List<SignatureExtractor.TypeRepr> parameters = ((SignatureExtractor.ParametrizedTypeRepr)typeRepr).parameters;
            Type targetClassType = parameters.get(0).getRawType();
            String targetClassName = targetClassType.getClassName();
            Type targetFieldType = parameters.get(1).getRawType();
            if (fieldNode.invisibleTypeAnnotations != null) {
                for (TypeAnnotationNode a : fieldNode.invisibleTypeAnnotations) {
                    if (!a.desc.equals(Type.getDescriptor(Primitive.class)) || new TypeReference(a.typeRef).getSort() != 19 || a.typePath.getLength() != 1 || a.typePath.getStep(0) != 3 || a.typePath.getStepArgument(0) != 1) continue;
                    Type maybePrimitive = (Type)AsmUtils.objectToPrimitive.get((Object)targetFieldType);
                    if (maybePrimitive == null) {
                        return HookContainerParser.invalidFieldLens("@Primitive used at non-primitive type", classNode, fieldNode);
                    }
                    targetFieldType = maybePrimitive;
                    break;
                }
            }
            String targetFieldName = !lensAnnotation.targetField().isEmpty() ? lensAnnotation.targetField() : fieldNode.name;
            String setterDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{targetClassType, targetFieldType});
            String getterDesc = Type.getMethodDescriptor((Type)targetFieldType, (Type[])new Type[]{targetClassType});
            InsnList defaultValue = lensAnnotation.createField() && maybeClinit.isPresent() ? HookContainerParser.findDefaultValue(maybeClinit.get().instructions, classNode, fieldNode.name, targetFieldType) : null;
            return Stream.concat(Stream.of(new AsmFieldLensHook(classNode.name, fieldNode.name, targetClassName, targetFieldName, targetFieldType, lensAnnotation.isMandatory(), setterDesc, getterDesc), new AsmFieldLens(targetClassName, targetFieldName, targetFieldType, lensAnnotation.isMandatory(), lensAnnotation.createField(), setterDesc, getterDesc)), lensAnnotation.createField() && defaultValue != null ? Stream.of(new AsmFieldLensInit(targetClassName, targetFieldName, targetFieldType, lensAnnotation.isMandatory(), defaultValue)) : Stream.empty());
        }
        return HookContainerParser.invalidFieldLens("field lens type should be FieldAccessor<TargetClass, TargetFieldType>", classNode, fieldNode);
    }

    private static InsnList findDefaultValue(InsnList clinitInstructions, ClassNode classNode, String lensFieldName, Type targetFieldType) {
        ListIterator it = clinitInstructions.iterator();
        while (it.hasNext()) {
            MethodInsnNode wrapperCall;
            AbstractInsnNode prev;
            FieldInsnNode fieldInit;
            AbstractInsnNode current = (AbstractInsnNode)it.next();
            if (!(current instanceof FieldInsnNode) || (fieldInit = (FieldInsnNode)current).getOpcode() != 179 || !fieldInit.name.equals(lensFieldName) || !fieldInit.desc.equals(Type.getDescriptor(FieldAccessor.class))) continue;
            boolean needReport = true;
            it.previous();
            if (it.hasPrevious() && (prev = (AbstractInsnNode)it.previous()) instanceof MethodInsnNode && (wrapperCall = (MethodInsnNode)prev).getOpcode() == 184 && wrapperCall.name.equals("defaultValue") && wrapperCall.owner.equals(Type.getInternalName(FieldAccessor.class))) {
                try {
                    InsnList valueConstruction = HookContainerParser.collectValueConstruction(it, targetFieldType);
                    if (HookContainerParser.normalizeResultType(classNode, lensFieldName, targetFieldType, valueConstruction)) {
                        return valueConstruction;
                    }
                }
                catch (IllegalArgumentException e) {
                    needReport = false;
                    Logger.instance.debug("Known issue with specific opcode in hook lens default value of " + classNode.name.replace('/', '.') + "#" + lensFieldName);
                    e.printStackTrace();
                }
            }
            Logger.instance.warning("Found complicated hook lens default value of " + classNode.name.replace('/', '.') + "#" + lensFieldName);
            Logger.instance.warning("Try to change such way: ");
            Logger.instance.warning("    public static FieldAccessor<A, B> bruh = FieldAccessor.defaultValue(bruhDefaultValueFactory());");
            Logger.instance.warning("    public static B bruhDefaultValueFactory(){");
            Logger.instance.warning("        return someB;");
            Logger.instance.warning("    }");
            if (needReport) {
                Logger.instance.warning("Plz, report about it to https://github.com/hohserg1/HookLib/issues");
            }
            return null;
        }
        return null;
    }

    private static boolean normalizeResultType(ClassNode classNode, String lensFieldName, Type targetFieldType, InsnList valueConstruction) {
        AbstractInsnNode last = valueConstruction.getLast();
        Type resultType = HookContainerParser.getInstructionType(last);
        if (Type.VOID_TYPE.equals((Object)resultType) && last instanceof MethodInsnNode && ((MethodInsnNode)last).name.equals("<init>") && last.getPrevious().getOpcode() == 89) {
            last = last.getPrevious().getPrevious();
            resultType = HookContainerParser.getInstructionType(last);
        }
        if (targetFieldType.equals((Object)resultType)) {
            return true;
        }
        if (targetFieldType.equals(AsmUtils.objectToPrimitive.get((Object)resultType))) {
            if (last instanceof MethodInsnNode && ((MethodInsnNode)last).name.equals("valueOf")) {
                valueConstruction.remove(last);
            } else {
                valueConstruction.add((AbstractInsnNode)new MethodInsnNode(182, resultType.getInternalName(), AsmUtils.primitiveToUnboxingMethod.get(targetFieldType), Type.getMethodDescriptor((Type)targetFieldType, (Type[])new Type[0]), false));
            }
            return true;
        }
        Logger.instance.warning("Wrong type of hook lens default value of " + classNode.name.replace('/', '.') + "#" + lensFieldName);
        Logger.instance.warning("Required " + targetFieldType + " but got " + resultType);
        return false;
    }

    private static Type getInstructionType(AbstractInsnNode i) {
        if (i instanceof MethodInsnNode) {
            Type methodType = Type.getMethodType((String)((MethodInsnNode)i).desc);
            return methodType.getReturnType();
        }
        AsmUtils.OpcodeDetails details = AsmUtils.getOpcodeDetails(i.getOpcode());
        return details.resultType.apply(i);
    }

    private static InsnList collectValueConstruction(ListIterator<AbstractInsnNode> it, Type targetFieldType) {
        AbstractInsnNode prev;
        LinkedList<AbstractInsnNode> collector = new LinkedList<AbstractInsnNode>();
        for (int stackRequired = -1; it.hasPrevious() && stackRequired != 0; stackRequired += HookContainerParser.getStackAffection(prev)) {
            prev = it.previous();
            collector.addFirst(prev.clone((Map)ImmutableMap.of()));
        }
        InsnList r = new InsnList();
        collector.forEach(arg_0 -> ((InsnList)r).add(arg_0));
        return r;
    }

    private static int getStackAffection(AbstractInsnNode prev) {
        if (prev instanceof MethodInsnNode) {
            Type methodType = Type.getMethodType((String)((MethodInsnNode)prev).desc);
            int addition = methodType.getReturnType() != Type.VOID_TYPE ? 1 : 0;
            int consumption = methodType.getArgumentTypes().length + (prev.getOpcode() == 184 ? 0 : 1);
            return addition - consumption;
        }
        if (prev instanceof MultiANewArrayInsnNode) {
            return 1 - ((MultiANewArrayInsnNode)prev).dims;
        }
        if (forbiddenDefaultValueOpcodes.contains(prev.getOpcode())) {
            throw new IllegalArgumentException("opcode " + prev.getOpcode() + " not supported for hook lens default value");
        }
        AsmUtils.OpcodeDetails details = AsmUtils.getOpcodeDetails(prev.getOpcode());
        return details.putToStack - details.consumeFromStack;
    }

    private static Stream<AsmInjection> parseMethodLens(ClassNode classNode, MethodNode methodNode, AnnotationMap annotationMap, MethodLens methodLensAnnotation) {
        Type methodType = Type.getMethodType((String)methodNode.desc);
        Type[] argumentTypes = methodType.getArgumentTypes();
        Type returnType = methodType.getReturnType();
        if (!HookContainerParser.checkRegularConditionsMethodLens(classNode, methodNode, argumentTypes)) {
            return Stream.empty();
        }
        String targetClassName = argumentTypes[0].getClassName();
        String targetMethodName = methodLensAnnotation.targetMethod().isEmpty() ? methodNode.name : methodLensAnnotation.targetMethod();
        String targetMethodDesc = Type.getMethodDescriptor((Type)returnType, (Type[])Arrays.copyOfRange(argumentTypes, 1, argumentTypes.length));
        AsmMethodLens targetClassInjection = new AsmMethodLens(targetClassName, targetMethodName, targetMethodDesc, methodNode.desc, methodLensAnnotation.isMandatory());
        AsmMethodLensHook hookClassInjection = new AsmMethodLensHook(classNode.name, methodNode.name, methodNode.desc, targetClassName, targetMethodName, targetMethodDesc, methodLensAnnotation.isMandatory());
        return Stream.of(targetClassInjection, hookClassInjection);
    }

    private static Stream<AsmHook> parseRegularHook(ClassNode classNode, MethodNode methodNode, AnnotationMap annotationMap, Hook hookAnnotation) {
        AsmHook.Builder builder = AsmHook.newBuilder();
        Type methodType = Type.getMethodType((String)methodNode.desc);
        Type[] argumentTypes = methodType.getArgumentTypes();
        Type returnType = methodType.getReturnType();
        if (!HookContainerParser.checkRegularConditions(classNode, methodNode, argumentTypes)) {
            return Stream.empty();
        }
        builder.setTargetClass(argumentTypes[0].getClassName());
        if (!hookAnnotation.targetMethod().isEmpty()) {
            builder.setTargetMethod(hookAnnotation.targetMethod());
        } else {
            builder.setTargetMethod(methodNode.name);
        }
        builder.setHookClass(classNode.name.replace('/', '.'));
        builder.setHookMethod(methodNode.name);
        builder.addThisToHookMethodParameters();
        int currentParameterId = 1;
        for (int i = 1; i < argumentTypes.length; ++i) {
            Type argType = argumentTypes[i];
            AnnotationMap parameterAnnotations = AnnotationUtils.annotationOfParameter(methodNode, i);
            ReturnValue returnValue = parameterAnnotations.get(ReturnValue.class);
            LocalVariable localVariable = parameterAnnotations.get(LocalVariable.class);
            if (returnValue != null) {
                builder.setTargetMethodReturnType(argType);
                builder.addReturnValueToHookMethodParameters();
                continue;
            }
            if (localVariable != null) {
                builder.addHookMethodParameter(argType, localVariable.id());
                continue;
            }
            builder.addTargetMethodParameters(argType);
            builder.addHookMethodParameter(argType, currentParameterId);
            currentParameterId += argType == Type.LONG_TYPE || argType == Type.DOUBLE_TYPE ? 2 : 1;
        }
        OnBegin onBegin = annotationMap.get(OnBegin.class);
        OnReturn onReturn = annotationMap.get(OnReturn.class);
        OnMethodCall onMethodCall = annotationMap.get(OnMethodCall.class);
        OnExpression onExpression = annotationMap.get(OnExpression.class);
        if (onBegin != null) {
            builder.setInjectorFactory(HookInjectorFactory.BeginFactory.INSTANCE);
        } else if (onReturn != null) {
            builder.setInjectorFactory(new HookInjectorFactory.ReturnFactory(onReturn.ordinal()));
        } else if (onMethodCall != null) {
            builder.setInjectorFactory(new HookInjectorFactory.MethodCallFactory(onMethodCall.value(), onMethodCall.desc(), onMethodCall.ordinal(), onMethodCall.shift()));
        } else if (onExpression != null) {
            String expressionPatternMethodName = onExpression.expressionPattern();
            Optional<MethodNode> maybeExpressionPatternMethod = classNode.methods.stream().filter(mn -> mn.name.equals(expressionPatternMethodName)).findAny();
            if (!maybeExpressionPatternMethod.isPresent()) {
                return HookContainerParser.invalidHook("Expression pattern \"" + expressionPatternMethodName + "\" not found", classNode, methodNode);
            }
            MethodNode expressionPatternMethod = maybeExpressionPatternMethod.get();
            ArrayList<AbstractInsnNode> pattern = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode i : expressionPatternMethod.instructions.toArray()) {
                if (AsmUtils.isReturn(i)) break;
                if (!AsmUtils.isPatternSensitive(i)) continue;
                pattern.add(i);
            }
            builder.setInjectorFactory(new HookInjectorFactory.ExpressionFactory(pattern, onExpression.shift(), onExpression.ordinal(), Type.getMethodType((String)expressionPatternMethod.desc)));
        } else {
            return HookContainerParser.invalidHook("Injection point doesnt described. Use one of @OnBegin,@OnReturn or @OnMethodCall", classNode, methodNode);
        }
        if (returnType == Type.VOID_TYPE || onExpression != null && onExpression.shift() == Shift.INSTEAD || onMethodCall != null && onMethodCall.shift() == Shift.INSTEAD) {
            builder.setReturnCondition(ReturnCondition.NEVER);
        } else if (returnType.getClassName().equals(ReturnSolve.class.getCanonicalName())) {
            SignatureExtractor.TypeRepr typeRepr = SignatureExtractor.fromReturnType(methodNode);
            if (typeRepr instanceof SignatureExtractor.FlatTypeRepr) {
                return HookContainerParser.invalidHook("return type is raw ReturnSolve, should be parametrized", classNode, methodNode);
            }
            Type targetMethodReturnType = ((SignatureExtractor.ParametrizedTypeRepr)typeRepr).parameters.get(0).getRawType();
            if (methodNode.invisibleTypeAnnotations != null) {
                for (TypeAnnotationNode a : methodNode.invisibleTypeAnnotations) {
                    if (!a.desc.equals(Type.getDescriptor(ReturnSolve.Primitive.class)) && !a.desc.equals(Type.getDescriptor(Primitive.class)) || new TypeReference(a.typeRef).getSort() != 20 || a.typePath.getLength() != 1 || a.typePath.getStep(0) != 3 || a.typePath.getStepArgument(0) != 0) continue;
                    Type maybePrimitive = (Type)AsmUtils.objectToPrimitive.get((Object)targetMethodReturnType);
                    if (maybePrimitive == null) {
                        return HookContainerParser.invalidHook("@Primitive used at non-primitive type", classNode, methodNode);
                    }
                    targetMethodReturnType = maybePrimitive;
                    break;
                }
            }
            builder.setTargetMethodReturnType(targetMethodReturnType);
            builder.setReturnCondition(ReturnCondition.ON_SOLVE);
        } else {
            builder.setTargetMethodReturnType(returnType);
            builder.setReturnCondition(ReturnCondition.ALWAYS);
        }
        builder.setHookMethodReturnType(returnType);
        builder.setPriority(hookAnnotation.priority());
        builder.setCreateMethod(hookAnnotation.createMethod());
        builder.setMandatory(hookAnnotation.isMandatory());
        builder.setRequiredPrintLocalVariables(annotationMap.get(PrintLocalVariables.class) != null);
        return Stream.of(builder.build());
    }

    public static class UnexpectedHookParsingError
    extends RuntimeException {
        public UnexpectedHookParsingError(String className, String methodName, Throwable cause) {
            super("while processing " + className + "#" + methodName + ". Plz report to https://github.com/hohserg1/HookLib/issues", cause);
        }
    }
}

