/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import gloomyfolken.hooklib.asm.ClassDumper;
import gloomyfolken.hooklib.asm.ClassMetadataReader;
import gloomyfolken.hooklib.asm.HookInjectorClassVisitor;
import gloomyfolken.hooklib.asm.SafeClassWriter;
import gloomyfolken.hooklib.asm.injections.AsmInjection;
import gloomyfolken.hooklib.helper.Logger;
import gloomyfolken.hooklib.minecraft.HookLoader;
import gloomyfolken.hooklib.minecraft.PrimaryClassTransformer;
import gloomyfolken.hooklib.minecraft.TransformingStage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class HookClassTransformer
implements IClassTransformer {
    private static final ListMultimap<String, AsmInjection> hooksMap = ArrayListMultimap.create((int)10, (int)2);
    public static TransformingStage stage = new PrimaryClassTransformer();
    public ClassMetadataReader classMetadataReader = HookLoader.getDeobfuscationMetadataReader();

    public static void registerAllHooks(ListMultimap<String, AsmInjection> hooks) {
        hooksMap.putAll(hooks);
    }

    private RuntimeException errorFatal(String msg, Throwable e) {
        Logger.instance.error(msg, e);
        return new RuntimeException(msg, e);
    }

    private RuntimeException errorFatal(String msg) {
        Logger.instance.error(msg);
        return new RuntimeException(msg);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        return this.transform(transformedName, basicClass);
    }

    public byte[] transform(String className, byte[] bytecode) {
        if (hooksMap.containsKey((Object)className)) {
            Set<AsmInjection> injectedHooks;
            List hooks = hooksMap.get((Object)className);
            Collections.sort(hooks);
            Logger.instance.debug("Injecting hooks into class " + className);
            try {
                if (bytecode == null) {
                    Logger.instance.error("wtf bytecode null " + className + ". skipping");
                    new RuntimeException().printStackTrace();
                    return bytecode;
                }
                int majorVersion = (bytecode[6] & 0xFF) << 8 | bytecode[7] & 0xFF;
                boolean java7 = majorVersion > 50;
                ClassReader cr = new ClassReader(bytecode);
                ClassWriter cw = this.createClassWriter(java7 ? 2 : 1);
                HookInjectorClassVisitor hooksWriter = this.createInjectorClassVisitor((ClassVisitor)cw, hooks);
                cr.accept((ClassVisitor)hooksWriter, java7 ? 4 : 8);
                bytecode = cw.toByteArray();
                injectedHooks = hooksWriter.injectedHooks;
            }
            catch (Exception e) {
                throw this.errorFatal("A problem has occurred during transformation of class " + className + ". Plz report to https://github.com/hohserg1/HookLib/issues\nAttached hooks: [\n" + this.hooksToString(hooks) + "\n]\nStack trace:", e);
            }
            ArrayList<AsmInjection> mandatoryMissed = new ArrayList<AsmInjection>();
            for (AsmInjection hook : hooks) {
                if (injectedHooks.contains(hook)) continue;
                if (hook.isMandatory()) {
                    mandatoryMissed.add(hook);
                    continue;
                }
                Logger.instance.warning("Can not find target method of hook " + hook);
            }
            ClassDumper.instance.dumpClass(className, bytecode);
            if (!mandatoryMissed.isEmpty()) {
                throw this.errorFatal("Can not find target method of mandatory hooks: [\n" + this.hooksToString(mandatoryMissed) + "\n]");
            }
        }
        return bytecode;
    }

    private String hooksToString(List<AsmInjection> mandatoryMissed) {
        return mandatoryMissed.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    protected HookInjectorClassVisitor createInjectorClassVisitor(ClassVisitor finalizeVisitor, List<AsmInjection> hooks) {
        return stage.createInjectorClassVisitor(this, finalizeVisitor, hooks);
    }

    protected ClassWriter createClassWriter(int flags) {
        return new SafeClassWriter(this.classMetadataReader, flags);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

